/*
 * Decompiled with CFR 0.152.
 */
package com.furglitch.vendingblock.integration.rei;

import com.furglitch.vendingblock.gui.admin.VendorAdminScreen;
import com.furglitch.vendingblock.gui.components.FilterSlot;
import java.util.stream.Stream;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.drag.DraggableStack;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackVisitor;
import me.shedaniel.rei.api.client.gui.drag.DraggedAcceptorResult;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.item.ItemStack;

public class GhostHandlerAdmin
implements DraggableStackVisitor<VendorAdminScreen> {
    public <R extends Screen> boolean isHandingScreen(R screen) {
        return screen instanceof VendorAdminScreen;
    }

    public DraggedAcceptorResult acceptDraggedStack(DraggingContext<VendorAdminScreen> context, DraggableStack stack) {
        Object stackObject = stack.getStack().getValue();
        if (!(stackObject instanceof ItemStack)) {
            return DraggedAcceptorResult.PASS;
        }
        ItemStack itemStack = (ItemStack)stackObject;
        if (itemStack.isEmpty()) {
            return DraggedAcceptorResult.PASS;
        }
        VendorAdminScreen screen = (VendorAdminScreen)context.getScreen();
        int mouseX = context.getCurrentPosition().getX();
        int mouseY = context.getCurrentPosition().getY();
        for (FilterSlot slot : screen.getFilterSlots().stream().filter(s -> s.getSlotIndex() != 0).toList()) {
            int slotX = screen.getGuiLeft() + slot.x;
            int slotY = screen.getGuiTop() + slot.y;
            if (mouseX < slotX || mouseX >= slotX + 16 || mouseY < slotY || mouseY >= slotY + 16) continue;
            slot.set(itemStack);
            return DraggedAcceptorResult.ACCEPTED;
        }
        return DraggedAcceptorResult.PASS;
    }

    public Stream<DraggableStackVisitor.BoundsProvider> getDraggableAcceptingBounds(DraggingContext<VendorAdminScreen> context, DraggableStack stack) {
        VendorAdminScreen screen = (VendorAdminScreen)context.getScreen();
        return screen.getFilterSlots().stream().filter(s -> s.getSlotIndex() != 0).toList().stream().map(slot -> DraggableStackVisitor.BoundsProvider.ofRectangle((Rectangle)new Rectangle(screen.getGuiLeft() + slot.x, screen.getGuiTop() + slot.y, 16, 16)));
    }
}

