/*
 * Decompiled with CFR 0.152.
 */
package at.pcgf.flymod.gui;

import at.pcgf.flymod.gui.FlyModConfig;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import net.fabricmc.loader.api.FabricLoader;

public class FlyModConfigManager {
    private static final Executor EXECUTOR = Executors.newSingleThreadExecutor(r -> new Thread(r, "Flymod Config Manager"));
    private static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().excludeFieldsWithoutExposeAnnotation().create();
    private static FlyModConfig config;
    private static Path configFile;

    public static FlyModConfig getConfig() {
        return config != null ? config : FlyModConfigManager.init();
    }

    public static FlyModConfig init() {
        configFile = FabricLoader.getInstance().getConfigDir().resolve("flymod.json");
        if (!Files.exists(configFile, new LinkOption[0])) {
            System.out.println("Creating flymod config file");
            FlyModConfigManager.save().join();
        }
        ((CompletableFuture)FlyModConfigManager.load().thenApply(c -> {
            config = c;
            return config;
        })).join();
        return Objects.requireNonNull(config, "Failed to initialize flymod config");
    }

    public static CompletableFuture<FlyModConfig> load() {
        return CompletableFuture.supplyAsync(() -> {
            FlyModConfig flyModConfig;
            block8: {
                BufferedReader reader = Files.newBufferedReader(configFile);
                try {
                    flyModConfig = (FlyModConfig)GSON.fromJson((Reader)reader, FlyModConfig.class);
                    if (reader == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (JsonParseException | IOException e) {
                        System.err.println("Unable to read flymod config, restoring defaults");
                        FlyModConfigManager.save();
                        return new FlyModConfig();
                    }
                }
                reader.close();
            }
            return flyModConfig;
        }, EXECUTOR);
    }

    public static CompletableFuture<Void> save() {
        return CompletableFuture.runAsync(() -> {
            config = Optional.ofNullable(config).orElseGet(FlyModConfig::new);
            try (BufferedWriter writer = Files.newBufferedWriter(configFile, new OpenOption[0]);){
                GSON.toJson((Object)config, (Appendable)writer);
            }
            catch (JsonIOException | IOException e) {
                System.err.println("Failed to write flymod config file");
            }
        }, EXECUTOR);
    }
}

