/*
 * Decompiled with CFR 0.152.
 */
package at.pcgf.flymod.mixin;

import at.pcgf.flymod.FlyModImpl;
import at.pcgf.flymod.FlyingState;
import at.pcgf.flymod.gui.FlyModConfigManager;
import com.mojang.authlib.GameProfile;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_742;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector4f;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={class_742.class})
public abstract class PlayerEntityMixin
extends class_1657 {
    public PlayerEntityMixin(class_1937 world, class_2338 pos, float yaw, GameProfile gameProfile) {
        super(world, gameProfile);
        this.method_23327(pos.method_10263(), pos.method_10264(), pos.method_10260());
        this.method_36456(yaw);
    }

    public void method_5784(class_1313 type, class_243 vec3d) {
        class_310 client = class_310.method_1551();
        this.toggleFlying();
        if (this.method_31549().field_7479 && this.isActiveForCurrentGamemode() && this.isActiveForCurrentServer()) {
            boolean backwards = client.field_1690.field_1881.method_1434();
            boolean forwards = client.field_1690.field_1894.method_1434();
            boolean left = client.field_1690.field_1913.method_1434();
            boolean right = client.field_1690.field_1849.method_1434();
            class_243 vec = this.mouseControlMovement(vec3d, backwards, forwards, left, right);
            this.fadeMovement(backwards || forwards || left || right);
            vec = this.verticalMovement(vec);
            vec = this.applyFlyMultiplier(vec);
            this.method_5660(false);
            this.method_5728(false);
            super.method_5784(type, vec);
        } else if (!this.method_31549().field_7479 && this.isActiveForCurrentGamemode() && this.isActiveForCurrentServer()) {
            class_243 vec = vec3d;
            if (client.field_1690.field_1867.method_1434() || ((Boolean)client.field_1690.method_42450().method_41753()).booleanValue()) {
                if (!FlyModConfigManager.getConfig().overrideExhaustion || this.isMultiplayer()) {
                    this.method_5728(true);
                    vec = this.applyRunMultiplier(vec, FlyModConfigManager.getConfig().runSpeedMultiplier - 0.3f);
                } else {
                    this.method_5728(false);
                    vec = this.applyRunMultiplier(vec, FlyModConfigManager.getConfig().runSpeedMultiplier);
                }
                this.method_5796(this.field_7490);
            }
            super.method_5784(type, vec);
        } else {
            super.method_5784(type, vec3d);
        }
    }

    private void toggleFlying() {
        if (!this.isActiveForCurrentGamemode() || !this.isActiveForCurrentServer()) {
            return;
        }
        if (FlyModImpl.flyingState == FlyingState.FLYING) {
            this.method_31549().field_7479 = true;
        } else if (FlyModImpl.flyingState == FlyingState.NEUTRAL) {
            FlyModImpl.flyingState = FlyingState.NOT_FLYING;
            this.method_31549().field_7479 = false;
        } else if (FlyModImpl.flyingState == FlyingState.NOT_FLYING && this.method_31549().field_7479) {
            FlyModImpl.flyingState = FlyingState.FLYING;
        }
        this.method_7355();
    }

    private boolean isActiveForCurrentGamemode() {
        return !FlyModConfigManager.getConfig().onlyForCreative || this.method_31549().field_7477;
    }

    private boolean isActiveForCurrentServer() {
        class_310 client = class_310.method_1551();
        return client.method_1576() != null && client.method_1576().method_3724() && FlyModConfigManager.getConfig().activeInSingleplayer || client.method_1576() == null && this.method_31549().field_7478;
    }

    private boolean isMultiplayer() {
        class_310 client = class_310.method_1551();
        return (client.method_1576() == null || !client.method_1576().method_3724()) && client.method_1576() == null;
    }

    private class_243 mouseControlMovement(class_243 vec3d, boolean backwards, boolean forwards, boolean left, boolean right) {
        if (FlyModConfigManager.getConfig().mouseControl) {
            float pitch = this.field_6004;
            float yaw = this.field_5982;
            Vector4f directionsVector = new Vector4f((float)((backwards ? 1 : 0) - (forwards ? 1 : 0)), 0.0f, (float)((left ? 1 : 0) - (right ? 1 : 0)), 1.0f);
            directionsVector.normalize();
            float length = (float)Math.sqrt(vec3d.method_10216() * vec3d.method_10216() + vec3d.method_10215() * vec3d.method_10215());
            Vector4f movementVector = this.multiply4dVector(directionsVector, length);
            movementVector.rotate((Quaternionfc)this.quaternionOf(0.0f, -(yaw - 90.0f), pitch));
            float resultX = movementVector.x() / movementVector.w();
            float resultY = movementVector.y() / movementVector.w();
            float resultZ = movementVector.z() / movementVector.w();
            return new class_243(Double.isNaN(resultX) ? 0.0 : (double)resultX, Double.isNaN(resultY) ? 0.0 : (double)resultY, Double.isNaN(resultZ) ? 0.0 : (double)resultZ);
        }
        return vec3d;
    }

    private Vector4f multiply4dVector(Vector4f vector, float length) {
        return new Vector4f(vector.x() * length, vector.y() * length, vector.z() * length, vector.w() * length);
    }

    private Quaternionf quaternionOf(float x, float y, float z) {
        float f = org.joml.Math.sin((float)(x *= (float)Math.PI / 360));
        float g = org.joml.Math.cos((float)x);
        float h = org.joml.Math.sin((float)(y *= (float)Math.PI / 360));
        float i = org.joml.Math.cos((float)y);
        float j = org.joml.Math.sin((float)(z *= (float)Math.PI / 360));
        float k = org.joml.Math.cos((float)z);
        return new Quaternionf(f * i * k + g * h * j, g * h * k - f * i * j, f * h * k + g * i * j, g * i * k - f * h * j);
    }

    private void fadeMovement(boolean isMoving) {
        if (FlyModConfigManager.getConfig().mouseControl) {
            return;
        }
        if (!isMoving && !FlyModConfigManager.getConfig().fadeMovement) {
            this.method_5750(new class_243(0.0, 0.0, 0.0));
        }
    }

    private class_243 verticalMovement(class_243 moveVector) {
        double flyUpDownBlocks;
        double y = moveVector.method_10214();
        double d = flyUpDownBlocks = !this.isMultiplayer() ? (double)FlyModConfigManager.getConfig().flyUpDownBlocks : 0.4;
        if (class_310.method_1551().field_1690.field_1832.method_1434() && class_310.method_1551().field_1690.field_1903.method_1434()) {
            y += 0.0;
        } else if (class_310.method_1551().field_1690.field_1832.method_1434()) {
            y -= flyUpDownBlocks;
        } else if (class_310.method_1551().field_1690.field_1903.method_1434()) {
            y += flyUpDownBlocks;
        }
        return new class_243(moveVector.method_10216(), y, moveVector.method_10215());
    }

    private class_243 applyFlyMultiplier(double x, double y, double z) {
        boolean speedEnabled = class_310.method_1551().field_1690.field_1867.method_1434();
        float multiplier = speedEnabled ? FlyModConfigManager.getConfig().flySpeedMultiplier : 1.0f;
        float upDownMultiplier = FlyModConfigManager.getConfig().multiplyUpDown && speedEnabled ? multiplier : 1.0f;
        return new class_243(x *= (double)multiplier, y *= (double)upDownMultiplier, z *= (double)multiplier);
    }

    private class_243 applyFlyMultiplier(class_243 moveVector) {
        if (this.isMultiplayer()) {
            return moveVector;
        }
        return this.applyFlyMultiplier(moveVector.method_10216(), moveVector.method_10214(), moveVector.method_10215());
    }

    private class_243 applyRunMultiplier(class_243 moveVector, float multiplier) {
        if (this.isMultiplayer()) {
            return moveVector;
        }
        return new class_243(moveVector.method_10216() * (double)multiplier, moveVector.method_10214(), moveVector.method_10215() * (double)multiplier);
    }
}

