/*
 * Decompiled with CFR 0.152.
 */
package me.drex.ppb.color;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import me.drex.ppb.PolymerPatchBundleMod;
import me.drex.ppb.res.ResourceHelper;
import net.minecraft.class_1926;
import net.minecraft.class_1933;
import net.minecraft.class_2960;
import net.minecraft.class_7367;

public class ColorMapHelper {
    private static final class_2960 FOLIAGE_LOCATION = class_2960.method_60656((String)"textures/colormap/foliage.png");
    private static final class_2960 GRASS_LOCATION = class_2960.method_60656((String)"textures/colormap/grass.png");

    public static void init() {
        class_7367<InputStream> foliageSupplier = ResourceHelper.getAsset(FOLIAGE_LOCATION.method_12836(), FOLIAGE_LOCATION.method_12832());
        try {
            int[] pixels = ColorMapHelper.getPixels(foliageSupplier);
            class_1926.method_8340((int[])pixels);
        }
        catch (IOException e) {
            PolymerPatchBundleMod.LOGGER.error("Failed to load foliage color map {}", (Object)FOLIAGE_LOCATION, (Object)e);
        }
        class_7367<InputStream> grassSupplier = ResourceHelper.getAsset(GRASS_LOCATION.method_12836(), GRASS_LOCATION.method_12832());
        try {
            int[] pixels = ColorMapHelper.getPixels(grassSupplier);
            class_1933.method_8376((int[])pixels);
        }
        catch (IOException e) {
            PolymerPatchBundleMod.LOGGER.error("Failed to load grass color map {}", (Object)GRASS_LOCATION, (Object)e);
        }
    }

    public static int[] getPixels(class_7367<InputStream> supplier) throws IOException {
        try (InputStream inputStream = (InputStream)supplier.get();){
            BufferedImage img = ImageIO.read(inputStream);
            int[] nArray = img.getRGB(0, 0, img.getWidth(), img.getHeight(), null, 0, img.getWidth());
            return nArray;
        }
    }
}

