/*
 * Decompiled with CFR 0.152.
 */
package me.drex.ppb.res;

import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import eu.pb4.polymer.common.api.PolymerCommonUtils;
import eu.pb4.polymer.resourcepack.api.ResourcePackBuilder;
import eu.pb4.polymer.resourcepack.extras.api.format.blockstate.BlockStateAsset;
import eu.pb4.polymer.resourcepack.extras.api.format.model.ModelAsset;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import me.drex.ppb.PolymerPatchBundleMod;
import net.minecraft.class_2960;
import net.minecraft.class_7367;
import nl.theepicblock.resourcelocatorapi.ResourceLocatorApi;
import nl.theepicblock.resourcelocatorapi.api.AssetContainer;
import org.apache.commons.io.IOUtils;

public class ResourceHelper {
    public static final AssetContainer GLOBAL_ASSETS = ResourceLocatorApi.createGlobalAssetContainer();
    private static final FileSystem vanillaFilesystem;

    public static void init(ResourcePackBuilder packBuilder) {
        GLOBAL_ASSETS.locateFiles("").forEach(tuple -> {
            class_2960 id = (class_2960)tuple.method_15442();
            if (!PolymerPatchBundleMod.MOD_ASSET_IDS.contains(id.method_12836())) {
                return;
            }
            class_7367 ioSupplier = (class_7367)tuple.method_15441();
            try {
                byte[] data = IOUtils.toByteArray((InputStream)((InputStream)ioSupplier.get()));
                packBuilder.addData("assets/" + id.method_12836() + "/" + id.method_12832(), data);
            }
            catch (IOException e) {
                PolymerPatchBundleMod.LOGGER.error("Failed to read resource {}: {}", (Object)id, (Object)e);
            }
        });
    }

    public static class_7367<InputStream> getAsset(String namespace, String path) {
        class_7367 supplier = GLOBAL_ASSETS.getAsset(namespace, path);
        if (supplier != null) {
            return supplier;
        }
        Path vanillaPath = vanillaFilesystem.getPath("/assets/" + namespace + "/" + path, new String[0]);
        if (Files.exists(vanillaPath, new LinkOption[0])) {
            return class_7367.create((Path)vanillaPath);
        }
        return null;
    }

    public static <T> T decodeAsset(Codec<T> codec, class_2960 id, String type, String extension) throws IOException {
        class_7367<InputStream> supplier = ResourceHelper.getAsset(id.method_12836(), type + "/" + id.method_12832() + extension);
        return (T)((Pair)codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((JsonReader)new JsonReader((Reader)new InputStreamReader((InputStream)supplier.get())))).getOrThrow()).getFirst();
    }

    public static BlockStateAsset decodeBlockState(class_2960 id) throws IOException {
        return (BlockStateAsset)ResourceHelper.decodeAsset(BlockStateAsset.CODEC, id, "blockstates", ".json");
    }

    public static ModelAsset decodeModel(class_2960 id) throws IOException {
        return (ModelAsset)ResourceHelper.decodeAsset(ModelAsset.CODEC, id, "models", ".json");
    }

    static {
        try {
            vanillaFilesystem = FileSystems.newFileSystem(PolymerCommonUtils.getClientJar());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

