/*
 * Decompiled with CFR 0.152.
 */
package me.drex.ppb.block;

import eu.pb4.factorytools.api.block.model.generic.BlockStateModelManager;
import eu.pb4.factorytools.api.virtualentity.BlockModel;
import eu.pb4.factorytools.api.virtualentity.ItemDisplayElementUtil;
import eu.pb4.polymer.virtualentity.api.attachment.BlockAwareAttachment;
import eu.pb4.polymer.virtualentity.api.attachment.BlockBoundAttachment;
import eu.pb4.polymer.virtualentity.api.attachment.HolderAttachment;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import java.util.ArrayList;
import java.util.List;
import me.drex.ppb.color.ColorProviderRegistry;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_5819;
import net.minecraft.class_811;
import net.minecraft.class_9294;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class BlockStateModel
extends BlockModel {
    private final List<ItemDisplayElement> modelElements = new ArrayList<ItemDisplayElement>();
    private final float viewRange;
    private boolean shifty = false;

    public BlockStateModel(float viewRange) {
        this.viewRange = viewRange;
    }

    public static BlockStateModel longRange() {
        return new BlockStateModel(100.0f);
    }

    public static BlockStateModel midRange() {
        return new BlockStateModel(3.0f);
    }

    public static BlockStateModel shortRange() {
        return new BlockStateModel(1.1f);
    }

    public BlockStateModel shifty() {
        this.shifty = true;
        return this;
    }

    public void notifyUpdate(HolderAttachment.UpdateType updateType) {
        super.notifyUpdate(updateType);
        if (updateType == BlockAwareAttachment.BLOCK_STATE_UPDATE) {
            this.applyModel(BlockStateModelManager.get((class_2680)this.blockState()), this.blockPos());
        }
    }

    protected void onAttachmentSet(HolderAttachment attachment, @Nullable HolderAttachment oldAttachment) {
        super.onAttachmentSet(attachment, oldAttachment);
        this.applyModel(BlockStateModelManager.get((class_2680)this.blockState()), this.blockPos());
    }

    private void applyModel(List<BlockStateModelManager.ModelGetter> models, class_2338 pos) {
        class_5819 random = class_5819.method_43049((long)this.blockState().method_26190(pos));
        int i = 0;
        while (models.size() < this.modelElements.size()) {
            this.removeElement((VirtualElement)this.modelElements.removeLast());
        }
        while (i < models.size()) {
            ItemDisplayElement element;
            boolean newModel = false;
            if (this.modelElements.size() <= i) {
                element = ItemDisplayElementUtil.createSimple();
                element.setViewRange(this.viewRange);
                element.setTeleportDuration(0);
                element.setItemDisplayContext(class_811.field_4315);
                element.setYaw(180.0f);
                newModel = true;
                this.modelElements.add(element);
            } else {
                element = this.modelElements.get(i);
            }
            BlockStateModelManager.ModelData model = models.get(i).getModel(random);
            element.setItem(model.stack());
            element.setLeftRotation(model.quaternionfc());
            this.setupElement(element, i, pos);
            if (newModel) {
                this.addElement((VirtualElement)element);
            } else {
                element.tick();
            }
            ++i;
        }
    }

    protected void setupElement(ItemDisplayElement element, int i, class_2338 pos) {
        HolderAttachment holderAttachment = this.getAttachment();
        if (!(holderAttachment instanceof BlockBoundAttachment)) {
            return;
        }
        BlockBoundAttachment blockBoundAttachment = (BlockBoundAttachment)holderAttachment;
        int color = ColorProviderRegistry.getColor(this.blockState(), blockBoundAttachment.getChunk(), pos);
        if (color != -1) {
            class_1799 item = element.getItem().method_7972();
            item.method_57379(class_9334.field_49645, (Object)new class_9294(color));
            element.setItem(item);
        }
        if (this.shifty) {
            i = Math.abs((i + pos.method_10263() + pos.method_10264() + pos.method_10260()) % 5);
            element.setOffset(new class_243((double)((float)i / 5000.0f), (double)((float)i / 5000.0f), (double)((float)i / 5000.0f)).method_61888((double)5.0E-4f));
        }
    }
}

