/*
 * Decompiled with CFR 0.152.
 */
package me.drex.ppb.res;

import eu.pb4.factorytools.api.block.model.generic.BlockStateModelManager;
import eu.pb4.factorytools.api.resourcepack.ModelModifiers;
import eu.pb4.polymer.core.api.block.PolymerBlock;
import eu.pb4.polymer.resourcepack.api.AssetPaths;
import eu.pb4.polymer.resourcepack.api.PackResource;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import eu.pb4.polymer.resourcepack.api.ResourcePackBuilder;
import eu.pb4.polymer.resourcepack.api.WritableAsset;
import eu.pb4.polymer.resourcepack.extras.api.format.atlas.AtlasAsset;
import eu.pb4.polymer.resourcepack.extras.api.format.blockstate.BlockStateAsset;
import eu.pb4.polymer.resourcepack.extras.api.format.blockstate.StateModelVariant;
import eu.pb4.polymer.resourcepack.extras.api.format.blockstate.StateMultiPartDefinition;
import eu.pb4.polymer.resourcepack.extras.api.format.model.ModelAsset;
import eu.pb4.polymer.resourcepack.extras.api.format.model.ModelElement;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import me.drex.ppb.PolymerPatchBundleMod;
import me.drex.ppb.res.ResourceHelper;
import net.minecraft.class_151;
import net.minecraft.class_243;
import net.minecraft.class_2960;

public class ResourcePackGenerator {
    private static final class_243 EXPANSION = new class_243(0.08, 0.08, 0.08);
    public static final Set<class_2960> SIGNS = new HashSet<class_2960>();
    public static final Set<class_2960> EXPANDABLE_MODELS = new HashSet<class_2960>();

    public static void setup() {
        PolymerResourcePackUtils.RESOURCE_PACK_AFTER_INITIAL_CREATION_EVENT.register(ResourcePackGenerator::build);
    }

    public static PolymerBlock expandBlockModel(class_2960 id, PolymerBlock polymerBlock) {
        return ResourcePackGenerator.expandBlockModel(id, polymerBlock, x -> true);
    }

    public static PolymerBlock expandBlockModel(class_2960 id, PolymerBlock polymerBlock, Predicate<String> variantPredicate) {
        try {
            BlockStateAsset blockStateAsset = ResourceHelper.decodeBlockState(id);
            Map variants = blockStateAsset.variants().orElse(Collections.emptyMap());
            variants.entrySet().forEach(entry -> {
                if (variantPredicate.test((String)entry.getKey())) {
                    ((List)entry.getValue()).forEach(variant -> ResourcePackGenerator.expandModel(variant.model()));
                }
            });
            List<StateMultiPartDefinition> multiParts = blockStateAsset.multipart().orElse(Collections.emptyList());
            multiParts.forEach(stateMultiPartDefinition -> stateMultiPartDefinition.apply().forEach(stateModelVariant -> ResourcePackGenerator.expandModel(stateModelVariant.model())));
        }
        catch (Throwable e) {
            PolymerPatchBundleMod.LOGGER.error("Failed to read blockstate {}: {}", (Object)id, (Object)e);
        }
        return polymerBlock;
    }

    private static void expandModel(class_2960 id) {
        try {
            EXPANDABLE_MODELS.add(id.method_48331(".json"));
            ModelAsset modelAsset = ResourceHelper.decodeModel(id);
            modelAsset.parent().ifPresent(ResourcePackGenerator::expandModel);
        }
        catch (Throwable e) {
            PolymerPatchBundleMod.LOGGER.error("Failed to read model {}: {}", (Object)id, (Object)e);
        }
    }

    private static void build(ResourcePackBuilder builder) {
        AtlasAsset.Builder atlas = AtlasAsset.builder();
        builder.forEachResource((string, packResource) -> {
            String[] parts = string.split("/", 4);
            if (parts.length < 4) {
                return;
            }
            try {
                class_2960 id = class_2960.method_60655((String)parts[1], (String)parts[3]);
                if (!parts[0].equals("assets") || !parts[2].equals("models")) {
                    return;
                }
                if (!EXPANDABLE_MODELS.contains(id)) {
                    return;
                }
                ModelAsset asset = ModelAsset.fromJson((String)new String(packResource.readAllBytes(), StandardCharsets.UTF_8));
                if (asset.parent().isPresent()) {
                    class_2960 parentId = (class_2960)asset.parent().get();
                    ModelAsset parentAsset = ModelAsset.fromJson((String)new String(Objects.requireNonNull(builder.getDataOrSource(AssetPaths.model((class_2960)parentId) + ".json")), StandardCharsets.UTF_8));
                    builder.addData(AssetPaths.model((String)"polymer-patch-bundle", (String)parentId.method_12832()) + ".json", new ModelAsset(parentAsset.parent(), parentAsset.elements().map(x -> x.stream().map(element -> new ModelElement(element.from().method_1020(EXPANSION), element.to().method_1019(EXPANSION), element.faces(), element.rotation(), element.shade(), element.lightEmission())).toList()), parentAsset.textures(), parentAsset.display(), parentAsset.guiLight(), parentAsset.ambientOcclusion()).toBytes());
                    if (asset.elements().isPresent()) {
                        builder.addData(string, new ModelAsset(asset.parent(), asset.elements().map(x -> x.stream().map(element -> new ModelElement(element.from().method_1020(EXPANSION), element.to().method_1019(EXPANSION), element.faces(), element.rotation(), element.shade(), element.lightEmission())).toList()), asset.textures(), asset.display(), asset.guiLight(), asset.ambientOcclusion()).toBytes());
                    }
                }
            }
            catch (class_151 class_1512) {
                // empty catch block
            }
        });
        PolymerPatchBundleMod.MOD_ASSET_IDS.forEach(modid -> {
            for (Map.Entry entry : BlockStateModelManager.UV_LOCKED_MODELS.getOrDefault(modid, Collections.emptyMap()).entrySet()) {
                String path = (String)entry.getKey();
                class_2960 id = class_2960.method_60655((String)modid, (String)path).method_48331(".json");
                class_243 expand = EXPANDABLE_MODELS.contains(id) ? EXPANSION : class_243.field_1353;
                for (StateModelVariant v : (List)entry.getValue()) {
                    String suffix = "_uvlock_" + v.x() + "_" + v.y();
                    class_2960 modelId = v.model().method_48331(suffix);
                    ModelAsset asset = ModelAsset.fromJson((String)new String(Objects.requireNonNull(builder.getData(AssetPaths.model((class_2960)v.model()) + ".json")), StandardCharsets.UTF_8));
                    if (!asset.parent().isPresent()) continue;
                    class_2960 parentId = (class_2960)asset.parent().get();
                    ModelAsset parentAsset = ModelAsset.fromJson((String)new String(Objects.requireNonNull(builder.getDataOrSource(AssetPaths.model((class_2960)parentId) + ".json")), StandardCharsets.UTF_8));
                    builder.addData(AssetPaths.model((String)"polymer-patch-bundle", (String)(parentId.method_12832() + suffix)) + ".json", (WritableAsset)ModelModifiers.expandModelAndRotateUVLocked((ModelAsset)parentAsset, (class_243)expand, (int)v.x(), (int)v.y()));
                    builder.addData(AssetPaths.model((class_2960)modelId) + ".json", new ModelAsset(Optional.of(class_2960.method_60655((String)"polymer-patch-bundle", (String)(parentId.method_12832() + suffix))), asset.elements(), asset.textures(), asset.display(), asset.guiLight(), asset.ambientOcclusion()).toBytes());
                }
            }
        });
        builder.addResourceConverter((string, resource) -> {
            if (!string.contains("_uvlock_")) {
                String[] parts = string.split("/", 4);
                if (parts.length < 4) {
                    return resource;
                }
                try {
                    class_2960 id = class_2960.method_60655((String)parts[1], (String)parts[3]);
                    if (!parts[0].equals("assets") || !parts[2].equals("models")) {
                        return resource;
                    }
                    if (!EXPANDABLE_MODELS.contains(id)) {
                        return resource;
                    }
                    ModelAsset asset = ModelAsset.fromJson((String)new String(resource.readAllBytes(), StandardCharsets.UTF_8));
                    return PackResource.of((byte[])new ModelAsset(asset.parent().map(x -> PolymerPatchBundleMod.id(x.method_12832())), asset.elements(), asset.textures(), asset.display(), asset.guiLight(), asset.ambientOcclusion()).toBytes());
                }
                catch (class_151 class_1512) {
                    // empty catch block
                }
            }
            return resource;
        });
        SIGNS.forEach(id -> ModelModifiers.createSignModel((ResourcePackBuilder)builder, (String)id.method_12836(), (String)id.method_12832(), (AtlasAsset.Builder)atlas));
        builder.addData("assets/minecraft/atlases/blocks.json", (WritableAsset)atlas.build());
    }
}

