/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse;

import io.github.retrooper.packetevents.PacketEventsServerMod;
import lombok.Generated;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.entrypoint.PreLaunchEntrypoint;
import net.flectone.pulse.FabricInjector;
import net.flectone.pulse.FlectonePulse;
import net.flectone.pulse.FlectonePulseAPI;
import net.flectone.pulse.exception.ReloadException;
import net.flectone.pulse.library.guice.Guice;
import net.flectone.pulse.library.guice.Injector;
import net.flectone.pulse.library.guice.Module;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.processing.resolver.FabricLibraryResolver;
import net.flectone.pulse.processing.resolver.LibraryResolver;
import net.flectone.pulse.util.logging.FLogger;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class FabricFlectonePulse
implements PreLaunchEntrypoint,
ModInitializer,
FlectonePulse {
    private MinecraftServer minecraftServer;
    private LibraryResolver libraryResolver;
    private FLogger fLogger;
    private Injector injector;

    public void onPreLaunch() {
        System.setProperty("packetevents.nbt.default-max-size", "2097152");
        PacketEventsServerMod.constructApi((String)"flectonepulse").init();
    }

    public void onInitialize() {
        Logger logger = LoggerFactory.getLogger((String)"flectonepulse");
        this.fLogger = new FLogger(logRecord -> logger.info(logRecord.getMessage()));
        this.fLogger.enableFilter();
        this.fLogger.logEnabling();
        this.libraryResolver = new FabricLibraryResolver(logger);
        this.libraryResolver.addLibraries();
        this.libraryResolver.resolveRepositories();
        this.libraryResolver.loadLibraries();
        try {
            this.injector = Guice.createInjector((Module[])new Module[]{new FabricInjector(this, this.libraryResolver, this.fLogger)});
        }
        catch (RuntimeException e) {
            this.fLogger.warning("FAILED TO ENABLE");
            this.fLogger.warning(e);
            e.printStackTrace();
            return;
        }
        this.onEnable();
    }

    @Override
    public <T> T get(Class<T> type) {
        if (!this.isReady()) {
            throw new IllegalStateException("FlectonePulse not initialized yet");
        }
        return (T)this.injector.getInstance(type);
    }

    @Override
    public boolean isReady() {
        return this.injector != null;
    }

    @Override
    public void onEnable() {
        if (!this.isReady()) {
            return;
        }
        ((FlectonePulseAPI)this.injector.getInstance(FlectonePulseAPI.class)).onEnable();
    }

    @Override
    public void onDisable() {
        if (!this.isReady()) {
            return;
        }
        ((FlectonePulseAPI)this.injector.getInstance(FlectonePulseAPI.class)).onDisable();
    }

    @Override
    public void reload() throws ReloadException {
        if (!this.isReady()) {
            return;
        }
        ((FlectonePulseAPI)this.injector.getInstance(FlectonePulseAPI.class)).reload();
    }

    @Generated
    public MinecraftServer getMinecraftServer() {
        return this.minecraftServer;
    }

    @Generated
    public LibraryResolver getLibraryResolver() {
        return this.libraryResolver;
    }

    @Generated
    public FLogger getFLogger() {
        return this.fLogger;
    }

    @Generated
    public Injector getInjector() {
        return this.injector;
    }

    @Generated
    public void setMinecraftServer(MinecraftServer minecraftServer) {
        this.minecraftServer = minecraftServer;
    }
}

