/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse;

import com.google.gson.Gson;
import io.github.retrooper.packetevents.adventure.serializer.gson.GsonComponentSerializer;
import java.lang.annotation.Annotation;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;
import net.flectone.pulse.FabricFlectonePulse;
import net.flectone.pulse.FlectonePulse;
import net.flectone.pulse.FlectonePulseAPI;
import net.flectone.pulse.annotation.Async;
import net.flectone.pulse.annotation.Sync;
import net.flectone.pulse.data.database.Database;
import net.flectone.pulse.execution.scheduler.FabricTaskScheduler;
import net.flectone.pulse.execution.scheduler.TaskScheduler;
import net.flectone.pulse.library.guice.AbstractModule;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.library.guice.matcher.Matchers;
import net.flectone.pulse.library.guice.name.Names;
import net.flectone.pulse.module.integration.FabricIntegrationModule;
import net.flectone.pulse.module.integration.IntegrationModule;
import net.flectone.pulse.module.message.anvil.AnvilModule;
import net.flectone.pulse.module.message.anvil.FabricAnvilModule;
import net.flectone.pulse.platform.adapter.FabricPlayerAdapter;
import net.flectone.pulse.platform.adapter.FabricServerAdapter;
import net.flectone.pulse.platform.adapter.PlatformPlayerAdapter;
import net.flectone.pulse.platform.adapter.PlatformServerAdapter;
import net.flectone.pulse.platform.provider.PacketProvider;
import net.flectone.pulse.platform.registry.CommandRegistry;
import net.flectone.pulse.platform.registry.FabricCommandRegistry;
import net.flectone.pulse.platform.registry.FabricListenerRegistry;
import net.flectone.pulse.platform.registry.FabricPermissionRegistry;
import net.flectone.pulse.platform.registry.FabricProxyRegistry;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.platform.registry.PermissionRegistry;
import net.flectone.pulse.platform.registry.ProxyRegistry;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.processing.resolver.LibraryResolver;
import net.flectone.pulse.util.checker.FabricPermissionChecker;
import net.flectone.pulse.util.checker.PermissionChecker;
import net.flectone.pulse.util.interceptor.AsyncInterceptor;
import net.flectone.pulse.util.interceptor.SyncInterceptor;
import net.flectone.pulse.util.logging.FLogger;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.aopalliance.intercept.MethodInterceptor;

@Singleton
public class FabricInjector
extends AbstractModule {
    private final FabricFlectonePulse flectonePulse;
    private final LibraryResolver libraryResolver;
    private final FLogger fLogger;
    private final PacketProvider packetProvider;

    public FabricInjector(FabricFlectonePulse flectonePulse, LibraryResolver libraryResolver, FLogger fLogger) {
        this.flectonePulse = flectonePulse;
        this.libraryResolver = libraryResolver;
        this.fLogger = fLogger;
        this.packetProvider = new PacketProvider();
    }

    protected void configure() {
        this.bind(PacketProvider.class).toInstance((Object)this.packetProvider);
        Path projectPath = FabricLoader.getInstance().getConfigDir().resolve("flectonepulse");
        this.bind(Path.class).annotatedWith((Annotation)Names.named((String)"projectPath")).toInstance((Object)projectPath);
        FileResolver fileResolver = new FileResolver(projectPath, this.fLogger);
        fileResolver.reload();
        this.bind(FileResolver.class).toInstance((Object)fileResolver);
        this.bind(Database.class).asEagerSingleton();
        this.bind(PlatformPlayerAdapter.class).to(FabricPlayerAdapter.class);
        this.bind(PlatformServerAdapter.class).to(FabricServerAdapter.class);
        this.bind(PermissionRegistry.class).to(FabricPermissionRegistry.class);
        this.bind(ProxyRegistry.class).to(FabricProxyRegistry.class);
        this.bind(ListenerRegistry.class).to(FabricListenerRegistry.class);
        this.bind(CommandRegistry.class).to(FabricCommandRegistry.class);
        this.bind(PermissionChecker.class).to(FabricPermissionChecker.class);
        this.bind(TaskScheduler.class).to(FabricTaskScheduler.class);
        this.bindModules();
        this.bind(LibraryResolver.class).toInstance((Object)this.libraryResolver);
        this.bind(Gson.class).toInstance((Object)GsonComponentSerializer.gson().serializer());
        this.bind(FlectonePulse.class).toInstance((Object)this.flectonePulse);
        this.bind(FabricFlectonePulse.class).toInstance((Object)this.flectonePulse);
        this.bind(FlectonePulseAPI.class).asEagerSingleton();
        this.bind(FLogger.class).toInstance((Object)this.fLogger);
        this.setupInterceptors();
        this.bind(MiniMessage.class).toInstance((Object)MiniMessage.builder().tags(TagResolver.builder().build()).build());
    }

    private void bindModules() {
        this.bind(IntegrationModule.class).to(FabricIntegrationModule.class);
        this.bind(AnvilModule.class).to(FabricAnvilModule.class);
    }

    private void setupInterceptors() {
        SyncInterceptor syncInterceptor = new SyncInterceptor();
        this.requestInjection(syncInterceptor);
        AsyncInterceptor asyncInterceptor = new AsyncInterceptor();
        this.requestInjection(asyncInterceptor);
        this.bindInterceptor(Matchers.any(), Matchers.annotatedWith(Sync.class).or(Matchers.annotatedWith(Async.class)), new MethodInterceptor[]{asyncInterceptor, syncInterceptor});
    }
}

