/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.config;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import net.flectone.pulse.config.FileSerializable;
import net.flectone.pulse.config.ModuleConfig;
import net.flectone.pulse.data.database.Database;
import net.flectone.pulse.library.elytrium.annotations.Comment;
import net.flectone.pulse.library.elytrium.annotations.CommentValue;

@Comment(value={@CommentValue(value="  ___       ___  __  ___  __        ___ "), @CommentValue(value=" |__  |    |__  /  `  |  /  \\ |\\ | |__"), @CommentValue(value=" |    |___ |___ \\__,  |  \\__/ | \\| |___"), @CommentValue(value="  __             __   ___ "), @CommentValue(value=" |__) |  | |    /__` |__  "), @CommentValue(value=" |    \\__/ |___ .__/ |___   /\\"), @CommentValue(value="                           /  \\"), @CommentValue(value=" __/\\___  ____/\\_____  ___/    \\______"), @CommentValue(value="        \\/           \\/  "), @CommentValue(value=" ")}, at=Comment.At.PREPEND)
public final class Config
extends FileSerializable {
    @Comment(value={@CommentValue(value=" https://flectone.net/pulse/docs/config/")})
    private String console = "Console";
    private String version = "1.5.1";
    private String language = "en_us";
    private boolean languagePlayer = true;
    private boolean unregisterOwnCommands = false;
    private boolean metrics = true;
    private boolean bungeecord = false;
    private boolean velocity = false;
    private Set<String> clusters = new HashSet<String>();
    private Set<String> fabricDisabledCommands = new HashSet<String>(Set.of("tell", "msg", "w", "me", "ban", "kick", "pardon", "banlist"));
    private List<String> logFilter = new ArrayList<String>(List.of("Paper Async Command Builder", "Caught previously unhandled exception :", "Error received from Telegram GetUpdates Request", "OkHttp TaskRunner", "Exception in thread \"ForkJoinPool", "FlectonePulseDatabase - "));
    @Comment(value={@CommentValue(value=" https://flectone.net/pulse/docs/config/#database")})
    private Database database = new Database();
    @Comment(value={@CommentValue(value=" https://flectone.net/pulse/docs/config/#module")})
    private Module module = new Module();
    @Comment(value={@CommentValue(value=" https://flectone.net/pulse/docs/config/#redis")})
    private Redis redis = new Redis();
    @Comment(value={@CommentValue(value=" https://flectone.net/pulse/docs/config/#editor")})
    private Editor editor = new Editor();

    public Config(Path projectPath) {
        super(projectPath.resolve("config.yml"));
    }

    @Generated
    public String getConsole() {
        return this.console;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public String getLanguage() {
        return this.language;
    }

    @Generated
    public boolean isLanguagePlayer() {
        return this.languagePlayer;
    }

    @Generated
    public boolean isUnregisterOwnCommands() {
        return this.unregisterOwnCommands;
    }

    @Generated
    public boolean isMetrics() {
        return this.metrics;
    }

    @Generated
    public boolean isBungeecord() {
        return this.bungeecord;
    }

    @Generated
    public boolean isVelocity() {
        return this.velocity;
    }

    @Generated
    public Set<String> getClusters() {
        return this.clusters;
    }

    @Generated
    public Set<String> getFabricDisabledCommands() {
        return this.fabricDisabledCommands;
    }

    @Generated
    public List<String> getLogFilter() {
        return this.logFilter;
    }

    @Generated
    public Database getDatabase() {
        return this.database;
    }

    @Generated
    public Module getModule() {
        return this.module;
    }

    @Generated
    public Redis getRedis() {
        return this.redis;
    }

    @Generated
    public Editor getEditor() {
        return this.editor;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setLanguage(String language) {
        this.language = language;
    }

    public static final class Database {
        private Database.Type type = Database.Type.SQLITE;
        private String name = "flectonepulse";
        private String host = "127.0.0.1";
        private String port = "3306";
        private String user = "root";
        private String password = "1234";
        private String parameters = "?autoReconnect=true&useSSL=false&useUnicode=true&characterEncoding=UTF-8";

        @Generated
        public Database.Type getType() {
            return this.type;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getHost() {
            return this.host;
        }

        @Generated
        public String getPort() {
            return this.port;
        }

        @Generated
        public String getUser() {
            return this.user;
        }

        @Generated
        public String getPassword() {
            return this.password;
        }

        @Generated
        public String getParameters() {
            return this.parameters;
        }

        @Generated
        public void setType(Database.Type type) {
            this.type = type;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setHost(String host) {
            this.host = host;
        }

        @Generated
        public void setPort(String port) {
            this.port = port;
        }

        @Generated
        public void setUser(String user) {
            this.user = user;
        }

        @Generated
        public void setPassword(String password) {
            this.password = password;
        }

        @Generated
        public void setParameters(String parameters) {
            this.parameters = parameters;
        }
    }

    public static final class Module
    implements ModuleConfig,
    IEnable {
        private boolean enable = true;

        @Override
        public ModuleConfig.CommandConfig getCommand() {
            return null;
        }

        @Override
        public ModuleConfig.IntegrationConfig getIntegration() {
            return null;
        }

        @Override
        public ModuleConfig.MessageConfig getMessage() {
            return null;
        }

        @Override
        @Generated
        public boolean isEnable() {
            return this.enable;
        }
    }

    public static final class Redis
    implements IEnable {
        private boolean enable = false;
        private String host = "127.0.0.1";
        private int port = 6379;
        private boolean ssl = false;
        private String user = "";
        private String password = "";

        @Override
        @Generated
        public boolean isEnable() {
            return this.enable;
        }

        @Generated
        public String getHost() {
            return this.host;
        }

        @Generated
        public int getPort() {
            return this.port;
        }

        @Generated
        public boolean isSsl() {
            return this.ssl;
        }

        @Generated
        public String getUser() {
            return this.user;
        }

        @Generated
        public String getPassword() {
            return this.password;
        }
    }

    public static final class Editor {
        private String host = "";
        private boolean https = false;
        private int port = 25566;

        @Generated
        public String getHost() {
            return this.host;
        }

        @Generated
        public boolean isHttps() {
            return this.https;
        }

        @Generated
        public int getPort() {
            return this.port;
        }
    }

    public static interface IEnable {
        public boolean isEnable();
    }
}

