/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.config;

import com.github.retrooper.packetevents.protocol.sound.SoundCategory;
import com.github.retrooper.packetevents.protocol.sound.Sounds;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.flectone.pulse.config.Config;
import net.flectone.pulse.config.FileSerializable;
import net.flectone.pulse.config.ModuleConfig;
import net.flectone.pulse.library.elytrium.annotations.Comment;
import net.flectone.pulse.library.elytrium.annotations.CommentValue;
import net.flectone.pulse.model.event.Event;
import net.flectone.pulse.model.util.Cooldown;
import net.flectone.pulse.model.util.Destination;
import net.flectone.pulse.model.util.Range;
import net.flectone.pulse.model.util.Sound;
import net.flectone.pulse.model.util.Ticker;
import net.flectone.pulse.model.util.Times;
import net.flectone.pulse.model.util.Toast;
import net.flectone.pulse.module.message.bubble.BubbleModule;
import net.flectone.pulse.module.message.format.world.WorldModule;
import net.flectone.pulse.module.message.objective.ObjectiveModule;
import net.flectone.pulse.util.constant.AdventureTag;

@Comment(value={@CommentValue(value="  ___       ___  __  ___  __        ___ "), @CommentValue(value=" |__  |    |__  /  `  |  /  \\ |\\ | |__"), @CommentValue(value=" |    |___ |___ \\__,  |  \\__/ | \\| |___"), @CommentValue(value="  __             __   ___ "), @CommentValue(value=" |__) |  | |    /__` |__  "), @CommentValue(value=" |    \\__/ |___ .__/ |___   /\\"), @CommentValue(value="                           /  \\"), @CommentValue(value=" __/\\___  ____/\\_____  ___/    \\______"), @CommentValue(value="        \\/           \\/  "), @CommentValue(value=" ")}, at=Comment.At.PREPEND)
public final class Message
extends FileSerializable
implements ModuleConfig.MessageConfig {
    @Comment(value={@CommentValue(value=" https://flectone.net/pulse/docs/message/")})
    private boolean enable = true;
    @Comment(value={@CommentValue(value=" https://flectone.net/pulse/docs/message/advancement/")})
    private Advancement advancement = new Advancement();
    @Comment(value={@CommentValue(value=" https://flectone.net/pulse/docs/message/afk/")})
    private Afk afk = new Afk();
    @Comment(value={@CommentValue(value=" https://flectone.net/pulse/docs/message/anvil/")})
    private Anvil anvil = new Anvil();
    @Comment(value={@CommentValue(value=" https://flectone.net/pulse/docs/message/auto/")})
    private Auto auto = new Auto();
    @Comment(value={@CommentValue(value=" https://flectone.net/pulse/docs/message/bed/")})
    private Bed bed = new Bed();
    @Comment(value={@CommentValue(value=" https://flectone.net/pulse/docs/message/book/")})
    private Book book = new Book();
    @Comment(value={@CommentValue(value=" https://flectone.net/pulse/docs/message/brand/")})
    private Brand brand = new Brand();
    @Comment(value={@CommentValue(value=" https://flectone.net/pulse/docs/message/bubble/")})
    private Bubble bubble = new Bubble();
    @Comment(value={@CommentValue(value=" https://flectone.net/pulse/docs/message/chat/")})
    private Chat chat = new Chat();
    @Comment(value={@CommentValue(value=" https://flectone.net/pulse/docs/message/clear/")})
    private Clear clear = new Clear();
    @Comment(value={@CommentValue(value=" https://flectone.net/pulse/docs/message/death/")})
    private Death death = new Death();
    @Comment(value={@CommentValue(value=" https://flectone.net/pulse/docs/message/deop/")})
    private Deop deop = new Deop();
    @Comment(value={@CommentValue(value=" https://flectone.net/pulse/docs/message/enchant/")})
    private Enchant enchant = new Enchant();
    @Comment(value={@CommentValue(value=" https://flectone.net/pulse/docs/message/format/")})
    private Format format = new Format();
    @Comment(value={@CommentValue(value=" https://flectone.net/pulse/docs/message/gamemode/")})
    private Gamemode gamemode = new Gamemode();
    @Comment(value={@CommentValue(value=" https://flectone.net/pulse/docs/message/greeting/")})
    private Greeting greeting = new Greeting();
    @Comment(value={@CommentValue(value=" https://flectone.net/pulse/docs/message/join/")})
    private Join join = new Join();
    @Comment(value={@CommentValue(value=" https://flectone.net/pulse/docs/message/kill/")})
    private Kill kill = new Kill();
    @Comment(value={@CommentValue(value=" https://flectone.net/pulse/docs/message/objective/")})
    private Objective objective = new Objective();
    @Comment(value={@CommentValue(value=" https://flectone.net/pulse/docs/message/op/")})
    private Op op = new Op();
    @Comment(value={@CommentValue(value=" https://flectone.net/pulse/docs/message/quit/")})
    private Quit quit = new Quit();
    @Comment(value={@CommentValue(value=" https://flectone.net/pulse/docs/message/rightclick/")})
    private Rightclick rightclick = new Rightclick();
    @Comment(value={@CommentValue(value=" https://flectone.net/pulse/docs/message/seed/")})
    private Seed seed = new Seed();
    @Comment(value={@CommentValue(value=" https://flectone.net/pulse/docs/message/setblock/")})
    private Setblock setblock = new Setblock();
    @Comment(value={@CommentValue(value=" https://flectone.net/pulse/docs/message/sidebar/")})
    private Sidebar sidebar = new Sidebar();
    @Comment(value={@CommentValue(value=" https://flectone.net/pulse/docs/message/sign/")})
    private Sign sign = new Sign();
    @Comment(value={@CommentValue(value=" https://flectone.net/pulse/docs/message/sleep/")})
    private Sleep sleep = new Sleep();
    @Comment(value={@CommentValue(value=" https://flectone.net/pulse/docs/message/spawn/")})
    private Spawn spawn = new Spawn();
    @Comment(value={@CommentValue(value=" https://flectone.net/pulse/docs/message/status/")})
    private Status status = new Status();
    @Comment(value={@CommentValue(value=" https://flectone.net/pulse/docs/message/tab/")})
    private Tab tab = new Tab();
    @Comment(value={@CommentValue(value=" https://flectone.net/pulse/docs/message/update/")})
    private Update update = new Update();

    public Message(Path projectPath) {
        super(projectPath.resolve("message.yml"));
    }

    @Generated
    public boolean isEnable() {
        return this.enable;
    }

    @Override
    @Generated
    public Advancement getAdvancement() {
        return this.advancement;
    }

    @Override
    @Generated
    public Afk getAfk() {
        return this.afk;
    }

    @Override
    @Generated
    public Anvil getAnvil() {
        return this.anvil;
    }

    @Override
    @Generated
    public Auto getAuto() {
        return this.auto;
    }

    @Override
    @Generated
    public Bed getBed() {
        return this.bed;
    }

    @Override
    @Generated
    public Book getBook() {
        return this.book;
    }

    @Override
    @Generated
    public Brand getBrand() {
        return this.brand;
    }

    @Override
    @Generated
    public Bubble getBubble() {
        return this.bubble;
    }

    @Override
    @Generated
    public Chat getChat() {
        return this.chat;
    }

    @Override
    @Generated
    public Clear getClear() {
        return this.clear;
    }

    @Override
    @Generated
    public Death getDeath() {
        return this.death;
    }

    @Override
    @Generated
    public Deop getDeop() {
        return this.deop;
    }

    @Override
    @Generated
    public Enchant getEnchant() {
        return this.enchant;
    }

    @Override
    @Generated
    public Format getFormat() {
        return this.format;
    }

    @Override
    @Generated
    public Gamemode getGamemode() {
        return this.gamemode;
    }

    @Override
    @Generated
    public Greeting getGreeting() {
        return this.greeting;
    }

    @Override
    @Generated
    public Join getJoin() {
        return this.join;
    }

    @Override
    @Generated
    public Kill getKill() {
        return this.kill;
    }

    @Override
    @Generated
    public Objective getObjective() {
        return this.objective;
    }

    @Override
    @Generated
    public Op getOp() {
        return this.op;
    }

    @Override
    @Generated
    public Quit getQuit() {
        return this.quit;
    }

    @Override
    @Generated
    public Rightclick getRightclick() {
        return this.rightclick;
    }

    @Override
    @Generated
    public Seed getSeed() {
        return this.seed;
    }

    @Override
    @Generated
    public Setblock getSetblock() {
        return this.setblock;
    }

    @Override
    @Generated
    public Sidebar getSidebar() {
        return this.sidebar;
    }

    @Override
    @Generated
    public Sign getSign() {
        return this.sign;
    }

    @Generated
    public Sleep getSleep() {
        return this.sleep;
    }

    @Override
    @Generated
    public Spawn getSpawn() {
        return this.spawn;
    }

    @Override
    @Generated
    public Status getStatus() {
        return this.status;
    }

    @Override
    @Generated
    public Tab getTab() {
        return this.tab;
    }

    @Override
    @Generated
    public Update getUpdate() {
        return this.update;
    }

    public static final class Advancement
    implements ModuleConfig.MessageConfig.SubMessageConfig,
    Config.IEnable {
        private boolean enable = true;
        private boolean grant = true;
        private boolean revoke = true;
        private Range range = Range.get(Range.Type.SERVER);
        private Destination destination = new Destination();
        private Sound sound = new Sound();

        @Override
        @Generated
        public boolean isEnable() {
            return this.enable;
        }

        @Generated
        public boolean isGrant() {
            return this.grant;
        }

        @Generated
        public boolean isRevoke() {
            return this.revoke;
        }

        @Generated
        public Range getRange() {
            return this.range;
        }

        @Generated
        public Destination getDestination() {
            return this.destination;
        }

        @Generated
        public Sound getSound() {
            return this.sound;
        }
    }

    public static final class Afk
    implements ModuleConfig.MessageConfig.SubMessageConfig,
    Config.IEnable {
        private boolean enable = true;
        private Range range = Range.get(Range.Type.SERVER);
        private int delay = 3000;
        private List<String> ignore = new ArrayList<String>(List.of("afk"));
        private Destination destination = new Destination();
        private Ticker ticker = new Ticker(true, 20L);

        @Override
        @Generated
        public boolean isEnable() {
            return this.enable;
        }

        @Generated
        public Range getRange() {
            return this.range;
        }

        @Generated
        public int getDelay() {
            return this.delay;
        }

        @Generated
        public List<String> getIgnore() {
            return this.ignore;
        }

        @Generated
        public Destination getDestination() {
            return this.destination;
        }

        @Generated
        public Ticker getTicker() {
            return this.ticker;
        }
    }

    public static final class Anvil
    implements ModuleConfig.MessageConfig.SubMessageConfig,
    Config.IEnable {
        private boolean enable = false;

        @Override
        @Generated
        public boolean isEnable() {
            return this.enable;
        }
    }

    public static final class Auto
    implements ModuleConfig.MessageConfig.SubMessageConfig,
    Config.IEnable {
        private boolean enable = false;
        private Map<String, Type> types = new LinkedHashMap<String, Type>(){
            {
                this.put("announcement", new Type());
            }
        };

        @Override
        @Generated
        public boolean isEnable() {
            return this.enable;
        }

        @Generated
        public Map<String, Type> getTypes() {
            return this.types;
        }

        public static final class Type {
            private boolean random = true;
            private Destination destination = new Destination();
            private Ticker ticker = new Ticker(true, 9000L);
            private Sound sound = new Sound();

            @Generated
            public boolean isRandom() {
                return this.random;
            }

            @Generated
            public Destination getDestination() {
                return this.destination;
            }

            @Generated
            public Ticker getTicker() {
                return this.ticker;
            }

            @Generated
            public Sound getSound() {
                return this.sound;
            }

            @Generated
            public Type() {
            }
        }
    }

    public static final class Bed
    implements ModuleConfig.MessageConfig.SubMessageConfig,
    Config.IEnable {
        private boolean enable = true;
        private Destination destination = new Destination(Destination.Type.ACTION_BAR);
        private Sound sound = new Sound();

        @Override
        @Generated
        public boolean isEnable() {
            return this.enable;
        }

        @Generated
        public Destination getDestination() {
            return this.destination;
        }

        @Generated
        public Sound getSound() {
            return this.sound;
        }
    }

    public static final class Book
    implements ModuleConfig.MessageConfig.SubMessageConfig,
    Config.IEnable {
        private boolean enable = false;

        @Override
        @Generated
        public boolean isEnable() {
            return this.enable;
        }
    }

    public static final class Brand
    implements ModuleConfig.MessageConfig.SubMessageConfig,
    Config.IEnable {
        private boolean enable = true;
        private boolean random = true;
        private Destination destination = new Destination(Destination.Type.BRAND);
        private Ticker ticker = new Ticker(true, 100L);

        @Override
        @Generated
        public boolean isEnable() {
            return this.enable;
        }

        @Generated
        public boolean isRandom() {
            return this.random;
        }

        @Generated
        public Destination getDestination() {
            return this.destination;
        }

        @Generated
        public Ticker getTicker() {
            return this.ticker;
        }
    }

    public static final class Bubble
    implements ModuleConfig.MessageConfig.SubMessageConfig,
    Config.IEnable {
        private boolean enable = true;
        private int maxCount = 3;
        private int maxLength = 30;
        private int elevation = 1;
        private double distance = 30.0;
        private double readSpeed = 90.0;
        private double handicapChars = 10.0;
        private String wordBreakHint = "\u2011";
        private Interaction interaction = new Interaction();
        private Modern modern = new Modern();

        @Override
        @Generated
        public boolean isEnable() {
            return this.enable;
        }

        @Generated
        public int getMaxCount() {
            return this.maxCount;
        }

        @Generated
        public int getMaxLength() {
            return this.maxLength;
        }

        @Generated
        public int getElevation() {
            return this.elevation;
        }

        @Generated
        public double getDistance() {
            return this.distance;
        }

        @Generated
        public double getReadSpeed() {
            return this.readSpeed;
        }

        @Generated
        public double getHandicapChars() {
            return this.handicapChars;
        }

        @Generated
        public String getWordBreakHint() {
            return this.wordBreakHint;
        }

        @Generated
        public Interaction getInteraction() {
            return this.interaction;
        }

        @Generated
        public Modern getModern() {
            return this.modern;
        }

        public static final class Interaction {
            private boolean enable = true;
            private float height = 0.4f;

            @Generated
            public boolean isEnable() {
                return this.enable;
            }

            @Generated
            public float getHeight() {
                return this.height;
            }

            @Generated
            public Interaction() {
            }
        }

        public static final class Modern {
            private boolean enable = true;
            private boolean hasShadow = false;
            private int animationTime = 5;
            private float scale = 1.0f;
            private String background = "#00000040";
            private BubbleModule.Billboard billboard = BubbleModule.Billboard.CENTER;

            @Generated
            public boolean isEnable() {
                return this.enable;
            }

            @Generated
            public boolean isHasShadow() {
                return this.hasShadow;
            }

            @Generated
            public int getAnimationTime() {
                return this.animationTime;
            }

            @Generated
            public float getScale() {
                return this.scale;
            }

            @Generated
            public String getBackground() {
                return this.background;
            }

            @Generated
            public BubbleModule.Billboard getBillboard() {
                return this.billboard;
            }

            @Generated
            public Modern() {
            }
        }
    }

    public static final class Chat
    implements ModuleConfig.MessageConfig.SubMessageConfig,
    Config.IEnable {
        private boolean enable = true;
        private Mode mode = Mode.BUKKIT;
        private Event.Priority priority = Event.Priority.NORMAL;
        private Map<String, Type> types = new LinkedHashMap<String, Type>(){
            {
                this.put("local", new Type("", true, true, Range.get(100), 0));
                this.put("global", new Type("!", true, false, Range.get(Range.Type.PROXY), 5));
            }
        };

        @Override
        @Generated
        public boolean isEnable() {
            return this.enable;
        }

        @Generated
        public Mode getMode() {
            return this.mode;
        }

        @Generated
        public Event.Priority getPriority() {
            return this.priority;
        }

        @Generated
        public Map<String, Type> getTypes() {
            return this.types;
        }

        public static enum Mode {
            BUKKIT,
            PAPER,
            PACKET;

        }

        public static final class Type {
            private boolean enable = true;
            private boolean cancel = false;
            private Range range = Range.get(0);
            private int priority = 0;
            private String trigger = "";
            private NullReceiver nullReceiver = new NullReceiver();
            private Destination destination = new Destination();
            private Cooldown cooldown = new Cooldown();
            private Sound sound = new Sound();

            public Type(String trigger, boolean nullReceiver, boolean cancel, Range range, int priority) {
                this.trigger = trigger;
                this.cancel = cancel;
                this.nullReceiver = new NullReceiver(nullReceiver);
                this.range = range;
                this.priority = priority;
            }

            @Generated
            public boolean isEnable() {
                return this.enable;
            }

            @Generated
            public boolean isCancel() {
                return this.cancel;
            }

            @Generated
            public Range getRange() {
                return this.range;
            }

            @Generated
            public int getPriority() {
                return this.priority;
            }

            @Generated
            public String getTrigger() {
                return this.trigger;
            }

            @Generated
            public NullReceiver getNullReceiver() {
                return this.nullReceiver;
            }

            @Generated
            public Destination getDestination() {
                return this.destination;
            }

            @Generated
            public Cooldown getCooldown() {
                return this.cooldown;
            }

            @Generated
            public Sound getSound() {
                return this.sound;
            }

            @Generated
            public Type() {
            }

            public static final class NullReceiver {
                private boolean enable = true;
                private Destination destination = new Destination(Destination.Type.ACTION_BAR, new Times(0, 20, 0));

                public NullReceiver(boolean enable) {
                    this.enable = enable;
                }

                @Generated
                public boolean isEnable() {
                    return this.enable;
                }

                @Generated
                public Destination getDestination() {
                    return this.destination;
                }

                @Generated
                public NullReceiver() {
                }
            }
        }
    }

    public static final class Clear
    implements ModuleConfig.MessageConfig.SubMessageConfig,
    Config.IEnable {
        private boolean enable = true;
        private Sound sound = new Sound();
        private Destination destination = new Destination();

        @Override
        @Generated
        public boolean isEnable() {
            return this.enable;
        }

        @Generated
        public Sound getSound() {
            return this.sound;
        }

        @Generated
        public Destination getDestination() {
            return this.destination;
        }
    }

    public static final class Death
    implements ModuleConfig.MessageConfig.SubMessageConfig,
    Config.IEnable {
        private boolean enable = true;
        private Range range = Range.get(Range.Type.SERVER);
        private Destination destination = new Destination();
        private Sound sound = new Sound();

        @Override
        @Generated
        public boolean isEnable() {
            return this.enable;
        }

        @Generated
        public Range getRange() {
            return this.range;
        }

        @Generated
        public Destination getDestination() {
            return this.destination;
        }

        @Generated
        public Sound getSound() {
            return this.sound;
        }
    }

    public static final class Deop
    implements ModuleConfig.MessageConfig.SubMessageConfig,
    Config.IEnable {
        private boolean enable = true;
        private Destination destination = new Destination();
        private Sound sound = new Sound();

        @Override
        @Generated
        public boolean isEnable() {
            return this.enable;
        }

        @Generated
        public Destination getDestination() {
            return this.destination;
        }

        @Generated
        public Sound getSound() {
            return this.sound;
        }
    }

    public static final class Enchant
    implements ModuleConfig.MessageConfig.SubMessageConfig,
    Config.IEnable {
        private boolean enable = true;
        private Destination destination = new Destination();
        private Sound sound = new Sound();

        @Override
        @Generated
        public boolean isEnable() {
            return this.enable;
        }

        @Generated
        public Destination getDestination() {
            return this.destination;
        }

        @Generated
        public Sound getSound() {
            return this.sound;
        }
    }

    public static final class Format
    implements ModuleConfig.MessageConfig.FormatMessageConfig,
    Config.IEnable {
        private boolean enable = true;
        private boolean convertLegacyColor = true;
        private List<AdventureTag> adventureTags = new ArrayList<AdventureTag>(List.of(AdventureTag.values()));
        @Comment(value={@CommentValue(value=" https://flectone.net/pulse/docs/message/format/fcolor/")})
        private FColor fcolor = new FColor();
        @Deprecated(forRemoval=true)
        private Emoji emoji = new Emoji();
        @Comment(value={@CommentValue(value=" https://flectone.net/pulse/docs/message/format/fixation/")})
        private Fixation fixation = new Fixation();
        @Comment(value={@CommentValue(value=" https://flectone.net/pulse/docs/message/format/mention/")})
        private Mention mention = new Mention();
        @Comment(value={@CommentValue(value=" https://flectone.net/pulse/docs/message/format/moderation/")})
        private Moderation moderation = new Moderation();
        @Comment(value={@CommentValue(value=" https://flectone.net/pulse/docs/message/format/name_/")})
        private Name name_ = new Name();
        @Comment(value={@CommentValue(value=" https://flectone.net/pulse/docs/message/format/questionanswer/")})
        private QuestionAnswer questionAnswer = new QuestionAnswer();
        @Comment(value={@CommentValue(value=" https://flectone.net/pulse/docs/message/format/replacement/")})
        private Replacement replacement = new Replacement();
        @Comment(value={@CommentValue(value=" https://flectone.net/pulse/docs/message/format/scoreboard/")})
        private Scoreboard scoreboard = new Scoreboard();
        @Comment(value={@CommentValue(value=" https://flectone.net/pulse/docs/message/format/translate/")})
        private Translate translate = new Translate();
        @Comment(value={@CommentValue(value=" https://flectone.net/pulse/docs/message/format/world/")})
        private World world = new World();

        @Override
        @Generated
        public boolean isEnable() {
            return this.enable;
        }

        @Generated
        public boolean isConvertLegacyColor() {
            return this.convertLegacyColor;
        }

        @Generated
        public List<AdventureTag> getAdventureTags() {
            return this.adventureTags;
        }

        @Override
        @Generated
        public FColor getFcolor() {
            return this.fcolor;
        }

        @Deprecated
        @Generated
        public Emoji getEmoji() {
            return this.emoji;
        }

        @Override
        @Generated
        public Fixation getFixation() {
            return this.fixation;
        }

        @Override
        @Generated
        public Mention getMention() {
            return this.mention;
        }

        @Override
        @Generated
        public Moderation getModeration() {
            return this.moderation;
        }

        @Override
        @Generated
        public Name getName_() {
            return this.name_;
        }

        @Override
        @Generated
        public QuestionAnswer getQuestionAnswer() {
            return this.questionAnswer;
        }

        @Override
        @Generated
        public Replacement getReplacement() {
            return this.replacement;
        }

        @Override
        @Generated
        public Scoreboard getScoreboard() {
            return this.scoreboard;
        }

        @Override
        @Generated
        public Translate getTranslate() {
            return this.translate;
        }

        @Override
        @Generated
        public World getWorld() {
            return this.world;
        }

        public static final class FColor
        implements ModuleConfig.MessageConfig.FormatMessageConfig.SubFormatMessageConfig,
        Config.IEnable {
            private boolean enable = true;
            private Map<Integer, String> defaultColors = new LinkedHashMap<Integer, String>(){
                {
                    this.put(1, "<gradient:#A6D8FF:#8CC8FF>");
                    this.put(2, "<gradient:#6BB6FF:#4DA6FF>");
                    this.put(3, "#A9A9A9");
                    this.put(4, "#FFFAFA");
                }
            };

            @Override
            @Generated
            public boolean isEnable() {
                return this.enable;
            }

            @Generated
            public Map<Integer, String> getDefaultColors() {
                return this.defaultColors;
            }
        }

        public static final class Emoji
        implements ModuleConfig.MessageConfig.FormatMessageConfig.SubFormatMessageConfig,
        Config.IEnable {
            private boolean enable = false;
            private Map<String, String> values = new LinkedHashMap<String, String>();

            @Override
            @Generated
            public boolean isEnable() {
                return this.enable;
            }

            @Generated
            public Map<String, String> getValues() {
                return this.values;
            }
        }

        public static final class Fixation
        implements ModuleConfig.MessageConfig.FormatMessageConfig.SubFormatMessageConfig,
        Config.IEnable {
            private boolean enable = false;
            private boolean endDot = false;
            private boolean firstLetterUppercase = false;
            private List<String> nonDotSymbols = new LinkedList<String>(){
                {
                    this.push(".");
                    this.push("!");
                    this.push("?");
                    this.push(",");
                    this.push("\"");
                    this.push("'");
                    this.push(":");
                    this.push(";");
                }
            };

            @Override
            @Generated
            public boolean isEnable() {
                return this.enable;
            }

            @Generated
            public boolean isEndDot() {
                return this.endDot;
            }

            @Generated
            public boolean isFirstLetterUppercase() {
                return this.firstLetterUppercase;
            }

            @Generated
            public List<String> getNonDotSymbols() {
                return this.nonDotSymbols;
            }
        }

        public static final class Mention
        implements ModuleConfig.MessageConfig.FormatMessageConfig.SubFormatMessageConfig,
        Config.IEnable {
            private boolean enable = true;
            private String trigger = "@";
            private Destination destination = new Destination(Destination.Type.TOAST, new Toast("minecraft:bell", Toast.Type.TASK));
            private Sound sound = new Sound(true, 0.1f, 0.1f, SoundCategory.NEUTRAL.name(), Sounds.ENTITY_EXPERIENCE_ORB_PICKUP.getName().toString());

            @Override
            @Generated
            public boolean isEnable() {
                return this.enable;
            }

            @Generated
            public String getTrigger() {
                return this.trigger;
            }

            @Generated
            public Destination getDestination() {
                return this.destination;
            }

            @Generated
            public Sound getSound() {
                return this.sound;
            }
        }

        public static final class Moderation
        implements ModuleConfig.MessageConfig.FormatMessageConfig.ModerationFormatMessageConfig,
        Config.IEnable {
            private boolean enable = true;
            @Comment(value={@CommentValue(value=" https://flectone.net/pulse/docs/message/format/moderation/caps/")})
            private Caps caps = new Caps();
            @Comment(value={@CommentValue(value=" https://flectone.net/pulse/docs/message/format/moderation/delete/")})
            private Delete delete = new Delete();
            @Comment(value={@CommentValue(value=" https://flectone.net/pulse/docs/message/format/moderation/newbie/")})
            private Newbie newbie = new Newbie();
            @Comment(value={@CommentValue(value=" https://flectone.net/pulse/docs/message/format/moderation/flood/")})
            private Flood flood = new Flood();
            @Comment(value={@CommentValue(value=" https://flectone.net/pulse/docs/message/format/moderation/swear/")})
            private Swear swear = new Swear();

            @Override
            @Generated
            public boolean isEnable() {
                return this.enable;
            }

            @Override
            @Generated
            public Caps getCaps() {
                return this.caps;
            }

            @Override
            @Generated
            public Delete getDelete() {
                return this.delete;
            }

            @Override
            @Generated
            public Newbie getNewbie() {
                return this.newbie;
            }

            @Override
            @Generated
            public Flood getFlood() {
                return this.flood;
            }

            @Override
            @Generated
            public Swear getSwear() {
                return this.swear;
            }

            public static final class Caps
            implements ModuleConfig.MessageConfig.FormatMessageConfig.ModerationFormatMessageConfig.SubModerationFormatMessageConfig,
            Config.IEnable {
                private boolean enable = false;
                private double trigger = 0.7;

                @Override
                @Generated
                public boolean isEnable() {
                    return this.enable;
                }

                @Generated
                public double getTrigger() {
                    return this.trigger;
                }
            }

            public static final class Delete
            implements ModuleConfig.MessageConfig.FormatMessageConfig.ModerationFormatMessageConfig.SubModerationFormatMessageConfig,
            Config.IEnable {
                private boolean enable = false;
                private int historyLength = 100;

                @Override
                @Generated
                public boolean isEnable() {
                    return this.enable;
                }

                @Generated
                public int getHistoryLength() {
                    return this.historyLength;
                }
            }

            public static final class Newbie
            implements ModuleConfig.MessageConfig.FormatMessageConfig.ModerationFormatMessageConfig.SubModerationFormatMessageConfig,
            Config.IEnable {
                private boolean enable = false;
                private Mode mode = Mode.PLAYED_TIME;
                private long timeout = 3600L;

                @Override
                @Generated
                public boolean isEnable() {
                    return this.enable;
                }

                @Generated
                public Mode getMode() {
                    return this.mode;
                }

                @Generated
                public long getTimeout() {
                    return this.timeout;
                }

                public static enum Mode {
                    PLAYED_TIME,
                    SINCE_JOIN;

                }
            }

            public static final class Flood
            implements ModuleConfig.MessageConfig.FormatMessageConfig.ModerationFormatMessageConfig.SubModerationFormatMessageConfig,
            Config.IEnable {
                private boolean enable = false;
                private boolean trimToSingle = false;
                private int maxRepeatedSymbols = 10;
                private int maxRepeatedWords = 2;

                @Override
                @Generated
                public boolean isEnable() {
                    return this.enable;
                }

                @Generated
                public boolean isTrimToSingle() {
                    return this.trimToSingle;
                }

                @Generated
                public int getMaxRepeatedSymbols() {
                    return this.maxRepeatedSymbols;
                }

                @Generated
                public int getMaxRepeatedWords() {
                    return this.maxRepeatedWords;
                }
            }

            public static final class Swear
            implements ModuleConfig.MessageConfig.FormatMessageConfig.ModerationFormatMessageConfig.SubModerationFormatMessageConfig,
            Config.IEnable {
                private boolean enable = false;
                private List<String> ignore = new ArrayList<String>(List.of("\u0442\u0435\u0431\u044f", "\u0442\u0435\u0431\u0435"));
                private List<String> trigger = new ArrayList<String>(List.of("((\u0443|[\u043d\u0437]\u0430|(\u0445\u0438\u0442\u0440\u043e|\u043d\u0435)?\u0432\u0437?[\u044b\u044c\u044a]|\u0441[\u044c\u044a]|(\u0438|\u0440\u0430)[\u0437\u0441]\u044a?|(\u043e[\u0442\u0431]|\u043f\u043e\u0434)[\u044c\u044a]?|(.\\B)+?[\u043e\u0430\u0435\u0438])?-?([\u0435\u0451]\u0431(?!\u043e[\u0440\u0439])|\u0438[\u043f\u0431][\u0430\u0435][\u0442\u0446]).*?|(\u043d[\u0438\u0435\u0430]|([\u0434\u043f]|\u0432\u0435\u0440\u0442)\u043e|\u0440\u0430[\u0437\u0441]|\u0437?\u0430|\u0441(\u043c\u0435)?|\u043e(\u0442|\u0434\u043d\u043e)?|\u0430\u043f\u0447)?-?\u0445\u0443([\u044f\u0439\u0438\u0435\u0451\u044e]|\u043b\u0438(?!\u0433\u0430\u043d)).*?|(\u0432[\u0437\u044b]|(\u0442\u0440\u0438|\u0434\u0432\u0430|\u0447\u0435\u0442\u044b\u0440\u0435)\u0436\u0434\u044b|(\u043d|\u0441\u0443\u043a)\u0430)?-?\u0431\u043b(\u044f(?!(\u0445|\u0448[\u043a\u043d]|\u043c\u0431)[\u0430\u0443\u0435\u044b\u0438\u043e]).*?|[\u0435\u044d][\u0434\u0442]\u044c?)|(\u0440\u0430[\u0441\u0437]|[\u0437\u043d]\u0430|[\u0441\u043e]|\u0432\u044b?|\u043f(\u0435\u0440\u0435|\u0440[\u043e\u0438\u0435]|\u043e\u0434)|\u0438[\u0437\u0441]\u044a?|[\u0430\u043e]\u0442)?\u043f[\u0438\u0435\u0451]\u0437\u0434.*?|(\u0437\u0430)?\u043f[\u0438\u0435]\u0434[\u0430\u043e\u0435]?\u0440([\u043e\u0430]\u043c|(\u0430\u0441)?(\u043d\u0443.*?|\u0438(\u043b\u0438)?[\u043d\u0449\u043a\u0442\u043b]\u044c?)?|(\u043e(\u0447[\u0435\u0438])?|\u0430\u0441)?\u043a(\u043e\u0439)|\u044e\u0433)[\u0430\u0443\u0435\u044b]?|\u043c\u0430\u043d\u0434([\u0430\u0443\u0435\u044b\u0438](\u043b(\u0438[\u0441\u0437\u0449])?[\u0430\u0443\u0435\u0438\u044b])?|\u043e\u0439|[\u0430\u043e]\u0432\u043e\u0448\u044c?(\u0435?\u043a[\u0430\u0443\u0435])?|\u044e\u043a(\u043e\u0432|[\u0430\u0443\u0438])?)|\u043c\u0443\u0434([\u044f\u0430\u0438\u043e].*?|\u0435?\u043d([\u044c\u044e\u0438\u044f]|\u0435\u0439))|\u043c\u043b\u044f([\u0442\u0434]\u044c)?|\u043b\u044f\u0442\u044c|([\u043d\u0437]\u0430|\u043f\u043e|\u043f\u0438)\u0445|\u043c[\u0430\u043e]\u043b[\u0430\u043e]\u0444\u044c([\u044f\u0438\u044e]|[\u0435\u0451\u043e]\u0439))(?=[\\s,.:;\"']|$)", "(([\u0443yu]|[\u043d\u0437nz3][\u0430a]|(\u0445\u0438\u0442\u0440\u043e|\u043d\u0435)?[\u0432vwb][\u0437z3]?[\u044b\u044c\u044ai]|[\u0441sc][\u044c\u044a']|(\u0438|[\u0440pr][\u0430a4])[\u0437\u0441zs]\u044a?|([\u043eo0][\u0442\u0431tb6]|[\u043fp][\u043eo0][\u0434d9])[\u044c\u044a']?|(.\\B)+?[\u043e\u0430\u0435\u0438eo])?-?([\u0435\u0451e][\u0431b6](?!\u043e[\u0440\u0439])|\u0438[\u043f\u0431][\u0430\u0435][\u0442\u0446]).*?|([\u043dn][\u0438\u0435\u0430aie]|([\u0434\u043fdp]|[\u0432v][\u0435e3][\u0440pr][\u0442t])[\u043eo0]|[\u0440pr][\u0430a][\u0437\u0441zc3]|[\u04373z]?[\u0430a]|\u0441(\u043c\u0435)?|[\u043eo0]([\u0442t]|\u0434\u043d\u043e)?|\u0430\u043f\u0447)?-?[\u0445xh][\u0443uy]([\u044f\u0439\u0438\u0435\u0451\u044euie]|\u043b\u0438(?!\u0433\u0430\u043d)).*?|([\u0432vw][\u0437\u044b3z]|(\u0442\u0440\u0438|\u0434\u0432\u0430|\u0447\u0435\u0442\u044b\u0440\u0435)\u0436\u0434\u044b|(\u043d|[\u0441c][\u0443uy][\u043ak])[\u0430a])?-?[\u0431b6][\u043bl]([\u044fy](?!(\u0445|\u0448[\u043a\u043d]|\u043c\u0431)[\u0430\u0443\u0435\u044b\u0438\u043e]).*?|[\u0435\u044de][\u0434\u0442dt][\u044c']?)|([\u0440p][\u0430a][\u0441\u0437c3z]|[\u0437\u043dzn][\u0430a]|[\u0441\u043esc]|[\u0432v][\u044bi]?|[\u043fp]([\u0435e][\u0440pr][\u0435e]|[\u0440rp][\u043e\u0438io\u0435e]|[\u043eo0][\u0434d])|\u0438[\u0437\u0441]\u044a?|[\u0430\u043eao][\u0442t])?[\u043fpn][\u0438\u0435\u0451ieu][\u0437z3][\u0434d9].*?|([\u0437z3][\u0430a])?[\u043fp][\u0438\u0435ieu][\u0434d][\u0430\u043e\u0435aoe]?[\u0440rp](\u043d\u0443.*?|[\u043e\u0430oa][\u043cm]|([\u0430a][\u0441cs])?([\u0438iu]([\u043bl][\u0438iu])?[\u043d\u0449\u043a\u0442\u043btlsn]\u044c?)?|([\u043eo](\u0447[\u0435\u0438ei])?|[\u0430a][\u0441cs])?[\u043ak]([\u043eo]\u0439)?|[\u044eu][\u0433g])[\u0430\u0443\u0435\u044bauyei]?|[\u043cm][\u0430a][\u043dnh][\u0434d]([\u0430\u0443\u0435\u044bayuei\u0438]([\u043bl]([\u0438i][\u0441\u0437c3\u0449])?[\u0430\u0443\u0435\u044bauyei])?|[\u043eo][\u0439i]|[\u0430\u043eao][\u0432vwb][\u043eo](\u0448|sh)[\u044c']?([e]?[\u043ak][\u0430\u0443\u0435ayue])?|\u044e\u043a(\u043e\u0432|[\u0430\u0443\u0438])?)|[\u043cm][\u0443uy][\u0434d6]([\u044fy\u0430\u0438\u043eaiuo0].*?|[\u0435e]?[\u043dhn]([\u044c\u044e\u0438\u044f'uiya]|\u0435\u0439))|\u043c\u043b\u044f([\u0442\u0434]\u044c)?|\u043b\u044f\u0442\u044c|([\u043d\u0437]\u0430|\u043f\u043e|\u043f\u0438)\u0445|\u043c[\u0430\u043e]\u043b[\u0430\u043e]\u0444\u044c([\u044f\u0438\u044e]|[\u0435\u0451]\u0439))(?=[\\s,.:;\"']|$)"));

                @Override
                @Generated
                public boolean isEnable() {
                    return this.enable;
                }

                @Generated
                public List<String> getIgnore() {
                    return this.ignore;
                }

                @Generated
                public List<String> getTrigger() {
                    return this.trigger;
                }
            }
        }

        public static final class Name
        implements ModuleConfig.MessageConfig.FormatMessageConfig.SubFormatMessageConfig,
        Config.IEnable {
            private boolean enable = true;
            private boolean shouldCheckInvisibility = false;

            @Override
            @Generated
            public boolean isEnable() {
                return this.enable;
            }

            @Generated
            public boolean isShouldCheckInvisibility() {
                return this.shouldCheckInvisibility;
            }
        }

        public static final class QuestionAnswer
        implements ModuleConfig.MessageConfig.FormatMessageConfig.SubFormatMessageConfig,
        Config.IEnable {
            private boolean enable = false;
            private Map<String, Question> questions = new LinkedHashMap<String, Question>(){
                {
                    this.put("server", new Question("(?i)\\b(what\\s+is\\s+this\\s+server|what\\'?s\\s+this\\s+server|what\\s+server\\s+is\\s+this)\\b"));
                    this.put("flectone", new Question("(?i)\\b(flectone|flectonepulse|flecton)\\b"));
                }
            };

            @Override
            @Generated
            public boolean isEnable() {
                return this.enable;
            }

            @Generated
            public Map<String, Question> getQuestions() {
                return this.questions;
            }

            public static final class Question {
                private Range range = Range.get(Range.Type.PLAYER);
                private Destination destination = new Destination(Destination.Type.CHAT);
                private Cooldown cooldown = new Cooldown();
                private Sound sound = new Sound();
                private String target = "";

                public Question(String target) {
                    this.target = target;
                }

                @Generated
                public Range getRange() {
                    return this.range;
                }

                @Generated
                public Destination getDestination() {
                    return this.destination;
                }

                @Generated
                public Cooldown getCooldown() {
                    return this.cooldown;
                }

                @Generated
                public Sound getSound() {
                    return this.sound;
                }

                @Generated
                public String getTarget() {
                    return this.target;
                }

                @Generated
                public Question() {
                }
            }
        }

        public static final class Replacement
        implements ModuleConfig.MessageConfig.FormatMessageConfig.SubFormatMessageConfig,
        Config.IEnable {
            private boolean enable = true;
            private static final String BOUNDARY = "(?<!\\\\{2,})(?<=\\s|^)(%s)(?=\\s|$|\\p{Punct})";
            private static final String FORMAT_TEMPLATE = "(?<!\\\\{2,})(?<=\\s|^)%s([^\\n]*?)%s(?=\\s|$|\\p{Punct})";
            private Map<String, String> triggers = new LinkedHashMap<String, String>(){
                {
                    this.put("smile", String.format(Replacement.BOUNDARY, ":-?\\)"));
                    this.put("big_smile", String.format(Replacement.BOUNDARY, ":-?D"));
                    this.put("sad", String.format(Replacement.BOUNDARY, ":-?\\("));
                    this.put("ok_hand", String.format(Replacement.BOUNDARY, "(?i):ok:"));
                    this.put("thumbs_up", String.format(Replacement.BOUNDARY, ":\\+1:"));
                    this.put("thumbs_down", String.format(Replacement.BOUNDARY, ":-1:"));
                    this.put("cool_smile", String.format(Replacement.BOUNDARY, "(?i):cool:"));
                    this.put("cool_glasses", String.format(Replacement.BOUNDARY, "B-?\\)"));
                    this.put("clown", String.format(Replacement.BOUNDARY, "(?i):clown:"));
                    this.put("heart", String.format(Replacement.BOUNDARY, "<3"));
                    this.put("laughing", String.format(Replacement.BOUNDARY, "(?i)xd"));
                    this.put("confused", String.format(Replacement.BOUNDARY, "%-?\\)"));
                    this.put("happy", String.format(Replacement.BOUNDARY, "=D"));
                    this.put("angry", String.format(Replacement.BOUNDARY, ">:-?\\("));
                    this.put("ascii_idk", String.format(Replacement.BOUNDARY, "(?i):idk:"));
                    this.put("ascii_angry", String.format(Replacement.BOUNDARY, "(?i):angry:"));
                    this.put("ascii_happy", String.format(Replacement.BOUNDARY, "(?i):happy:"));
                    this.put("ping", String.format(Replacement.BOUNDARY, "%ping%"));
                    this.put("tps", String.format(Replacement.BOUNDARY, "%tps%"));
                    this.put("online", String.format(Replacement.BOUNDARY, "%online%"));
                    this.put("coords", String.format(Replacement.BOUNDARY, "%coords%"));
                    this.put("stats", String.format(Replacement.BOUNDARY, "%stats%"));
                    this.put("skin", String.format(Replacement.BOUNDARY, "%skin%"));
                    this.put("item", String.format(Replacement.BOUNDARY, "%item%"));
                    this.put("image", "(?<!\\\\{2,})(?<=\\s|^)((?:https?|HTTPS?)://(?:[a-zA-Z0-9-]{1,63}\\.)*(?:imgur\\.com|discordapp\\.net|cdn\\.discordapp\\.com)/[\\w\\-./?=&%]*\\.(?:jpg|jpeg|png|gif|webp|bmp))(?!\\S)");
                    this.put("url", "(?<!\\\\{2,})(?<=\\s|^)((?:https?|ftp|HTTPS?)://(?:[\\p{L}a-zA-Z0-9-]{1,63}\\.)+[\\p{L}a-zA-Z]{2,6}(?::\\d{1,5})?(?:/[\\w\\-./?=&%]*)?)(?!\\S)");
                    this.put("spoiler", String.format(Replacement.FORMAT_TEMPLATE, "\\|\\|", "\\|\\|"));
                    this.put("bold", String.format(Replacement.FORMAT_TEMPLATE, "\\*\\*", "\\*\\*"));
                    this.put("italic", String.format(Replacement.FORMAT_TEMPLATE, "\\*", "\\*"));
                    this.put("underline", String.format(Replacement.FORMAT_TEMPLATE, "__", "__"));
                    this.put("obfuscated", String.format(Replacement.FORMAT_TEMPLATE, "\\?\\?", "\\?\\?"));
                    this.put("strikethrough", String.format(Replacement.FORMAT_TEMPLATE, "~~", "~~"));
                }
            };

            @Override
            @Generated
            public boolean isEnable() {
                return this.enable;
            }

            @Generated
            public Map<String, String> getTriggers() {
                return this.triggers;
            }
        }

        public static final class Scoreboard
        implements ModuleConfig.MessageConfig.FormatMessageConfig.SubFormatMessageConfig,
        Config.IEnable {
            private boolean enable = true;
            private boolean nameVisible = false;
            private String color = "<white>";
            private String prefix = "<vault_prefix><stream_prefix>";
            private String suffix = "<afk_suffix><vault_suffix>";
            private Ticker ticker = new Ticker();

            @Override
            @Generated
            public boolean isEnable() {
                return this.enable;
            }

            @Generated
            public boolean isNameVisible() {
                return this.nameVisible;
            }

            @Generated
            public String getColor() {
                return this.color;
            }

            @Generated
            public String getPrefix() {
                return this.prefix;
            }

            @Generated
            public String getSuffix() {
                return this.suffix;
            }

            @Generated
            public Ticker getTicker() {
                return this.ticker;
            }
        }

        public static final class Translate
        implements ModuleConfig.MessageConfig.FormatMessageConfig.SubFormatMessageConfig,
        Config.IEnable {
            private boolean enable = true;

            @Override
            @Generated
            public boolean isEnable() {
                return this.enable;
            }
        }

        public static final class World
        implements ModuleConfig.MessageConfig.FormatMessageConfig.SubFormatMessageConfig,
        Config.IEnable {
            private boolean enable = true;
            private WorldModule.Mode mode = WorldModule.Mode.TYPE;
            private Ticker ticker = new Ticker(false, 100L);
            private Map<String, String> values = new LinkedHashMap<String, String>(){
                {
                    this.put("normal", "<color:#98FB98>");
                    this.put("world", "<color:#98FB98>");
                    this.put("overworld", "<color:#98FB98>");
                    this.put("custom", "<color:#98FB98>");
                    this.put("nether", "<color:#F08080>");
                    this.put("the_nether", "<color:#F08080>");
                    this.put("world_nether", "<color:#F08080>");
                    this.put("the_end", "<color:#9370DB>");
                    this.put("world_the_end", "<color:#9370DB>");
                }
            };

            @Override
            @Generated
            public boolean isEnable() {
                return this.enable;
            }

            @Generated
            public WorldModule.Mode getMode() {
                return this.mode;
            }

            @Generated
            public Ticker getTicker() {
                return this.ticker;
            }

            @Generated
            public Map<String, String> getValues() {
                return this.values;
            }
        }

        public static class Tag {
            private boolean enable = true;
            private String trigger = "";

            public Tag(String trigger) {
                this.trigger = trigger;
            }

            @Generated
            public boolean isEnable() {
                return this.enable;
            }

            @Generated
            public String getTrigger() {
                return this.trigger;
            }

            @Generated
            public Tag() {
            }
        }
    }

    public static final class Gamemode
    implements ModuleConfig.MessageConfig.SubMessageConfig,
    Config.IEnable {
        private boolean enable = true;
        private Destination destination = new Destination();
        private Sound sound = new Sound();

        @Override
        @Generated
        public boolean isEnable() {
            return this.enable;
        }

        @Generated
        public Destination getDestination() {
            return this.destination;
        }

        @Generated
        public Sound getSound() {
            return this.sound;
        }
    }

    public static final class Greeting
    implements ModuleConfig.MessageConfig.SubMessageConfig,
    Config.IEnable {
        private boolean enable = false;
        private Destination destination = new Destination();
        private Sound sound = new Sound();

        @Override
        @Generated
        public boolean isEnable() {
            return this.enable;
        }

        @Generated
        public Destination getDestination() {
            return this.destination;
        }

        @Generated
        public Sound getSound() {
            return this.sound;
        }
    }

    public static final class Join
    implements ModuleConfig.MessageConfig.SubMessageConfig,
    Config.IEnable {
        private boolean enable = true;
        private boolean first = true;
        private Range range = Range.get(Range.Type.SERVER);
        private Destination destination = new Destination();
        private Sound sound = new Sound();

        @Override
        @Generated
        public boolean isEnable() {
            return this.enable;
        }

        @Generated
        public boolean isFirst() {
            return this.first;
        }

        @Generated
        public Range getRange() {
            return this.range;
        }

        @Generated
        public Destination getDestination() {
            return this.destination;
        }

        @Generated
        public Sound getSound() {
            return this.sound;
        }
    }

    public static final class Kill
    implements ModuleConfig.MessageConfig.SubMessageConfig,
    Config.IEnable {
        private boolean enable = true;
        private Sound sound = new Sound();
        private Destination destination = new Destination();

        @Override
        @Generated
        public boolean isEnable() {
            return this.enable;
        }

        @Generated
        public Sound getSound() {
            return this.sound;
        }

        @Generated
        public Destination getDestination() {
            return this.destination;
        }
    }

    public static final class Objective
    implements ModuleConfig.MessageConfig.ObjectiveMessageConfig,
    Config.IEnable {
        private boolean enable = true;
        @Comment(value={@CommentValue(value=" https://flectone.net/pulse/docs/message/objective/belowname/")})
        private Belowname belowname = new Belowname();
        @Comment(value={@CommentValue(value=" https://flectone.net/pulse/docs/message/objective/tabname/")})
        private Tabname tabname = new Tabname();

        @Override
        @Generated
        public boolean isEnable() {
            return this.enable;
        }

        @Override
        @Generated
        public Belowname getBelowname() {
            return this.belowname;
        }

        @Override
        @Generated
        public Tabname getTabname() {
            return this.tabname;
        }

        public static final class Belowname
        implements ModuleConfig.MessageConfig.ObjectiveMessageConfig.SubObjectiveMessageConfig {
            private boolean enable = false;
            private ObjectiveModule.Mode mode = ObjectiveModule.Mode.PING;
            private Ticker ticker = new Ticker(true, 100L);

            @Generated
            public boolean isEnable() {
                return this.enable;
            }

            @Generated
            public ObjectiveModule.Mode getMode() {
                return this.mode;
            }

            @Generated
            public Ticker getTicker() {
                return this.ticker;
            }
        }

        public static final class Tabname
        implements ModuleConfig.MessageConfig.ObjectiveMessageConfig.SubObjectiveMessageConfig {
            private boolean enable = false;
            private ObjectiveModule.Mode mode = ObjectiveModule.Mode.PING;
            private Ticker ticker = new Ticker(true, 100L);

            @Generated
            public boolean isEnable() {
                return this.enable;
            }

            @Generated
            public ObjectiveModule.Mode getMode() {
                return this.mode;
            }

            @Generated
            public Ticker getTicker() {
                return this.ticker;
            }
        }
    }

    public static final class Op
    implements ModuleConfig.MessageConfig.SubMessageConfig,
    Config.IEnable {
        private boolean enable = true;
        private Destination destination = new Destination();
        private Sound sound = new Sound();

        @Override
        @Generated
        public boolean isEnable() {
            return this.enable;
        }

        @Generated
        public Destination getDestination() {
            return this.destination;
        }

        @Generated
        public Sound getSound() {
            return this.sound;
        }
    }

    public static final class Quit
    implements ModuleConfig.MessageConfig.SubMessageConfig,
    Config.IEnable {
        private boolean enable = true;
        private Range range = Range.get(Range.Type.SERVER);
        private Destination destination = new Destination();
        private Sound sound = new Sound();

        @Override
        @Generated
        public boolean isEnable() {
            return this.enable;
        }

        @Generated
        public Range getRange() {
            return this.range;
        }

        @Generated
        public Destination getDestination() {
            return this.destination;
        }

        @Generated
        public Sound getSound() {
            return this.sound;
        }
    }

    public static final class Rightclick
    implements ModuleConfig.MessageConfig.SubMessageConfig,
    Config.IEnable {
        private boolean enable = true;
        private Destination destination = new Destination(Destination.Type.ACTION_BAR, new Times(0, 60, 0));
        private Cooldown cooldown = new Cooldown();
        private Sound sound = new Sound();

        @Override
        @Generated
        public boolean isEnable() {
            return this.enable;
        }

        @Generated
        public Destination getDestination() {
            return this.destination;
        }

        @Generated
        public Cooldown getCooldown() {
            return this.cooldown;
        }

        @Generated
        public Sound getSound() {
            return this.sound;
        }
    }

    public static final class Seed
    implements ModuleConfig.MessageConfig.SubMessageConfig,
    Config.IEnable {
        private boolean enable = true;
        private Destination destination = new Destination();
        private Sound sound = new Sound();

        @Override
        @Generated
        public boolean isEnable() {
            return this.enable;
        }

        @Generated
        public Destination getDestination() {
            return this.destination;
        }

        @Generated
        public Sound getSound() {
            return this.sound;
        }
    }

    public static final class Setblock
    implements ModuleConfig.MessageConfig.SubMessageConfig,
    Config.IEnable {
        private boolean enable = true;
        private Destination destination = new Destination();
        private Sound sound = new Sound();

        @Override
        @Generated
        public boolean isEnable() {
            return this.enable;
        }

        @Generated
        public Destination getDestination() {
            return this.destination;
        }

        @Generated
        public Sound getSound() {
            return this.sound;
        }
    }

    public static final class Sidebar
    implements ModuleConfig.MessageConfig.SubMessageConfig,
    Config.IEnable {
        private boolean enable = false;
        private boolean random = true;
        private Ticker ticker = new Ticker(true, 100L);

        @Override
        @Generated
        public boolean isEnable() {
            return this.enable;
        }

        @Generated
        public boolean isRandom() {
            return this.random;
        }

        @Generated
        public Ticker getTicker() {
            return this.ticker;
        }
    }

    public static final class Sign
    implements ModuleConfig.MessageConfig.SubMessageConfig,
    Config.IEnable {
        private boolean enable = false;

        @Override
        @Generated
        public boolean isEnable() {
            return this.enable;
        }
    }

    public static final class Sleep
    implements ModuleConfig.MessageConfig.SubMessageConfig,
    Config.IEnable {
        private boolean enable = true;
        private Destination destination = new Destination(Destination.Type.ACTION_BAR);
        private Sound sound = new Sound();

        @Override
        @Generated
        public boolean isEnable() {
            return this.enable;
        }

        @Generated
        public Destination getDestination() {
            return this.destination;
        }

        @Generated
        public Sound getSound() {
            return this.sound;
        }
    }

    public static final class Spawn
    implements ModuleConfig.MessageConfig.SubMessageConfig,
    Config.IEnable {
        private boolean enable = true;
        private Destination destination = new Destination();
        private Sound sound = new Sound();

        @Override
        @Generated
        public boolean isEnable() {
            return this.enable;
        }

        @Generated
        public Destination getDestination() {
            return this.destination;
        }

        @Generated
        public Sound getSound() {
            return this.sound;
        }
    }

    public static final class Status
    implements ModuleConfig.MessageConfig.StatusMessageConfig,
    Config.IEnable {
        private boolean enable = true;
        @Comment(value={@CommentValue(value=" https://flectone.net/pulse/docs/message/status/icon/")})
        private Icon icon = new Icon();
        @Comment(value={@CommentValue(value=" https://flectone.net/pulse/docs/message/status/motd/")})
        private MOTD motd = new MOTD();
        @Comment(value={@CommentValue(value=" https://flectone.net/pulse/docs/message/status/players/")})
        private Players players = new Players();
        @Comment(value={@CommentValue(value=" https://flectone.net/pulse/docs/message/status/version/")})
        private Version version = new Version();

        @Override
        @Generated
        public boolean isEnable() {
            return this.enable;
        }

        @Override
        @Generated
        public Icon getIcon() {
            return this.icon;
        }

        @Override
        @Generated
        public MOTD getMotd() {
            return this.motd;
        }

        @Override
        @Generated
        public Players getPlayers() {
            return this.players;
        }

        @Override
        @Generated
        public Version getVersion() {
            return this.version;
        }

        public static final class Icon
        implements ModuleConfig.MessageConfig.StatusMessageConfig.SubStatusMessageConfig,
        Config.IEnable {
            private boolean enable = false;
            private boolean random = true;
            private List<String> values = new ArrayList<String>(){
                {
                    this.add("server-icon-1.png");
                    this.add("server-icon-2.png");
                }
            };

            @Override
            @Generated
            public boolean isEnable() {
                return this.enable;
            }

            @Generated
            public boolean isRandom() {
                return this.random;
            }

            @Generated
            public List<String> getValues() {
                return this.values;
            }
        }

        public static final class MOTD
        implements ModuleConfig.MessageConfig.StatusMessageConfig.SubStatusMessageConfig,
        Config.IEnable {
            private boolean enable = true;
            private boolean random = true;

            @Override
            @Generated
            public boolean isEnable() {
                return this.enable;
            }

            @Generated
            public boolean isRandom() {
                return this.random;
            }
        }

        public static final class Players
        implements ModuleConfig.MessageConfig.StatusMessageConfig.SubStatusMessageConfig,
        Config.IEnable {
            private boolean enable = false;
            private boolean control = true;
            private int max = 69;
            private int online = -69;

            @Override
            @Generated
            public boolean isEnable() {
                return this.enable;
            }

            @Generated
            public boolean isControl() {
                return this.control;
            }

            @Generated
            public int getMax() {
                return this.max;
            }

            @Generated
            public int getOnline() {
                return this.online;
            }
        }

        public static final class Version
        implements ModuleConfig.MessageConfig.StatusMessageConfig.SubStatusMessageConfig,
        Config.IEnable {
            private boolean enable = false;
            private int protocol = -1;

            @Override
            @Generated
            public boolean isEnable() {
                return this.enable;
            }

            @Generated
            public int getProtocol() {
                return this.protocol;
            }
        }
    }

    public static final class Tab
    implements ModuleConfig.MessageConfig.TabMessageConfig,
    Config.IEnable {
        private boolean enable = true;
        @Comment(value={@CommentValue(value=" https://flectone.net/pulse/docs/message/tab/header/")})
        private Header header = new Header();
        @Comment(value={@CommentValue(value=" https://flectone.net/pulse/docs/message/tab/footer/")})
        private Footer footer = new Footer();
        @Comment(value={@CommentValue(value=" https://flectone.net/pulse/docs/message/tab/playerlistname/")})
        private Playerlistname playerlistname = new Playerlistname();

        @Override
        @Generated
        public boolean isEnable() {
            return this.enable;
        }

        @Override
        @Generated
        public Header getHeader() {
            return this.header;
        }

        @Override
        @Generated
        public Footer getFooter() {
            return this.footer;
        }

        @Override
        @Generated
        public Playerlistname getPlayerlistname() {
            return this.playerlistname;
        }

        public static final class Header
        implements ModuleConfig.MessageConfig.TabMessageConfig.SubTabMessageConfig,
        Config.IEnable {
            private boolean enable = true;
            private boolean random = true;
            private Destination destination = new Destination(Destination.Type.TAB_HEADER);
            private Ticker ticker = new Ticker(true, 100L);

            @Override
            @Generated
            public boolean isEnable() {
                return this.enable;
            }

            @Generated
            public boolean isRandom() {
                return this.random;
            }

            @Generated
            public Destination getDestination() {
                return this.destination;
            }

            @Generated
            public Ticker getTicker() {
                return this.ticker;
            }
        }

        public static final class Footer
        implements ModuleConfig.MessageConfig.TabMessageConfig.SubTabMessageConfig,
        Config.IEnable {
            private boolean enable = true;
            private boolean random = true;
            private Destination destination = new Destination(Destination.Type.TAB_FOOTER);
            private Ticker ticker = new Ticker(true, 100L);

            @Override
            @Generated
            public boolean isEnable() {
                return this.enable;
            }

            @Generated
            public boolean isRandom() {
                return this.random;
            }

            @Generated
            public Destination getDestination() {
                return this.destination;
            }

            @Generated
            public Ticker getTicker() {
                return this.ticker;
            }
        }

        public static final class Playerlistname
        implements ModuleConfig.MessageConfig.TabMessageConfig.SubTabMessageConfig,
        Config.IEnable {
            private boolean enable = true;
            private Ticker ticker = new Ticker(true, 100L);

            @Override
            @Generated
            public boolean isEnable() {
                return this.enable;
            }

            @Generated
            public Ticker getTicker() {
                return this.ticker;
            }
        }
    }

    public static final class Update
    implements ModuleConfig.MessageConfig.SubMessageConfig,
    Config.IEnable {
        private boolean enable = true;
        private Destination destination = new Destination();
        private Sound sound = new Sound();

        @Override
        @Generated
        public boolean isEnable() {
            return this.enable;
        }

        @Generated
        public Destination getDestination() {
            return this.destination;
        }

        @Generated
        public Sound getSound() {
            return this.sound;
        }
    }
}

