/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.data.database.dao;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import net.flectone.pulse.data.database.Database;
import net.flectone.pulse.data.database.dao.BaseDAO;
import net.flectone.pulse.data.database.sql.FColorSQL;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.FColor;
import net.flectone.pulse.model.entity.FPlayer;

@Singleton
public class ColorsDAO
extends BaseDAO<FColorSQL> {
    @Inject
    public ColorsDAO(Database database) {
        super(database, FColorSQL.class);
    }

    public void save(FPlayer fPlayer) {
        if (fPlayer.getFColors().isEmpty()) {
            this.delete(fPlayer);
            return;
        }
        this.useTransaction(sql -> Arrays.stream(FColor.Type.values()).forEach(type -> this.saveType((FColorSQL)sql, fPlayer, (FColor.Type)((Object)((Object)type)))));
    }

    public void delete(FPlayer fPlayer) {
        this.useHandle(sql -> sql.deleteFColors(fPlayer.getId()));
    }

    public void load(FPlayer fPlayer) {
        if (fPlayer.isUnknown()) {
            return;
        }
        fPlayer.getFColors().clear();
        this.useHandle(sql -> Arrays.stream(FColor.Type.values()).forEach(type -> this.loadType((FColorSQL)sql, fPlayer, (FColor.Type)((Object)((Object)type)))));
    }

    private void saveType(FColorSQL sql, FPlayer fPlayer, FColor.Type type) {
        Set<FColor> oldFColors;
        Set<FColor> newFColors = fPlayer.getFColors().getOrDefault((Object)type, Collections.emptySet());
        if (newFColors.equals(oldFColors = sql.findFColors(fPlayer.getId(), type.name()))) {
            return;
        }
        if (newFColors.isEmpty()) {
            sql.deleteFColors(fPlayer.getId(), type.name());
            return;
        }
        ArrayList<Integer> fColorsToDelete = new ArrayList<Integer>(oldFColors.stream().map(FColor::number).toList());
        newFColors.forEach(newFColor -> {
            fColorsToDelete.remove((Object)newFColor.number());
            Optional<FColor> optionalOldFColor = oldFColors.stream().filter(oldFColor -> oldFColor.number() == newFColor.number()).findFirst();
            if (optionalOldFColor.isPresent() && optionalOldFColor.get().equals(newFColor)) {
                return;
            }
            int fColorId = sql.findFColorIdByName(newFColor.name()).orElseGet(() -> sql.insertFColor(newFColor.name()));
            if (optionalOldFColor.isPresent()) {
                sql.updateFColor(fPlayer.getId(), newFColor.number(), fColorId, type.name());
            } else {
                sql.insertFColor(fPlayer.getId(), newFColor.number(), fColorId, type.name());
            }
        });
        if (!fColorsToDelete.isEmpty()) {
            sql.deleteFColors(fPlayer.getId(), type.name(), fColorsToDelete);
        }
    }

    private void loadType(FColorSQL sql, FPlayer fPlayer, FColor.Type type) {
        Set<FColor> newFColors = sql.findFColors(fPlayer.getId(), type.name());
        if (!newFColors.isEmpty()) {
            fPlayer.getFColors().put(type, newFColors);
        }
    }
}

