/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.data.database.dao;

import java.net.InetAddress;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.flectone.pulse.data.database.Database;
import net.flectone.pulse.data.database.dao.BaseDAO;
import net.flectone.pulse.data.database.dao.SettingDAO;
import net.flectone.pulse.data.database.sql.FPlayerSQL;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Provider;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.util.logging.FLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
public class FPlayerDAO
extends BaseDAO<FPlayerSQL> {
    private final FLogger logger;
    private final Provider<SettingDAO> settingDAOProvider;

    @Inject
    public FPlayerDAO(Database database, FLogger logger, Provider<SettingDAO> settingDAOProvider) {
        super(database, FPlayerSQL.class);
        this.logger = logger;
        this.settingDAOProvider = settingDAOProvider;
    }

    public boolean insert(UUID uuid, String name) {
        return this.inTransaction(sql -> {
            Optional<PlayerInfo> existingByName = sql.findByName(name);
            if (existingByName.isPresent()) {
                PlayerInfo playerInfo = existingByName.get();
                UUID existingUuid = UUID.fromString(playerInfo.uuid());
                if (!uuid.equals(existingUuid)) {
                    this.updateAndWarn((FPlayerSQL)sql, playerInfo.id(), uuid, name, playerInfo.ip());
                }
                return false;
            }
            Optional<PlayerInfo> existingByUUID = sql.findByUUID(uuid.toString());
            if (existingByUUID.isPresent()) {
                PlayerInfo playerInfo = existingByUUID.get();
                String existingName = playerInfo.name();
                if (!name.equalsIgnoreCase(existingName)) {
                    this.updateAndWarn((FPlayerSQL)sql, playerInfo.id(), uuid, name, playerInfo.ip());
                }
                return false;
            }
            sql.insert(uuid.toString(), name);
            return true;
        });
    }

    public void insertOrIgnore(FPlayer fPlayer) {
        this.useHandle(sql -> {
            Optional<PlayerInfo> existingPlayer = sql.findByUUID(fPlayer.getUuid().toString());
            if (existingPlayer.isEmpty()) {
                sql.insertWithId(fPlayer.getId(), fPlayer.getUuid().toString(), fPlayer.getName());
            }
        });
    }

    public void update(FPlayer fPlayer) {
        if (fPlayer.isUnknown()) {
            return;
        }
        this.useHandle(sql -> sql.update(fPlayer.getId(), fPlayer.isOnline(), fPlayer.getUuid().toString(), fPlayer.getName(), fPlayer.getIp()));
    }

    @NotNull
    public List<FPlayer> getOnlineFPlayers() {
        return this.withHandle(sql -> this.convertToFPlayers(sql.getOnlinePlayers()));
    }

    @NotNull
    public List<FPlayer> getFPlayers() {
        return this.withHandle(sql -> this.convertToFPlayers(sql.getAllPlayers()));
    }

    @NotNull
    public FPlayer getFPlayer(String name) {
        return this.withHandle(sql -> sql.findByName(name).map(this::convertToFPlayer).orElse(FPlayer.UNKNOWN));
    }

    @NotNull
    public FPlayer getFPlayer(InetAddress inetAddress) {
        return this.withHandle(sql -> sql.findByIp(inetAddress.getHostAddress()).map(this::convertToFPlayer).orElse(FPlayer.UNKNOWN));
    }

    @NotNull
    public FPlayer getFPlayer(UUID uuid) {
        return this.withHandle(sql -> sql.findByUUID(uuid.toString()).map(this::convertToFPlayer).orElse(FPlayer.UNKNOWN));
    }

    @NotNull
    public FPlayer getFPlayer(int id) {
        return this.withHandle(sql -> sql.findById(id).map(this::convertToFPlayer).orElse(FPlayer.UNKNOWN));
    }

    public void updateAllToOffline() {
        this.useHandle(FPlayerSQL::updateAllToOffline);
    }

    private void updateAndWarn(FPlayerSQL fPlayerSQL, int id, UUID uuid, String name, String ip) {
        this.logger.warning("Found player " + name + " with different UUID or name, will now use UUID: " + String.valueOf(uuid) + " and name: " + name);
        fPlayerSQL.update(id, true, uuid.toString(), name, ip);
    }

    private FPlayer convertToFPlayer(PlayerInfo entity) {
        return this.convertToFPlayer(entity, true);
    }

    private FPlayer convertToFPlayer(PlayerInfo info, boolean loadSetting) {
        FPlayer fPlayer = new FPlayer(info.id(), info.name(), UUID.fromString(info.uuid()));
        fPlayer.setOnline(info.online());
        fPlayer.setIp(info.ip());
        if (loadSetting) {
            ((SettingDAO)this.settingDAOProvider.get()).load(fPlayer);
        }
        return fPlayer;
    }

    private List<FPlayer> convertToFPlayers(List<PlayerInfo> entities) {
        return entities.stream().map(playerInfo -> this.convertToFPlayer((PlayerInfo)playerInfo, false)).toList();
    }

    public record PlayerInfo(int id, boolean online, String uuid, String name, @Nullable String ip) {
    }
}

