/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.data.database.dao;

import java.util.List;
import net.flectone.pulse.data.database.Database;
import net.flectone.pulse.data.database.dao.BaseDAO;
import net.flectone.pulse.data.database.sql.IgnoreSQL;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.library.jdbi3.v3.core.Handle;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.command.ignore.model.Ignore;
import org.jetbrains.annotations.Nullable;

@Singleton
public class IgnoreDAO
extends BaseDAO<IgnoreSQL> {
    @Inject
    public IgnoreDAO(Database database) {
        super(database, IgnoreSQL.class);
    }

    @Override
    public IgnoreSQL getSQL(Handle handle) {
        return (IgnoreSQL)handle.attach(IgnoreSQL.class);
    }

    @Nullable
    public Ignore insert(FPlayer fSender, FPlayer fIgnored) {
        if (fSender.isUnknown() || fIgnored.isUnknown()) {
            return null;
        }
        return this.inTransaction(sql -> {
            long currentTime = System.currentTimeMillis();
            int insertedId = sql.insert(currentTime, fSender.getId(), fIgnored.getId());
            return new Ignore(insertedId, currentTime, fIgnored.getId());
        });
    }

    public void delete(Ignore ignore) {
        this.useHandle(sql -> sql.delete(ignore.id()));
    }

    public void load(FPlayer fPlayer) {
        if (fPlayer.isUnknown()) {
            return;
        }
        List ignores = this.withHandle(sql -> sql.findByInitiator(fPlayer.getId()));
        fPlayer.getIgnores().addAll(ignores);
    }
}

