/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.data.database.dao;

import java.util.Collections;
import java.util.List;
import net.flectone.pulse.data.database.Database;
import net.flectone.pulse.data.database.dao.BaseDAO;
import net.flectone.pulse.data.database.sql.MailSQL;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.library.jdbi3.v3.core.Handle;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.command.mail.model.Mail;
import org.jetbrains.annotations.Nullable;

@Singleton
public class MailDAO
extends BaseDAO<MailSQL> {
    @Inject
    public MailDAO(Database database) {
        super(database, MailSQL.class);
    }

    @Override
    public MailSQL getSQL(Handle handle) {
        return (MailSQL)handle.attach(MailSQL.class);
    }

    @Nullable
    public Mail insert(FPlayer sender, FPlayer receiver, String message) {
        if (sender.isUnknown() || receiver.isUnknown()) {
            return null;
        }
        return this.inTransaction(mailSQL -> {
            long date = System.currentTimeMillis();
            int id = mailSQL.insert(date, sender.getId(), receiver.getId(), message);
            return new Mail(id, date, sender.getId(), receiver.getId(), message);
        });
    }

    public void delete(Mail mail) {
        this.useHandle(sql -> sql.delete(mail.id()));
    }

    public List<Mail> getReceiver(FPlayer fPlayer) {
        if (fPlayer.isUnknown()) {
            return Collections.emptyList();
        }
        return this.withHandle(sql -> sql.findByReceiver(fPlayer.getId()));
    }

    public List<Mail> getSender(FPlayer fPlayer) {
        if (fPlayer.isUnknown()) {
            return Collections.emptyList();
        }
        return this.withHandle(sql -> sql.findBySender(fPlayer.getId()));
    }
}

