/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.data.database.dao;

import java.util.Optional;
import net.flectone.pulse.data.database.Database;
import net.flectone.pulse.data.database.dao.BaseDAO;
import net.flectone.pulse.data.database.sql.SettingSQL;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;

@Singleton
public class SettingDAO
extends BaseDAO<SettingSQL> {
    @Inject
    public SettingDAO(Database database) {
        super(database, SettingSQL.class);
    }

    public void save(FPlayer player) {
        this.useTransaction(sql -> {
            for (FPlayer.Setting setting : FPlayer.Setting.values()) {
                if (!player.isSetting(setting)) {
                    this.delete(player, setting);
                    continue;
                }
                int updated = sql.updateSetting(player.getId(), setting.name(), player.getSettingValue(setting));
                if (updated != 0) continue;
                sql.insertSetting(player.getId(), setting.name(), player.getSettingValue(setting));
            }
        });
    }

    public void load(FPlayer player) {
        player.getSettings().clear();
        this.useHandle(sql -> {
            for (FPlayer.Setting setting : FPlayer.Setting.values()) {
                sql.getSetting(player.getId(), setting.name()).ifPresent(value -> player.setSetting(setting, (String)value));
            }
        });
    }

    public Optional<String> get(FPlayer player, FPlayer.Setting setting) {
        return this.withHandle(sql -> sql.getSetting(player.getId(), setting.name()));
    }

    public void delete(FPlayer player, FPlayer.Setting setting) {
        this.useHandle(sql -> sql.deleteSetting(player.getId(), setting.name()));
    }

    public void insert(FPlayer player, FPlayer.Setting setting) {
        this.useHandle(sql -> sql.insertSetting(player.getId(), setting.name(), player.getSettingValue(setting)));
    }

    public void update(FPlayer player, FPlayer.Setting setting) {
        this.useHandle(sql -> sql.updateSetting(player.getId(), setting.name(), player.getSettingValue(setting)));
    }

    public void insertOrUpdate(FPlayer player, FPlayer.Setting setting) {
        this.useHandle(sql -> {
            int updated = sql.updateSetting(player.getId(), setting.name(), player.getSettingValue(setting));
            if (updated == 0) {
                sql.insertSetting(player.getId(), setting.name(), player.getSettingValue(setting));
            }
        });
    }
}

