/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.data.database.sql;

import java.util.List;
import net.flectone.pulse.data.database.sql.SQL;
import net.flectone.pulse.library.jdbi3.v3.sqlobject.customizer.Bind;
import net.flectone.pulse.library.jdbi3.v3.sqlobject.statement.GetGeneratedKeys;
import net.flectone.pulse.library.jdbi3.v3.sqlobject.statement.SqlQuery;
import net.flectone.pulse.library.jdbi3.v3.sqlobject.statement.SqlUpdate;
import net.flectone.pulse.model.util.Moderation;

public interface ModerationSQL
extends SQL {
    @SqlQuery(value="SELECT * FROM `moderation` WHERE `player` = :player AND `type` = :type")
    public List<Moderation> findByPlayerAndType(@Bind(value="player") int var1, @Bind(value="type") int var2);

    @SqlQuery(value="SELECT * FROM `moderation` WHERE `player` = :player AND `type` = :type AND `valid` = true AND (`time` = -1 OR `time` > :currentTime)")
    public List<Moderation> findValidByPlayerAndType(@Bind(value="player") int var1, @Bind(value="type") int var2, @Bind(value="currentTime") long var3);

    @SqlQuery(value="SELECT * FROM `moderation` WHERE `type` = :type AND `valid` = true AND (`time` = -1 OR `time` > :currentTime)")
    public List<Moderation> findValidByType(@Bind(value="type") int var1, @Bind(value="currentTime") long var2);

    @SqlQuery(value="SELECT `p`.`name` FROM `moderation` `m` JOIN `player` `p` ON `p`.`id` = `m`.`player` WHERE `m`.`type` = :type AND `m`.`valid` = true AND (`m`.`time` = -1 OR `m`.`time` > :currentTime)")
    public List<String> findValidPlayerNamesByType(@Bind(value="type") int var1, @Bind(value="currentTime") long var2);

    @SqlUpdate(value="INSERT INTO `moderation` (`player`, `date`, `time`, `reason`, `moderator`, `type`, `valid`) VALUES (:player, :date, :time, :reason, :moderator, :type, true)")
    @GetGeneratedKeys(value={"id"})
    public int insert(@Bind(value="player") int var1, @Bind(value="date") long var2, @Bind(value="time") long var4, @Bind(value="reason") String var6, @Bind(value="moderator") int var7, @Bind(value="type") int var8);

    @SqlUpdate(value="UPDATE `moderation` SET `valid` = false WHERE `id` = :id")
    public void invalidate(@Bind(value="id") int var1);
}

