/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.data.repository;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.flectone.pulse.data.database.dao.ModerationDAO;
import net.flectone.pulse.library.guava.cache.Cache;
import net.flectone.pulse.library.guava.cache.CacheBuilder;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.util.Moderation;

@Singleton
public class ModerationRepository {
    private final Cache<CacheKey, List<Moderation>> moderationCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).maximumSize(5000L).build();
    private final ModerationDAO moderationDAO;

    @Inject
    public ModerationRepository(ModerationDAO moderationDAO) {
        this.moderationDAO = moderationDAO;
    }

    public List<Moderation> getValid(FPlayer player, Moderation.Type type) {
        try {
            CacheKey key = new CacheKey(player.getUuid(), type);
            List cached = (List)this.moderationCache.get((Object)key, () -> this.moderationDAO.getValid(player, type));
            if (cached.stream().anyMatch(Moderation::isActive)) {
                return cached;
            }
            List<Moderation> valid = cached.stream().filter(Moderation::isActive).toList();
            this.moderationCache.put((Object)key, valid);
            return valid;
        }
        catch (Exception e) {
            return List.of();
        }
    }

    public void invalidate(UUID playerId, Moderation.Type type) {
        this.moderationCache.invalidate((Object)new CacheKey(playerId, type));
    }

    public void invalidateAll() {
        this.moderationCache.invalidateAll();
    }

    public void invalidateAll(UUID playerId) {
        for (Moderation.Type type : Moderation.Type.values()) {
            this.invalidate(playerId, type);
        }
    }

    public List<Moderation> get(FPlayer fPlayer, Moderation.Type type) {
        return this.moderationDAO.get(fPlayer, type);
    }

    public Moderation save(FPlayer fTarget, long time, String reason, int moderatorID, Moderation.Type type) {
        return this.moderationDAO.insert(fTarget, time, reason, moderatorID, type);
    }

    public List<Moderation> getValid(Moderation.Type type) {
        return this.moderationDAO.getValid(type);
    }

    public List<String> getValidNames(Moderation.Type type) {
        return this.moderationDAO.getValidPlayersNames(type);
    }

    public void updateValid(Moderation moderation) {
        this.moderationDAO.updateValid(moderation);
    }

    private record CacheKey(UUID playerId, Moderation.Type type) {
    }
}

