/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.data.repository;

import java.util.List;
import net.flectone.pulse.data.database.dao.IgnoreDAO;
import net.flectone.pulse.data.database.dao.MailDAO;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.command.ignore.model.Ignore;
import net.flectone.pulse.module.command.mail.model.Mail;

@Singleton
public class SocialRepository {
    private final IgnoreDAO ignoreDAO;
    private final MailDAO mailDAO;

    @Inject
    public SocialRepository(IgnoreDAO ignoreDAO, MailDAO mailDAO) {
        this.ignoreDAO = ignoreDAO;
        this.mailDAO = mailDAO;
    }

    public void loadIgnores(FPlayer fPlayer) {
        this.ignoreDAO.load(fPlayer);
    }

    public List<Mail> getReceiverMails(FPlayer fPlayer) {
        return this.mailDAO.getReceiver(fPlayer);
    }

    public List<Mail> getSenderMails(FPlayer fPlayer) {
        return this.mailDAO.getSender(fPlayer);
    }

    public Ignore saveAndGetIgnore(FPlayer fPlayer, FPlayer fTarget) {
        return this.ignoreDAO.insert(fPlayer, fTarget);
    }

    public Mail saveAndGetMail(FPlayer fPlayer, FPlayer fTarget, String message) {
        return this.mailDAO.insert(fPlayer, fTarget, message);
    }

    public void deleteIgnore(Ignore ignore) {
        this.ignoreDAO.delete(ignore);
    }

    public void deleteMail(Mail mail) {
        this.mailDAO.delete(mail);
    }
}

