/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.execution.dispatcher;

import java.util.EnumMap;
import java.util.List;
import java.util.function.Consumer;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.event.Event;
import net.flectone.pulse.platform.registry.ListenerRegistry;

@Singleton
public class EventDispatcher {
    private final ListenerRegistry listenerRegistry;

    @Inject
    public EventDispatcher(ListenerRegistry listenerRegistry) {
        this.listenerRegistry = listenerRegistry;
    }

    public void dispatch(Event event) {
        EnumMap<Event.Priority, List<Consumer<Event>>> priorityMap = this.listenerRegistry.getPulseListeners().get(event.getClass());
        if (priorityMap == null) {
            return;
        }
        for (Event.Priority priority : Event.Priority.values()) {
            List<Consumer<Event>> handlersList = priorityMap.get((Object)priority);
            if (handlersList == null) continue;
            handlersList.forEach(handler -> handler.accept(event));
        }
    }
}

