/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.execution.pipeline;

import com.google.gson.JsonElement;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import net.flectone.pulse.execution.dispatcher.EventDispatcher;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.message.MessageFormattingEvent;
import net.flectone.pulse.processing.context.MessageContext;
import net.flectone.pulse.util.constant.MessageFlag;
import net.flectone.pulse.util.logging.FLogger;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.TagPattern;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.minimessage.tag.standard.StandardTags;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.intellij.lang.annotations.Subst;
import org.jetbrains.annotations.NotNull;

@Singleton
public class MessagePipeline {
    private final FLogger fLogger;
    private final MiniMessage miniMessage;
    private final EventDispatcher eventDispatcher;

    @Inject
    public MessagePipeline(FLogger fLogger, MiniMessage miniMessage, EventDispatcher eventDispatcher) {
        this.fLogger = fLogger;
        this.miniMessage = miniMessage;
        this.eventDispatcher = eventDispatcher;
    }

    public Builder builder(@NotNull String message) {
        return this.builder(FPlayer.UNKNOWN, message);
    }

    public Builder builder(@NotNull FPlayer sender, @NotNull String message) {
        return new Builder(sender, sender, message);
    }

    public Builder builder(@NotNull FEntity sender, @NotNull FPlayer receiver, @NotNull String message) {
        return new Builder(sender, receiver, message);
    }

    public Builder builder(UUID messageUUID, @NotNull FEntity sender, @NotNull FPlayer receiver, @NotNull String message) {
        return new Builder(messageUUID, sender, receiver, message);
    }

    public class Builder {
        private final MessageContext context;

        public Builder(UUID messageUUID, FEntity sender, FPlayer receiver, String message) {
            this.context = new MessageContext(messageUUID, sender, receiver, message);
        }

        public Builder(FEntity sender, FPlayer receiver, String message) {
            this(UUID.randomUUID(), sender, receiver, message);
        }

        public Builder flag(MessageFlag flag, boolean value) {
            this.context.setFlag(flag, value);
            return this;
        }

        public Builder flags(Map<MessageFlag, Boolean> flags) {
            this.context.setFlags(flags);
            return this;
        }

        public Builder setUserMessage(String userMessage) {
            this.context.setUserMessage(userMessage);
            return this;
        }

        public Builder translate(boolean translate) {
            this.context.setFlag(MessageFlag.TRANSLATE, translate);
            return this;
        }

        public Builder tagResolvers(TagResolver ... tagResolvers) {
            this.context.addTagResolvers(tagResolvers);
            return this;
        }

        public Component build() {
            MessagePipeline.this.eventDispatcher.dispatch(new MessageFormattingEvent(this.context));
            Arrays.stream(ReplacementTag.values()).filter(tag -> this.context.getTagResolvers().stream().filter(tagResolver -> !tagResolver.equals((Object)StandardTags.translatable())).noneMatch(tagResolver -> tagResolver.has(tag.getTagName()))).forEach(tag -> this.context.addReplacementTag(tag.empty()));
            try {
                return MessagePipeline.this.miniMessage.deserialize(Strings.CS.replace(this.context.getMessage(), "\u00a7", "&"), this.context.getTagResolvers().toArray(new TagResolver[0]));
            }
            catch (Exception e) {
                MessagePipeline.this.fLogger.warning(e);
                return Component.empty();
            }
        }

        public String defaultSerializerBuild() {
            return (String)MiniMessage.miniMessage().serialize(this.build());
        }

        public String plainSerializerBuild() {
            return PlainTextComponentSerializer.plainText().serialize(this.build());
        }

        public String legacySerializerBuild() {
            return LegacyComponentSerializer.legacySection().serialize(this.build());
        }

        public JsonElement jsonSerializerBuild() {
            return GsonComponentSerializer.gson().serializeToTree(this.build());
        }

        @Generated
        public MessageContext getContext() {
            return this.context;
        }
    }

    public static enum ReplacementTag {
        AFK_SUFFIX,
        STREAM_PREFIX,
        VAULT_SUFFIX,
        VAULT_PREFIX,
        DELETE,
        DISPLAY_NAME,
        PLAYER,
        CONSTANT,
        REPLACEMENT,
        MENTION,
        SWEAR,
        QUESTION,
        TRANSLATE,
        WORLD_PREFIX,
        IMAGE,
        PING,
        TPS,
        ONLINE,
        COORDS,
        STATS,
        STYLE,
        SKIN,
        ITEM,
        URL,
        FCOLOR,
        TRANSLATETO,
        SPOILER;


        @Subst(value="")
        public String getTagName() {
            return this.name().toLowerCase();
        }

        public TagResolver empty() {
            return ReplacementTag.empty(this.getTagName());
        }

        public static TagResolver empty(@TagPattern String tag) {
            return TagResolver.resolver((String)tag, (argumentQueue, context) -> Tag.selfClosingInserting((Component)Component.empty()));
        }
    }
}

