/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.execution.scheduler;

import java.util.List;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import net.flectone.pulse.exception.SchedulerTaskException;
import net.flectone.pulse.execution.scheduler.SchedulerRunnable;
import net.flectone.pulse.execution.scheduler.TaskScheduler;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.util.logging.FLogger;

@Singleton
public class FabricTaskScheduler
implements TaskScheduler {
    private final AtomicLong currentTick = new AtomicLong(0L);
    private final ConcurrentSkipListMap<Long, List<ScheduledTask>> scheduledTasks = new ConcurrentSkipListMap();
    private final FLogger logger;
    private ExecutorService asyncExecutor;
    private volatile boolean disabled = false;

    @Inject
    public FabricTaskScheduler(FLogger logger) {
        this.logger = logger;
        this.createExecutorService();
    }

    @Override
    public void shutdown() {
        this.disabled = true;
        this.asyncExecutor.shutdown();
        try {
            if (!this.asyncExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.asyncExecutor.shutdownNow();
            }
        }
        catch (InterruptedException ignored) {
            this.asyncExecutor.shutdownNow();
        }
        this.scheduledTasks.clear();
    }

    @Override
    public void reload() {
        this.shutdown();
        this.createExecutorService();
        this.scheduledTasks.clear();
        this.currentTick.set(0L);
        this.disabled = false;
    }

    @Override
    public void runAsync(SchedulerRunnable runnable) {
        if (this.disabled) {
            return;
        }
        this.asyncExecutor.execute(this.wrapExceptionRunnable(runnable));
    }

    @Override
    public void runAsyncTimer(SchedulerRunnable runnable, long tick, long period) {
        if (this.disabled) {
            return;
        }
        long firstTick = this.currentTick.get() + tick;
        ScheduledTask task = new ScheduledTask(this.wrapExceptionRunnable(runnable), firstTick, period, true);
        this.registerTask(firstTick, task);
    }

    @Override
    public void runAsyncTimer(SchedulerRunnable runnable, long tick) {
        this.runAsyncTimer(runnable, tick, tick);
    }

    @Override
    public void runAsyncLater(SchedulerRunnable runnable, long tick) {
        if (this.disabled) {
            return;
        }
        long firstTick = this.currentTick.get() + tick;
        ScheduledTask task = new ScheduledTask(this.wrapExceptionRunnable(runnable), firstTick, -1L, true);
        this.registerTask(firstTick, task);
    }

    @Override
    public void runSync(SchedulerRunnable runnable) {
        if (this.disabled) {
            return;
        }
        long firstTick = this.currentTick.get();
        ScheduledTask task = new ScheduledTask(this.wrapExceptionRunnable(runnable), firstTick, -1L, false);
        this.registerTask(firstTick, task);
    }

    @Override
    public void runSyncRegion(Object entity, SchedulerRunnable runnable) {
        this.runSync(runnable);
    }

    @Override
    public void runSyncTimer(SchedulerRunnable runnable, long tick, long period) {
        if (this.disabled) {
            return;
        }
        long firstTick = this.currentTick.get() + tick;
        ScheduledTask task = new ScheduledTask(this.wrapExceptionRunnable(runnable), firstTick, period, false);
        this.registerTask(firstTick, task);
    }

    @Override
    public void runSyncTimer(SchedulerRunnable runnable, long tick) {
        this.runSyncTimer(runnable, tick, tick);
    }

    @Override
    public void runSyncLater(SchedulerRunnable runnable, long tick) {
        if (this.disabled) {
            return;
        }
        long firstTick = this.currentTick.get() + tick;
        ScheduledTask task = new ScheduledTask(this.wrapExceptionRunnable(runnable), firstTick, -1L, false);
        this.registerTask(firstTick, task);
    }

    public void onTick() {
        if (this.disabled) {
            return;
        }
        long tick = this.currentTick.getAndIncrement();
        this.processTasks(tick);
    }

    private void processTasks(long tick) {
        List<ScheduledTask> tasks = this.scheduledTasks.get(tick);
        if (tasks == null) {
            return;
        }
        tasks.removeIf(task -> {
            if (task.isCanceled) {
                return true;
            }
            this.executeTask((ScheduledTask)task);
            return true;
        });
    }

    private void executeTask(ScheduledTask task) {
        try {
            if (task.isAsync) {
                this.asyncExecutor.execute(task.runnable);
            } else {
                task.runnable.run();
            }
            if (task.isRepeating()) {
                this.rescheduleTask(task);
            }
        }
        catch (Exception e) {
            this.logger.warning("Task execution failed: " + e.getMessage());
        }
    }

    private void rescheduleTask(ScheduledTask task) {
        if (task.isRepeating()) {
            task.nextTick += task.period;
            this.registerTask(task.nextTick, task);
        }
    }

    private void registerTask(long tick, ScheduledTask task) {
        this.scheduledTasks.compute(tick, (k, v) -> {
            if (v == null) {
                v = new CopyOnWriteArrayList<ScheduledTask>();
            }
            v.add(task);
            return v;
        });
    }

    private Runnable wrapExceptionRunnable(SchedulerRunnable runnable) {
        return () -> {
            try {
                runnable.run();
            }
            catch (SchedulerTaskException e) {
                this.logger.warning("Task error: " + e.getMessage());
            }
        };
    }

    private void createExecutorService() {
        ThreadFactory namedThreadFactory = new ThreadFactory(this){
            private final AtomicLong threadCounter = new AtomicLong(0L);

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable);
                thread.setName("FlectonePulseThread-" + this.threadCounter.incrementAndGet());
                return thread;
            }
        };
        this.asyncExecutor = Executors.newCachedThreadPool(namedThreadFactory);
    }

    private static class ScheduledTask {
        private final Runnable runnable;
        private final long period;
        private long nextTick;
        private final boolean isAsync;
        private boolean isCanceled;

        ScheduledTask(Runnable runnable, long firstTick, long period, boolean isAsync) {
            this.runnable = runnable;
            this.nextTick = firstTick;
            this.period = period;
            this.isAsync = isAsync;
        }

        boolean isRepeating() {
            return this.period > 0L;
        }
    }
}

