/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.listener;

import com.github.retrooper.packetevents.event.PacketListener;
import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.event.PacketSendEvent;
import com.github.retrooper.packetevents.manager.server.ServerVersion;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.protocol.packettype.PacketTypeCommon;
import com.github.retrooper.packetevents.protocol.player.User;
import com.github.retrooper.packetevents.protocol.player.UserProfile;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.login.server.WrapperLoginServerDisconnect;
import com.github.retrooper.packetevents.wrapper.login.server.WrapperLoginServerLoginSuccess;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientSettings;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerChatMessage;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSystemChatMessage;
import java.util.Optional;
import java.util.UUID;
import net.flectone.pulse.execution.dispatcher.EventDispatcher;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.message.MessageReceiveEvent;
import net.flectone.pulse.platform.provider.PacketProvider;
import net.flectone.pulse.platform.sender.PacketSender;
import net.flectone.pulse.processing.processor.PlayerPreLoginProcessor;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.constant.MinecraftTranslationKey;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TranslatableComponent;
import org.incendo.cloud.type.tuple.Triplet;

@Singleton
public class BasePacketListener
implements PacketListener {
    private final FPlayerService fPlayerService;
    private final EventDispatcher eventDispatcher;
    private final PacketProvider packetProvider;
    private final PacketSender packetSender;
    private final PlayerPreLoginProcessor playerPreLoginProcessor;

    @Inject
    public BasePacketListener(FPlayerService fPlayerService, EventDispatcher eventDispatcher, PacketProvider packetProvider, PacketSender packetSender, PlayerPreLoginProcessor playerPreLoginProcessor) {
        this.fPlayerService = fPlayerService;
        this.eventDispatcher = eventDispatcher;
        this.packetProvider = packetProvider;
        this.packetSender = packetSender;
        this.playerPreLoginProcessor = playerPreLoginProcessor;
    }

    public void onPacketReceive(PacketReceiveEvent event) {
        PacketTypeCommon packetType = event.getPacketType();
        if (packetType != PacketType.Play.Client.CLIENT_SETTINGS && packetType != PacketType.Configuration.Client.CLIENT_SETTINGS) {
            return;
        }
        UUID uuid = event.getUser().getUUID();
        if (uuid == null) {
            return;
        }
        FPlayer fPlayer = this.fPlayerService.getFPlayer(uuid);
        WrapperPlayClientSettings wrapperPlayClientSettings = new WrapperPlayClientSettings(event);
        String wrapperLocale = wrapperPlayClientSettings.getLocale();
        this.fPlayerService.updateLocale(fPlayer, wrapperLocale);
        this.fPlayerService.updateLocaleLater(uuid, wrapperLocale);
    }

    public void onPacketSend(PacketSendEvent event) {
        Optional<Triplet<Component, MinecraftTranslationKey, Boolean>> optionalTriplet;
        if (event.isCancelled()) {
            return;
        }
        if (event.getPacketType() == PacketType.Login.Server.LOGIN_SUCCESS && this.packetProvider.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_20_2)) {
            WrapperLoginServerLoginSuccess wrapper = new WrapperLoginServerLoginSuccess(event);
            UserProfile userProfile = wrapper.getUserProfile();
            UUID uuid = userProfile.getUUID();
            if (uuid == null) {
                return;
            }
            String playerName = userProfile.getName();
            if (playerName == null) {
                return;
            }
            event.setCancelled(true);
            this.playerPreLoginProcessor.processAsyncLogin(uuid, playerName, loginEvent -> this.packetSender.send(uuid, (PacketWrapper<?>)new WrapperLoginServerLoginSuccess(uuid, playerName)), loginEvent -> this.packetSender.send(uuid, (PacketWrapper<?>)new WrapperLoginServerDisconnect(loginEvent.getKickReason())));
        }
        if ((optionalTriplet = this.toMessageReceiveEvent(event)).isEmpty()) {
            return;
        }
        User user = event.getUser();
        if (user == null) {
            return;
        }
        UUID userUUID = user.getUUID();
        if (userUUID == null) {
            return;
        }
        Triplet<Component, MinecraftTranslationKey, Boolean> triplet = optionalTriplet.get();
        if (triplet.second() == MinecraftTranslationKey.MULTIPLAYER_MESSAGE_NOT_DELIVERED) {
            event.setCancelled(true);
            return;
        }
        FPlayer fPlayer = this.fPlayerService.getFPlayer(userUUID);
        MessageReceiveEvent messageReceiveEvent = new MessageReceiveEvent(fPlayer, triplet);
        this.eventDispatcher.dispatch(messageReceiveEvent);
        event.setCancelled(messageReceiveEvent.isCancelled());
    }

    private Optional<Triplet<Component, MinecraftTranslationKey, Boolean>> toMessageReceiveEvent(PacketSendEvent event) {
        Component component = null;
        MinecraftTranslationKey translationKey = MinecraftTranslationKey.UNKNOWN;
        boolean overlay = false;
        if (event.getPacketType() == PacketType.Play.Server.CHAT_MESSAGE) {
            wrapper = new WrapperPlayServerChatMessage(event);
            component = wrapper.getMessage().getChatContent();
        } else if (event.getPacketType() == PacketType.Play.Server.SYSTEM_CHAT_MESSAGE) {
            wrapper = new WrapperPlayServerSystemChatMessage(event);
            component = wrapper.getMessage();
            overlay = wrapper.isOverlay();
        }
        if (component instanceof TranslatableComponent) {
            TranslatableComponent translatableComponent = (TranslatableComponent)component;
            translationKey = MinecraftTranslationKey.fromString(translatableComponent);
        }
        if (component != null) {
            return Optional.of(Triplet.of((Object)component, (Object)((Object)translationKey), (Object)overlay));
        }
        return Optional.empty();
    }
}

