/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.listener;

import net.flectone.pulse.annotation.Pulse;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.listener.PulseListener;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.Event;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.model.event.message.MessageSendEvent;
import net.flectone.pulse.model.event.message.PreMessageSendEvent;
import net.flectone.pulse.model.event.player.PlayerJoinEvent;
import net.flectone.pulse.model.event.player.PlayerPersistAndDisposeEvent;
import net.flectone.pulse.model.util.Sound;
import net.flectone.pulse.platform.adapter.PlatformPlayerAdapter;
import net.flectone.pulse.platform.sender.IntegrationSender;
import net.flectone.pulse.platform.sender.ProxySender;
import net.flectone.pulse.platform.sender.SoundPlayer;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.constant.MessageType;

@Singleton
public class BasePulseListener
implements PulseListener {
    private final FPlayerService fPlayerService;
    private final PlatformPlayerAdapter platformPlayerAdapter;
    private final ProxySender proxySender;
    private final IntegrationSender integrationSender;
    private final SoundPlayer soundPlayer;

    @Inject
    public BasePulseListener(FPlayerService fPlayerService, PlatformPlayerAdapter platformPlayerAdapter, ProxySender proxySender, IntegrationSender integrationSender, SoundPlayer soundPlayer) {
        this.fPlayerService = fPlayerService;
        this.platformPlayerAdapter = platformPlayerAdapter;
        this.proxySender = proxySender;
        this.integrationSender = integrationSender;
        this.soundPlayer = soundPlayer;
    }

    @Pulse(priority=Event.Priority.LOWEST, ignoreCancelled=true)
    public void onPlayerJoinEvent(PlayerJoinEvent event) {
        FPlayer fPlayer = event.getPlayer();
        fPlayer.setIp(this.platformPlayerAdapter.getIp(fPlayer));
        this.fPlayerService.saveFPlayerData(fPlayer);
    }

    @Pulse
    public void onPlayerPersistAndDispose(PlayerPersistAndDisposeEvent event) {
        FPlayer fPlayer = event.getPlayer();
        this.fPlayerService.clearAndSave(fPlayer);
    }

    @Pulse
    public void onMessageSendEvent(MessageSendEvent event) {
        EventMetadata<?> eventMetadata = event.getEventMetadata();
        if (eventMetadata.getSound() != null) {
            Sound sound = eventMetadata.getSound();
            this.soundPlayer.play(sound, eventMetadata.getSender(), event.getReceiver());
        }
    }

    @Pulse
    public void onPreMessageSendEvent(PreMessageSendEvent event) {
        MessageType messageType = event.getMessageType();
        String rawFormat = event.getRawFormat();
        EventMetadata<?> eventMetadata = event.getEventMetadata();
        this.integrationSender.send(messageType, rawFormat, eventMetadata);
        if (this.proxySender.send(messageType, eventMetadata)) {
            event.setCancelled(true);
        }
    }
}

