/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.listener;

import com.github.retrooper.packetevents.event.PacketListener;
import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.protocol.player.User;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientCustomClickAction;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.flectone.pulse.library.guava.cache.Cache;
import net.flectone.pulse.library.guava.cache.CacheBuilder;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.platform.controller.DialogController;

@Singleton
public class DialogPacketListener
implements PacketListener {
    private final Cache<UUID, AtomicInteger> clickCounts = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.SECONDS).build();
    private final DialogController dialogController;

    @Inject
    public DialogPacketListener(DialogController dialogController) {
        this.dialogController = dialogController;
    }

    public void onPacketReceive(PacketReceiveEvent event) {
        if (event.getPacketType() == PacketType.Play.Client.CUSTOM_CLICK_ACTION) {
            User user = event.getUser();
            if (this.isSpam(user.getUUID())) {
                return;
            }
            WrapperPlayClientCustomClickAction wrapper = new WrapperPlayClientCustomClickAction(event);
            String key = wrapper.getId().getKey();
            this.dialogController.process(user.getUUID(), key, wrapper.getPayload());
        }
    }

    public boolean isSpam(UUID uuid) {
        int current;
        AtomicInteger count = (AtomicInteger)this.clickCounts.getIfPresent((Object)uuid);
        if (count == null) {
            count = new AtomicInteger(0);
            this.clickCounts.put((Object)uuid, (Object)count);
        }
        return (current = count.incrementAndGet()) > 5;
    }
}

