/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.model.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import net.flectone.pulse.model.FColor;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.module.command.ignore.model.Ignore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FPlayer
extends FEntity {
    public static final FPlayer UNKNOWN = new FPlayer(FEntity.unknownName);
    private final int id;
    private final Map<FColor.Type, Set<FColor>> fColors = new EnumMap<FColor.Type, Set<FColor>>(FColor.Type.class);
    private final Map<Setting, String> settings = new EnumMap<Setting, String>(Setting.class);
    private final List<Ignore> ignores = new ArrayList<Ignore>();
    private boolean online;
    private String ip;
    private String constantName;

    public FPlayer(int id, String name, UUID uuid, String type) {
        super(name, uuid, type);
        this.id = id;
    }

    public FPlayer(int id, String name, UUID uuid) {
        this(id, name, uuid, "player");
    }

    public FPlayer(String name) {
        this(-1, name, FEntity.unknownUUID, "unknown");
        this.setDefaultSettings();
    }

    public void setOnline(boolean online) {
        if (this.isUnknown()) {
            return;
        }
        this.online = online;
    }

    public void setIp(String ip) {
        if (this.isUnknown()) {
            return;
        }
        this.ip = ip;
    }

    public void setConstantName(String constantName) {
        if (this.isUnknown()) {
            return;
        }
        this.constantName = constantName;
    }

    public boolean isIgnored(@NotNull FPlayer fPlayer) {
        if (this.ignores.isEmpty()) {
            return false;
        }
        return this.ignores.stream().anyMatch(ignore -> ignore.target() == fPlayer.getId());
    }

    public void setSetting(Setting setting) {
        this.setSetting(setting, "");
    }

    public void setSetting(Setting setting, @Nullable String value) {
        this.settings.put(setting, value);
    }

    public void setDefaultSettings() {
        this.setSetting(Setting.ADVANCEMENT);
        this.setSetting(Setting.DEATH);
        this.setSetting(Setting.JOIN);
        this.setSetting(Setting.QUIT);
        this.setSetting(Setting.AUTO);
        this.setSetting(Setting.ME);
        this.setSetting(Setting.TRY);
        this.setSetting(Setting.DICE);
        this.setSetting(Setting.BALL);
        this.setSetting(Setting.MUTE);
        this.setSetting(Setting.BAN);
        this.setSetting(Setting.WARN);
        this.setSetting(Setting.TELL);
        this.setSetting(Setting.REPLY);
        this.setSetting(Setting.MAIL);
        this.setSetting(Setting.TICTACTOE);
        this.setSetting(Setting.KICK);
        this.setSetting(Setting.TRANSLATETO);
        this.setSetting(Setting.BROADCAST);
        this.setSetting(Setting.DO);
        this.setSetting(Setting.COIN);
        this.setSetting(Setting.AFK);
        this.setSetting(Setting.POLL);
        this.setSetting(Setting.GREETING);
        this.setSetting(Setting.ROCKPAPERSCISSORS);
        this.setSetting(Setting.DISCORD);
        this.setSetting(Setting.TELEGRAM);
        this.setSetting(Setting.TWITCH);
        this.setSetting(Setting.ANON);
    }

    public boolean isSetting(Setting setting) {
        return this.settings.containsKey((Object)setting);
    }

    @Nullable
    public String getSettingValue(Setting setting) {
        return this.settings.get((Object)setting);
    }

    public void removeSetting(Setting setting) {
        this.settings.remove((Object)setting);
    }

    public boolean equals(FPlayer fPlayer) {
        return this.id == fPlayer.getId();
    }

    @Override
    public boolean isUnknown() {
        return this.getId() == -1;
    }

    public Map<Integer, String> getFColors(FColor.Type type) {
        return this.fColors.getOrDefault((Object)type, Collections.emptySet()).stream().collect(Collectors.toMap(FColor::number, FColor::name));
    }

    @Generated
    public int getId() {
        return this.id;
    }

    @Generated
    public Map<FColor.Type, Set<FColor>> getFColors() {
        return this.fColors;
    }

    @Generated
    public Map<Setting, String> getSettings() {
        return this.settings;
    }

    @Generated
    public List<Ignore> getIgnores() {
        return this.ignores;
    }

    @Generated
    public boolean isOnline() {
        return this.online;
    }

    @Generated
    public String getIp() {
        return this.ip;
    }

    @Generated
    public String getConstantName() {
        return this.constantName;
    }

    public static enum Setting {
        COLOR,
        STYLE,
        ADVANCEMENT,
        AFK,
        AFK_SUFFIX,
        AUTO,
        BALL,
        BAN,
        BROADCAST,
        CHAT,
        COIN,
        DEATH,
        DICE,
        DISCORD,
        DO,
        GREETING,
        JOIN,
        KICK,
        LOCALE,
        MAIL,
        ME,
        MUTE,
        POLL,
        QUIT,
        REPLY,
        ROCKPAPERSCISSORS,
        SPY,
        STREAM,
        STREAM_PREFIX,
        TELEGRAM,
        TELL,
        TICTACTOE,
        TRANSLATETO,
        TRY,
        TWITCH,
        WARN,
        WORLD_PREFIX,
        ANON;


        @Nullable
        public static Setting fromString(String setting) {
            return Arrays.stream(Setting.values()).filter(s -> s.name().equalsIgnoreCase(setting)).findFirst().orElse(null);
        }
    }
}

