/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.model.event;

import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import lombok.Generated;
import lombok.NonNull;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.util.Destination;
import net.flectone.pulse.model.util.Range;
import net.flectone.pulse.model.util.Sound;
import net.flectone.pulse.util.ProxyDataConsumer;
import net.flectone.pulse.util.SafeDataOutputStream;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.jetbrains.annotations.Nullable;

public class EventMetadata<L extends Localization.Localizable> {
    private final UUID uuid;
    @NonNull
    private final FEntity sender;
    @Nullable
    private final FPlayer filterPlayer;
    private final Predicate<FPlayer> filter;
    private final boolean senderColorOut;
    @NonNull
    private final BiFunction<FPlayer, L, String> format;
    @NonNull
    private final Destination destination;
    @NonNull
    private final Range range;
    @Nullable
    private final Sound sound;
    @Nullable
    private final String message;
    @Nullable
    private final Function<FPlayer, TagResolver[]> tagResolvers;
    @Nullable
    private final ProxyDataConsumer<SafeDataOutputStream> proxy;
    @Nullable
    private final UnaryOperator<String> integration;

    @Nullable
    public TagResolver[] getTagResolvers(FPlayer fPlayer) {
        return this.tagResolvers == null ? null : this.tagResolvers.apply(fPlayer);
    }

    @NonNull
    public String resolveFormat(FPlayer fPlayer, L localization) {
        return StringUtils.defaultString((String)this.format.apply(fPlayer, localization));
    }

    @Generated
    private static <L extends Localization.Localizable> UUID $default$uuid() {
        return UUID.randomUUID();
    }

    @Generated
    private static <L extends Localization.Localizable> Predicate<FPlayer> $default$filter() {
        return fPlayer -> true;
    }

    @Generated
    private static <L extends Localization.Localizable> boolean $default$senderColorOut() {
        return true;
    }

    @Generated
    private static <L extends Localization.Localizable> Destination $default$destination() {
        return new Destination();
    }

    @Generated
    protected EventMetadata(EventMetadataBuilder<L, ?, ?> b) {
        this.uuid = b.uuid$set ? b.uuid$value : EventMetadata.$default$uuid();
        this.sender = b.sender;
        if (this.sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        this.filterPlayer = b.filterPlayer;
        this.filter = b.filter$set ? b.filter$value : EventMetadata.$default$filter();
        this.senderColorOut = b.senderColorOut$set ? b.senderColorOut$value : EventMetadata.$default$senderColorOut();
        this.format = b.format;
        if (this.format == null) {
            throw new NullPointerException("format is marked non-null but is null");
        }
        this.destination = b.destination$set ? b.destination$value : EventMetadata.$default$destination();
        if (this.destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        this.range = b.range;
        if (this.range == null) {
            throw new NullPointerException("range is marked non-null but is null");
        }
        this.sound = b.sound;
        this.message = b.message;
        this.tagResolvers = b.tagResolvers;
        this.proxy = b.proxy;
        this.integration = b.integration;
    }

    @Generated
    public static <L extends Localization.Localizable> EventMetadataBuilder<L, ?, ?> builder() {
        return new EventMetadataBuilderImpl();
    }

    @Generated
    public UUID getUuid() {
        return this.uuid;
    }

    @NonNull
    @Generated
    public FEntity getSender() {
        return this.sender;
    }

    @Nullable
    @Generated
    public FPlayer getFilterPlayer() {
        return this.filterPlayer;
    }

    @Generated
    public Predicate<FPlayer> getFilter() {
        return this.filter;
    }

    @Generated
    public boolean isSenderColorOut() {
        return this.senderColorOut;
    }

    @NonNull
    @Generated
    public BiFunction<FPlayer, L, String> getFormat() {
        return this.format;
    }

    @NonNull
    @Generated
    public Destination getDestination() {
        return this.destination;
    }

    @NonNull
    @Generated
    public Range getRange() {
        return this.range;
    }

    @Nullable
    @Generated
    public Sound getSound() {
        return this.sound;
    }

    @Nullable
    @Generated
    public String getMessage() {
        return this.message;
    }

    @Nullable
    @Generated
    public Function<FPlayer, TagResolver[]> getTagResolvers() {
        return this.tagResolvers;
    }

    @Nullable
    @Generated
    public ProxyDataConsumer<SafeDataOutputStream> getProxy() {
        return this.proxy;
    }

    @Nullable
    @Generated
    public UnaryOperator<String> getIntegration() {
        return this.integration;
    }

    public static abstract class EventMetadataBuilder<L extends Localization.Localizable, C extends EventMetadata<L>, B extends EventMetadataBuilder<L, C, B>> {
        @Generated
        private boolean uuid$set;
        @Generated
        private UUID uuid$value;
        @Generated
        private FEntity sender;
        @Generated
        private FPlayer filterPlayer;
        @Generated
        private boolean filter$set;
        @Generated
        private Predicate<FPlayer> filter$value;
        @Generated
        private boolean senderColorOut$set;
        @Generated
        private boolean senderColorOut$value;
        @Generated
        private BiFunction<FPlayer, L, String> format;
        @Generated
        private boolean destination$set;
        @Generated
        private Destination destination$value;
        @Generated
        private Range range;
        @Generated
        private Sound sound;
        @Generated
        private String message;
        @Generated
        private Function<FPlayer, TagResolver[]> tagResolvers;
        @Generated
        private ProxyDataConsumer<SafeDataOutputStream> proxy;
        @Generated
        private UnaryOperator<String> integration;

        public B proxy(ProxyDataConsumer<SafeDataOutputStream> proxy) {
            this.proxy = proxy;
            return this.self();
        }

        public B proxy() {
            return this.proxy(dataOutputStream -> {});
        }

        public B integration(UnaryOperator<String> integrationFunction) {
            this.integration = integrationFunction;
            return this.self();
        }

        public B integration() {
            return this.integration(string -> string);
        }

        public B sender(FEntity sender) {
            this.sender = sender;
            return this.filterPlayer(sender);
        }

        public B filterPlayer(FEntity entity) {
            FPlayer fPlayer;
            this.range = Range.get(Range.Type.PLAYER);
            this.filterPlayer = entity instanceof FPlayer ? (fPlayer = (FPlayer)entity) : FPlayer.UNKNOWN;
            return this.self();
        }

        public B filterPlayer(FPlayer receiver, boolean senderColorOut) {
            return ((EventMetadataBuilder)this.filterPlayer(receiver)).senderColorOut(senderColorOut);
        }

        public B format(String format) {
            this.format = (fPlayer, l) -> format;
            return this.self();
        }

        public B format(Function<L, String> format) {
            this.format = (fResolver, s) -> (String)format.apply(s);
            return this.self();
        }

        public B format(BiFunction<FPlayer, L, String> format) {
            this.format = format;
            return this.self();
        }

        @Generated
        public B uuid(UUID uuid) {
            this.uuid$value = uuid;
            this.uuid$set = true;
            return this.self();
        }

        @Generated
        public B filter(Predicate<FPlayer> filter) {
            this.filter$value = filter;
            this.filter$set = true;
            return this.self();
        }

        @Generated
        public B senderColorOut(boolean senderColorOut) {
            this.senderColorOut$value = senderColorOut;
            this.senderColorOut$set = true;
            return this.self();
        }

        @Generated
        public B destination(@NonNull Destination destination) {
            if (destination == null) {
                throw new NullPointerException("destination is marked non-null but is null");
            }
            this.destination$value = destination;
            this.destination$set = true;
            return this.self();
        }

        @Generated
        public B range(@NonNull Range range) {
            if (range == null) {
                throw new NullPointerException("range is marked non-null but is null");
            }
            this.range = range;
            return this.self();
        }

        @Generated
        public B sound(@Nullable Sound sound) {
            this.sound = sound;
            return this.self();
        }

        @Generated
        public B message(@Nullable String message) {
            this.message = message;
            return this.self();
        }

        @Generated
        public B tagResolvers(@Nullable Function<FPlayer, TagResolver[]> tagResolvers) {
            this.tagResolvers = tagResolvers;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "EventMetadata.EventMetadataBuilder(uuid$value=" + String.valueOf(this.uuid$value) + ", sender=" + String.valueOf(this.sender) + ", filterPlayer=" + String.valueOf(this.filterPlayer) + ", filter$value=" + String.valueOf(this.filter$value) + ", senderColorOut$value=" + this.senderColorOut$value + ", format=" + String.valueOf(this.format) + ", destination$value=" + String.valueOf(this.destination$value) + ", range=" + String.valueOf(this.range) + ", sound=" + String.valueOf(this.sound) + ", message=" + this.message + ", tagResolvers=" + String.valueOf(this.tagResolvers) + ", proxy=" + String.valueOf(this.proxy) + ", integration=" + String.valueOf(this.integration) + ")";
        }
    }

    @Generated
    private static final class EventMetadataBuilderImpl<L extends Localization.Localizable>
    extends EventMetadataBuilder<L, EventMetadata<L>, EventMetadataBuilderImpl<L>> {
        @Generated
        private EventMetadataBuilderImpl() {
        }

        @Override
        @Generated
        protected EventMetadataBuilderImpl<L> self() {
            return this;
        }

        @Override
        @Generated
        public EventMetadata<L> build() {
            return new EventMetadata(this);
        }
    }
}

