/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.model.util;

import java.util.HashMap;
import java.util.UUID;
import lombok.Generated;
import net.flectone.pulse.model.entity.FPlayer;

public class Cooldown {
    private final HashMap<UUID, Long> playerDuration = new HashMap();
    private final boolean enable;
    private final long duration;
    private String permissionBypass = "";

    public Cooldown(boolean enable, long duration) {
        this.enable = enable;
        this.duration = duration;
    }

    public Cooldown() {
        this(false, 60L);
    }

    public boolean isCooldown(UUID uuid) {
        if (!this.isEnable()) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        Long time = this.playerDuration.get(uuid);
        if (time == null || currentTime >= time) {
            this.playerDuration.put(uuid, currentTime + this.duration * 50L);
            return false;
        }
        return true;
    }

    public long getTimeLeft(FPlayer fPlayer) {
        return this.playerDuration.getOrDefault(fPlayer.getUuid(), 0L) - System.currentTimeMillis();
    }

    @Generated
    public HashMap<UUID, Long> getPlayerDuration() {
        return this.playerDuration;
    }

    @Generated
    public boolean isEnable() {
        return this.enable;
    }

    @Generated
    public long getDuration() {
        return this.duration;
    }

    @Generated
    public String getPermissionBypass() {
        return this.permissionBypass;
    }

    @Generated
    public void setPermissionBypass(String permissionBypass) {
        this.permissionBypass = permissionBypass;
    }
}

