/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import lombok.Generated;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Injector;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.platform.registry.PermissionRegistry;
import net.flectone.pulse.util.checker.PermissionChecker;

public abstract class AbstractModule {
    private final Set<Class<? extends AbstractModule>> children = new LinkedHashSet<Class<? extends AbstractModule>>();
    private final Set<Predicate<FEntity>> predicates = new HashSet<Predicate<FEntity>>();
    @Inject
    private PermissionRegistry permissionRegistry;
    @Inject
    private PermissionChecker permissionChecker;
    @Inject
    private Injector injector;
    private String modulePermission;
    private boolean enable;

    protected AbstractModule() {
        this.addDefaultPredicates();
    }

    public void onEnable() {
    }

    public void onDisable() {
    }

    protected abstract boolean isConfigEnable();

    public void registerModulePermission(Permission.IPermission permission) {
        this.registerPermission(permission);
        this.modulePermission = permission.getName();
    }

    public void registerPermission(Permission.IPermission permission) {
        if (permission == null) {
            return;
        }
        this.registerPermission(permission.getName(), permission.getType());
    }

    public void registerPermission(String name, Permission.Type type) {
        this.permissionRegistry.register(name, type);
    }

    public void addChildren(Class<? extends AbstractModule> clazz) {
        this.children.add(clazz);
    }

    public void addPredicate(Predicate<FEntity> predicate) {
        this.predicates.add(predicate);
    }

    public boolean isModuleDisabledFor(FEntity entity) {
        for (Predicate<FEntity> predicate : this.predicates) {
            if (!predicate.test(entity)) continue;
            return true;
        }
        return false;
    }

    public Map<String, String> collectModuleStatuses() {
        return this.collectModuleStatuses(this.getClass());
    }

    public void reload() {
        this.load(this.getClass());
        this.enable(this.getClass(), AbstractModule::isConfigEnable);
    }

    public void terminate() {
        this.enable(this.getClass(), module -> false);
    }

    private Map<String, String> collectModuleStatuses(Class<? extends AbstractModule> clazz) {
        AbstractModule module = (AbstractModule)this.injector.getInstance(clazz);
        HashMap<String, String> modules = new HashMap<String, String>();
        modules.put(clazz.getSimpleName(), module.isEnable() ? "true" : "false");
        ((AbstractModule)this.injector.getInstance(clazz)).getChildren().forEach(subModule -> modules.putAll(this.collectModuleStatuses((Class<? extends AbstractModule>)subModule)));
        return modules;
    }

    private void load(Class<? extends AbstractModule> clazz) {
        AbstractModule module = (AbstractModule)this.injector.getInstance(clazz);
        module.getPredicates().clear();
        module.addDefaultPredicates();
        module.getChildren().forEach(this::load);
    }

    private void enable(Class<? extends AbstractModule> clazz, Predicate<AbstractModule> enablePredicate) {
        AbstractModule module = (AbstractModule)this.injector.getInstance(clazz);
        if (module.isEnable()) {
            module.onDisable();
        }
        boolean isEnabled = enablePredicate.test(module);
        module.setEnable(isEnabled);
        if (isEnabled) {
            module.onEnable();
        }
        Predicate<AbstractModule> childPredicate = isEnabled ? AbstractModule::isConfigEnable : abstractModule -> false;
        module.getChildren().forEach(subModule -> this.enable((Class<? extends AbstractModule>)subModule, childPredicate));
    }

    private void addDefaultPredicates() {
        this.addPredicate(fPlayer -> !this.isEnable());
        this.addPredicate(fPlayer -> !this.permissionChecker.check((FEntity)fPlayer, this.modulePermission));
    }

    @Generated
    public Set<Class<? extends AbstractModule>> getChildren() {
        return this.children;
    }

    @Generated
    public Set<Predicate<FEntity>> getPredicates() {
        return this.predicates;
    }

    @Generated
    public PermissionRegistry getPermissionRegistry() {
        return this.permissionRegistry;
    }

    @Generated
    public PermissionChecker getPermissionChecker() {
        return this.permissionChecker;
    }

    @Generated
    public Injector getInjector() {
        return this.injector;
    }

    @Generated
    public String getModulePermission() {
        return this.modulePermission;
    }

    @Generated
    public boolean isEnable() {
        return this.enable;
    }

    @Generated
    public void setEnable(boolean enable) {
        this.enable = enable;
    }
}

