/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.util.Range;
import net.flectone.pulse.module.AbstractModuleLocalization;
import net.flectone.pulse.platform.registry.CommandRegistry;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.constant.DisableSource;
import net.flectone.pulse.util.constant.MessageType;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.incendo.cloud.Command;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.execution.CommandExecutionHandler;
import org.incendo.cloud.meta.CommandMeta;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractModuleCommand<M extends Localization.Localizable>
extends AbstractModuleLocalization<M>
implements CommandExecutionHandler<FPlayer> {
    private final List<String> prompts = new ArrayList<String>();
    private final Predicate<FPlayer> commandPredicate;
    private final Function<Command, Command.ICommandFile> commandFunction;
    @Inject
    private FileResolver fileResolver;
    @Inject
    private CommandRegistry commandParserProvider;

    protected AbstractModuleCommand(Function<Localization, M> messageFunction, Function<Command, Command.ICommandFile> commandFunction, MessageType messageType) {
        this(messageFunction, commandFunction, null, messageType);
    }

    protected AbstractModuleCommand(Function<Localization, M> messageFunction, Function<Command, Command.ICommandFile> commandFunction, Predicate<FPlayer> commandPredicate, MessageType messageType) {
        super(messageFunction, messageType);
        this.commandFunction = commandFunction;
        this.commandPredicate = commandPredicate;
    }

    protected void registerCommand(UnaryOperator<Command.Builder<FPlayer>> commandBuilderOperator) {
        List<String> aliases = this.resolveCommand().getAliases();
        String commandName = this.getCommandName();
        this.commandParserProvider.registerCommand((CommandManager<FPlayer> manager) -> ((Command.Builder)commandBuilderOperator.apply(manager.commandBuilder(commandName, (Collection)aliases, CommandMeta.empty()))).handler((CommandExecutionHandler)this));
    }

    protected void registerCustomCommand(Function<CommandManager<FPlayer>, Command.Builder<FPlayer>> builder) {
        this.commandParserProvider.registerCommand(builder);
    }

    protected void clearPrompts() {
        if (this.fileResolver.getConfig().isUnregisterOwnCommands()) {
            this.prompts.clear();
        }
    }

    protected String addPrompt(int index, Function<Localization.Command.Prompt, String> promptLocalization) {
        if (this.prompts.size() != index) {
            return "unknown";
        }
        String prompt = promptLocalization.apply(this.fileResolver.getLocalization().getCommand().getPrompt());
        this.prompts.add(prompt);
        return prompt;
    }

    protected String getPrompt(int index) {
        if (this.prompts.size() - 1 < index) {
            throw new IllegalArgumentException("Argument at index " + index + " is not registered in the " + this.getCommandName() + " command");
        }
        return this.prompts.get(index);
    }

    protected <V> V getArgument(CommandContext<FPlayer> commandContext, int promptIndex) {
        String prompt = this.getPrompt(promptIndex);
        return (V)commandContext.get(prompt);
    }

    public String getCommandName() {
        List<String> aliases = this.resolveCommand().getAliases();
        if (aliases.isEmpty()) {
            return "flectonepulsenull";
        }
        return aliases.getFirst();
    }

    @Override
    protected boolean isConfigEnable() {
        return this.resolveCommand().isEnable();
    }

    @Override
    public void onDisable() {
        this.clearPrompts();
    }

    public void execute(@NonNull CommandContext<FPlayer> commandContext) {
        this.execute((FPlayer)commandContext.sender(), commandContext);
    }

    public abstract void execute(FPlayer var1, CommandContext<FPlayer> var2);

    public boolean checkDisable(FEntity entity, @NotNull FEntity receiver, DisableSource action) {
        if (!(receiver instanceof FPlayer)) {
            return false;
        }
        FPlayer fReceiver = (FPlayer)receiver;
        if (this.commandPredicate == null || this.commandPredicate.test(fReceiver)) {
            return false;
        }
        this.sendDisableMessage(entity, fReceiver, action);
        return true;
    }

    @Override
    public Predicate<FPlayer> rangeFilter(FPlayer filterPlayer, Range range) {
        Predicate<FPlayer> filter = super.rangeFilter(filterPlayer, range);
        if (range.is(Range.Type.PLAYER)) {
            return filter;
        }
        return this.commandPredicate == null ? filter : filter.and(this.commandPredicate);
    }

    private Command.ICommandFile resolveCommand() {
        return this.commandFunction.apply(this.fileResolver.getCommand());
    }
}

