/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import lombok.Generated;
import net.flectone.pulse.annotation.Async;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.execution.dispatcher.EventDispatcher;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.model.event.message.MessageSendEvent;
import net.flectone.pulse.model.event.message.PreMessageSendEvent;
import net.flectone.pulse.model.util.Cooldown;
import net.flectone.pulse.model.util.Destination;
import net.flectone.pulse.model.util.Range;
import net.flectone.pulse.model.util.Sound;
import net.flectone.pulse.module.AbstractModule;
import net.flectone.pulse.platform.adapter.PlatformPlayerAdapter;
import net.flectone.pulse.platform.formatter.ModerationMessageFormatter;
import net.flectone.pulse.platform.formatter.TimeFormatter;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.checker.MuteChecker;
import net.flectone.pulse.util.checker.PermissionChecker;
import net.flectone.pulse.util.constant.DisableSource;
import net.flectone.pulse.util.constant.MessageFlag;
import net.flectone.pulse.util.constant.MessageType;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractModuleLocalization<M extends Localization.Localizable>
extends AbstractModule {
    private final Function<Localization, M> localizationFunction;
    private final MessageType messageType;
    @Inject
    private FPlayerService fPlayerService;
    @Inject
    private PlatformPlayerAdapter platformPlayerAdapter;
    @Inject
    private PermissionChecker permissionChecker;
    @Inject
    private MuteChecker muteChecker;
    @Inject
    private FileResolver fileResolver;
    @Inject
    private MessagePipeline messagePipeline;
    @Inject
    private ModerationMessageFormatter moderationMessageFormatter;
    @Inject
    private TimeFormatter timeFormatter;
    @Inject
    private EventDispatcher eventDispatcher;
    private Cooldown moduleCooldown;
    private Sound moduleSound;

    protected AbstractModuleLocalization(Function<Localization, M> localizationMFunction, MessageType messageType) {
        this.localizationFunction = localizationMFunction;
        this.messageType = messageType;
    }

    public Sound createSound(Sound sound, Permission.IPermission permission) {
        this.moduleSound = sound;
        if (permission != null) {
            this.registerPermission(permission);
            sound.setPermission(permission.getName());
        }
        return sound;
    }

    public Cooldown createCooldown(Cooldown cooldown, Permission.IPermission permission) {
        this.moduleCooldown = cooldown;
        if (permission != null) {
            this.registerPermission(permission);
            cooldown.setPermissionBypass(permission.getName());
        }
        return this.moduleCooldown;
    }

    public String getCooldownMessage(FEntity sender) {
        return this.fileResolver.getLocalization(sender).getCooldown();
    }

    public M resolveLocalization() {
        return (M)((Localization.Localizable)this.localizationFunction.apply(this.fileResolver.getLocalization()));
    }

    public M resolveLocalization(FEntity sender) {
        return (M)((Localization.Localizable)this.localizationFunction.apply(this.fileResolver.getLocalization(sender)));
    }

    public boolean checkCooldown(FEntity entity) {
        if (this.getModuleCooldown() == null) {
            return false;
        }
        if (!this.getModuleCooldown().isEnable()) {
            return false;
        }
        if (!(entity instanceof FPlayer)) {
            return false;
        }
        FPlayer fPlayer = (FPlayer)entity;
        if (this.permissionChecker.check((FEntity)fPlayer, this.getModuleCooldown().getPermissionBypass())) {
            return false;
        }
        if (!this.getModuleCooldown().isCooldown(fPlayer.getUuid())) {
            return false;
        }
        long timeLeft = this.getModuleCooldown().getTimeLeft(fPlayer);
        this.sendMessage((EventMetadata<M>)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(this.timeFormatter.format(fPlayer, timeLeft, this.getCooldownMessage(fPlayer)))).build());
        return true;
    }

    public boolean checkMute(@NotNull FEntity entity) {
        if (!(entity instanceof FPlayer)) {
            return false;
        }
        FPlayer fPlayer = (FPlayer)entity;
        MuteChecker.Status status = this.muteChecker.check(fPlayer);
        if (status == MuteChecker.Status.NONE) {
            return false;
        }
        this.sendMessage((EventMetadata<M>)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(this.moderationMessageFormatter.buildMuteMessage(fPlayer, status))).build());
        return true;
    }

    public void sendDisableMessage(FEntity fPlayer, @NotNull FEntity fReceiver, DisableSource action) {
        Localization.Command.Chatsetting.Disable localization = this.fileResolver.getLocalization(fReceiver).getCommand().getChatsetting().getDisable();
        String format = switch (action) {
            default -> throw new MatchException(null, null);
            case DisableSource.HE -> localization.getHe();
            case DisableSource.YOU -> localization.getYou();
            case DisableSource.SERVER -> localization.getServer();
        };
        this.sendMessage((EventMetadata<M>)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(format)).build());
    }

    public boolean checkIgnore(FPlayer fSender, FPlayer fReceiver) {
        Localization.Command.Ignore localization = this.fileResolver.getLocalization(fSender).getCommand().getIgnore();
        if (fSender.isIgnored(fReceiver)) {
            this.sendMessage((EventMetadata<M>)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fSender)).format(localization.getYou())).build());
            return true;
        }
        if (fReceiver.isIgnored(fSender)) {
            this.sendMessage((EventMetadata<M>)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fSender)).format(localization.getHe())).build());
            return true;
        }
        return false;
    }

    public Predicate<FPlayer> rangeFilter(FPlayer filterPlayer, Range range) {
        FPlayer fPlayer;
        if (range.is(Range.Type.PLAYER)) {
            return filterPlayer::equals;
        }
        if (!(filterPlayer instanceof FPlayer) || (fPlayer = filterPlayer).isUnknown()) {
            return player -> true;
        }
        return this.createRangePredicate(fPlayer, range);
    }

    private Predicate<FPlayer> createRangePredicate(FPlayer fPlayer, Range range) {
        return fReceiver -> {
            if (fReceiver.isUnknown()) {
                return true;
            }
            if (fReceiver.isIgnored(fPlayer)) {
                return false;
            }
            return switch (range.getType()) {
                case Range.Type.BLOCKS -> this.checkDistance(fPlayer, (FPlayer)fReceiver, range.getValue());
                case Range.Type.WORLD_NAME -> this.checkWorldNamePermission(fPlayer, (FPlayer)fReceiver);
                case Range.Type.WORLD_TYPE -> this.checkWorldTypePermission(fPlayer, (FPlayer)fReceiver);
                default -> true;
            };
        };
    }

    private boolean checkDistance(FPlayer fPlayer, FPlayer fReceiver, int range) {
        double distance = this.platformPlayerAdapter.distance(fPlayer, fReceiver);
        return distance != -1.0 && distance <= (double)range;
    }

    private boolean checkWorldNamePermission(FPlayer fPlayer, FPlayer fReceiver) {
        String worldName = this.platformPlayerAdapter.getWorldName(fPlayer);
        if (worldName.isEmpty()) {
            return true;
        }
        return this.permissionChecker.check((FEntity)fReceiver, "flectonepulse.world.name." + worldName);
    }

    private boolean checkWorldTypePermission(FPlayer fPlayer, FPlayer fReceiver) {
        String worldType = this.platformPlayerAdapter.getWorldEnvironment(fPlayer);
        if (worldType.isEmpty()) {
            return true;
        }
        return this.permissionChecker.check((FEntity)fReceiver, "flectonepulse.world.type." + worldType);
    }

    public EventMetadata.EventMetadataBuilder<M, ?, ?> metadataBuilder() {
        return EventMetadata.builder();
    }

    public List<FPlayer> createReceivers(EventMetadata<M> eventMetadata) {
        String rawFormat = eventMetadata.resolveFormat(FPlayer.UNKNOWN, this.resolveLocalization());
        PreMessageSendEvent preMessageSendEvent = new PreMessageSendEvent(this.messageType, rawFormat, eventMetadata);
        this.eventDispatcher.dispatch(preMessageSendEvent);
        if (preMessageSendEvent.isCancelled()) {
            return Collections.emptyList();
        }
        FPlayer filterPlayer = eventMetadata.getFilterPlayer();
        return this.fPlayerService.getFPlayersWithConsole().stream().filter(eventMetadata.getFilter()).filter(this.rangeFilter(filterPlayer, eventMetadata.getRange())).toList();
    }

    public void sendMessage(EventMetadata<M> eventMetadata) {
        this.sendMessage(this.messageType, eventMetadata);
    }

    public void sendMessage(MessageType messageType, EventMetadata<M> eventMetadata) {
        List<FPlayer> receivers = this.createReceivers(eventMetadata);
        this.sendMessage(messageType, receivers, eventMetadata);
    }

    public void sendMessage(List<FPlayer> receivers, EventMetadata<M> eventMetadata) {
        this.sendMessage(this.messageType, receivers, eventMetadata);
    }

    @Async
    public void sendMessage(MessageType messageType, List<FPlayer> receivers, EventMetadata<M> eventMetadata) {
        if (receivers.isEmpty()) {
            return;
        }
        receivers.forEach(receiver -> {
            Component messageComponent = this.buildMessageComponent((FPlayer)receiver, eventMetadata);
            Component formatComponent = this.buildFormatComponent((FPlayer)receiver, eventMetadata, messageComponent);
            Component subComponent = Component.empty();
            Destination destination = eventMetadata.getDestination();
            if (destination.getType() == Destination.Type.TITLE || destination.getType() == Destination.Type.SUBTITLE) {
                subComponent = this.buildSubcomponent((FPlayer)receiver, eventMetadata, messageComponent);
            }
            this.eventDispatcher.dispatch(new MessageSendEvent(messageType, (FPlayer)receiver, formatComponent, subComponent, eventMetadata));
        });
    }

    private Component buildSubcomponent(FPlayer receiver, EventMetadata<M> eventMetadata, Component message) {
        Destination destination = eventMetadata.getDestination();
        return destination.getSubtext().isEmpty() ? Component.empty() : this.messagePipeline.builder(eventMetadata.getSender(), receiver, destination.getSubtext()).flag(MessageFlag.SENDER_COLOR_OUT, eventMetadata.isSenderColorOut()).tagResolvers(this.messageTag(message)).build();
    }

    private Component buildMessageComponent(FPlayer receiver, EventMetadata<M> eventMetadata) {
        String message = eventMetadata.getMessage();
        if (StringUtils.isEmpty((CharSequence)message)) {
            return Component.empty();
        }
        FEntity sender = eventMetadata.getSender();
        boolean senderColorOut = eventMetadata.isSenderColorOut();
        MessagePipeline.Builder messageBuilder = this.messagePipeline.builder(sender, receiver, message).flag(MessageFlag.USER_MESSAGE, true).flag(MessageFlag.SENDER_COLOR_OUT, senderColorOut).flag(MessageFlag.MENTION, !receiver.isUnknown());
        return messageBuilder.build();
    }

    private Component buildFormatComponent(FPlayer receiver, EventMetadata<M> eventMetadata, Component message) {
        String formatContent = eventMetadata.resolveFormat(receiver, this.resolveLocalization(receiver));
        if (StringUtils.isEmpty((CharSequence)formatContent)) {
            return Component.empty();
        }
        FEntity sender = eventMetadata.getSender();
        boolean senderColorOut = eventMetadata.isSenderColorOut();
        MessagePipeline.Builder formatBuilder = this.messagePipeline.builder(eventMetadata.getUuid(), sender, receiver, formatContent).flag(MessageFlag.SENDER_COLOR_OUT, senderColorOut).tagResolvers(eventMetadata.getTagResolvers(receiver)).tagResolvers(this.messageTag(message));
        if (!receiver.isUnknown()) {
            formatBuilder = formatBuilder.setUserMessage(eventMetadata.getMessage()).translate(formatContent.contains("<translate"));
        }
        return formatBuilder.build();
    }

    public TagResolver messageTag(Component message) {
        return TagResolver.resolver((String)"message", (argumentQueue, context) -> Tag.inserting((Component)message));
    }

    @Generated
    public Cooldown getModuleCooldown() {
        return this.moduleCooldown;
    }

    @Generated
    public Sound getModuleSound() {
        return this.moduleSound;
    }
}

