/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module;

import net.flectone.pulse.config.Config;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.module.AbstractModule;
import net.flectone.pulse.module.command.CommandModule;
import net.flectone.pulse.module.integration.IntegrationModule;
import net.flectone.pulse.module.message.MessageModule;
import net.flectone.pulse.processing.resolver.FileResolver;

@Singleton
public class Module
extends AbstractModule {
    private final Config.Module config;
    private final Permission permission;

    @Inject
    public Module(FileResolver fileResolver) {
        this.config = fileResolver.getConfig().getModule();
        this.permission = fileResolver.getPermission();
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission.getModule());
        this.addChildren(IntegrationModule.class);
        this.addChildren(CommandModule.class);
        this.addChildren(MessageModule.class);
    }

    @Override
    protected boolean isConfigEnable() {
        return this.config.isEnable();
    }
}

