/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.ball;

import java.util.List;
import java.util.function.Function;
import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.module.AbstractModuleCommand;
import net.flectone.pulse.module.command.ball.model.BallMetadata;
import net.flectone.pulse.platform.provider.CommandParserProvider;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.RandomUtil;
import net.flectone.pulse.util.constant.DisableSource;
import net.flectone.pulse.util.constant.MessageType;
import org.incendo.cloud.context.CommandContext;

@Singleton
public class BallModule
extends AbstractModuleCommand<Localization.Command.Ball> {
    private final Command.Ball command;
    private final Permission.Command.Ball permission;
    private final RandomUtil randomUtil;
    private final CommandParserProvider commandParserProvider;

    @Inject
    public BallModule(FileResolver fileResolver, RandomUtil randomUtil, CommandParserProvider commandParserProvider) {
        super(localization -> localization.getCommand().getBall(), Command::getBall, fPlayer -> fPlayer.isSetting(FPlayer.Setting.BALL), MessageType.COMMAND_BALL);
        this.command = fileResolver.getCommand().getBall();
        this.permission = fileResolver.getPermission().getCommand().getBall();
        this.randomUtil = randomUtil;
        this.commandParserProvider = commandParserProvider;
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
        this.createCooldown(this.command.getCooldown(), this.permission.getCooldownBypass());
        this.createSound(this.command.getSound(), this.permission.getSound());
        String promptMessage = this.addPrompt(0, Localization.Command.Prompt::getMessage);
        this.registerCommand(commandBuilder -> commandBuilder.permission(this.permission.getName()).required(promptMessage, this.commandParserProvider.nativeMessageParser()));
        this.addPredicate(this::checkCooldown);
        this.addPredicate(fPlayer -> this.checkDisable((FEntity)fPlayer, (FEntity)fPlayer, DisableSource.YOU));
        this.addPredicate(this::checkMute);
    }

    @Override
    public void execute(FPlayer fPlayer, CommandContext<FPlayer> commandContext) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        int answer = this.randomUtil.nextInt(0, ((Localization.Command.Ball)this.resolveLocalization()).getAnswers().size());
        String message = (String)this.getArgument(commandContext, 0);
        this.sendMessage(((BallMetadata.BallMetadataBuilder)((BallMetadata.BallMetadataBuilder)((BallMetadata.BallMetadataBuilder)((BallMetadata.BallMetadataBuilder)((BallMetadata.BallMetadataBuilder)((BallMetadata.BallMetadataBuilder)((EventMetadata.EventMetadataBuilder)((BallMetadata.BallMetadataBuilder)((BallMetadata.BallMetadataBuilder)BallMetadata.builder().sender(fPlayer)).format(this.replaceAnswer(answer))).answer(answer)).message(message)).destination(this.command.getDestination())).range(this.command.getRange())).sound(this.getModuleSound())).proxy(dataOutputStream -> {
            dataOutputStream.writeInt(answer);
            dataOutputStream.writeString(message);
        })).integration(string -> {
            List<String> answers = ((Localization.Command.Ball)this.resolveLocalization()).getAnswers();
            String answerString = !answers.isEmpty() ? answers.get(Math.min(answer, answers.size() - 1)) : "";
            return Strings.CS.replace(string, "<answer>", answerString);
        })).build());
    }

    public Function<Localization.Command.Ball, String> replaceAnswer(int answer) {
        return message -> {
            List<String> answers = message.getAnswers();
            String answerString = !answers.isEmpty() ? answers.get(Math.min(answer, answers.size() - 1)) : "";
            return Strings.CS.replace(message.getFormat(), "<answer>", answerString);
        };
    }
}

