/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.broadcast;

import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.module.AbstractModuleCommand;
import net.flectone.pulse.platform.provider.CommandParserProvider;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.constant.DisableSource;
import net.flectone.pulse.util.constant.MessageType;
import org.incendo.cloud.context.CommandContext;

@Singleton
public class BroadcastModule
extends AbstractModuleCommand<Localization.Command.Broadcast> {
    private final Command.Broadcast command;
    private final Permission.Command.Broadcast permission;
    private final CommandParserProvider commandParserProvider;

    @Inject
    public BroadcastModule(FileResolver fileResolver, CommandParserProvider commandParserProvider) {
        super(localization -> localization.getCommand().getBroadcast(), Command::getBroadcast, fPlayer -> fPlayer.isSetting(FPlayer.Setting.BROADCAST), MessageType.COMMAND_BROADCAST);
        this.command = fileResolver.getCommand().getBroadcast();
        this.permission = fileResolver.getPermission().getCommand().getBroadcast();
        this.commandParserProvider = commandParserProvider;
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
        this.createCooldown(this.command.getCooldown(), this.permission.getCooldownBypass());
        this.createSound(this.command.getSound(), this.permission.getSound());
        String promptMessage = this.addPrompt(0, Localization.Command.Prompt::getMessage);
        this.registerCommand(manager -> manager.permission(this.permission.getName()).required(promptMessage, this.commandParserProvider.nativeMessageParser()));
        this.addPredicate(this::checkCooldown);
        this.addPredicate(fPlayer -> this.checkDisable((FEntity)fPlayer, (FEntity)fPlayer, DisableSource.YOU));
        this.addPredicate(this::checkMute);
    }

    @Override
    public void execute(FPlayer fPlayer, CommandContext<FPlayer> commandContext) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        String message = (String)this.getArgument(commandContext, 0);
        this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Broadcast::getFormat)).message(message)).range(this.command.getRange())).destination(this.command.getDestination())).sound(this.getModuleSound())).proxy(dataOutputStream -> dataOutputStream.writeString(message))).integration()).build());
    }
}

