/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.chatsetting;

import com.github.retrooper.packetevents.manager.server.ServerVersion;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import lombok.NonNull;
import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Provider;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.AbstractModuleCommand;
import net.flectone.pulse.module.command.chatsetting.builder.DialogMenuBuilder;
import net.flectone.pulse.module.command.chatsetting.builder.InventoryMenuBuilder;
import net.flectone.pulse.module.command.chatsetting.builder.MenuBuilder;
import net.flectone.pulse.platform.provider.CommandParserProvider;
import net.flectone.pulse.platform.provider.PacketProvider;
import net.flectone.pulse.platform.registry.ProxyRegistry;
import net.flectone.pulse.platform.sender.ProxySender;
import net.flectone.pulse.platform.sender.SoundPlayer;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.checker.PermissionChecker;
import net.flectone.pulse.util.constant.MessageType;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.suggestion.BlockingSuggestionProvider;
import org.incendo.cloud.suggestion.Suggestion;

@Singleton
public class ChatsettingModule
extends AbstractModuleCommand<Localization.Command.Chatsetting> {
    private final Command.Chatsetting command;
    private final Permission.Command.Chatsetting permission;
    private final FPlayerService fPlayerService;
    private final PermissionChecker permissionChecker;
    private final CommandParserProvider commandParserProvider;
    private final ProxySender proxySender;
    private final ProxyRegistry proxyRegistry;
    private final Provider<DialogMenuBuilder> dialogMenuBuilderProvider;
    private final Provider<InventoryMenuBuilder> inventoryMenuBuilderProvider;
    private final SoundPlayer soundPlayer;
    private final boolean isNewerThanOrEqualsV_1_21_6;

    @Inject
    public ChatsettingModule(FileResolver fileResolver, FPlayerService fPlayerService, PermissionChecker permissionChecker, CommandParserProvider commandParserProvider, ProxySender proxySender, ProxyRegistry proxyRegistry, Provider<DialogMenuBuilder> dialogMenuBuilderProvider, Provider<InventoryMenuBuilder> inventoryMenuBuilderProvider, SoundPlayer soundPlayer, PacketProvider packetProvider) {
        super(localization -> localization.getCommand().getChatsetting(), Command::getChatsetting, MessageType.COMMAND_CHATSETTING);
        this.command = fileResolver.getCommand().getChatsetting();
        this.permission = fileResolver.getPermission().getCommand().getChatsetting();
        this.fPlayerService = fPlayerService;
        this.permissionChecker = permissionChecker;
        this.commandParserProvider = commandParserProvider;
        this.proxySender = proxySender;
        this.proxyRegistry = proxyRegistry;
        this.dialogMenuBuilderProvider = dialogMenuBuilderProvider;
        this.inventoryMenuBuilderProvider = inventoryMenuBuilderProvider;
        this.soundPlayer = soundPlayer;
        this.isNewerThanOrEqualsV_1_21_6 = packetProvider.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_6);
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
        this.createCooldown(this.command.getCooldown(), this.permission.getCooldownBypass());
        this.createSound(this.command.getSound(), this.permission.getSound());
        this.permission.getSettings().values().forEach(this::registerPermission);
        this.permission.getFcolors().values().forEach(this::registerPermission);
        String promptPlayer = this.addPrompt(0, Localization.Command.Prompt::getPlayer);
        String promptType = this.addPrompt(1, Localization.Command.Prompt::getType);
        String promptValue = this.addPrompt(2, Localization.Command.Prompt::getValue);
        this.registerCommand(commandBuilder -> commandBuilder.permission(this.permission.getName()).optional(promptPlayer, this.commandParserProvider.offlinePlayerParser(), this.commandParserProvider.playerSuggestionPermission(true, this.permission.getOther())).optional(promptType, this.commandParserProvider.singleMessageParser(), this.typeSuggestion()).optional(promptValue, this.commandParserProvider.messageParser()));
        this.addPredicate(this::checkCooldown);
    }

    @NonNull
    private BlockingSuggestionProvider<FPlayer> typeSuggestion() {
        return (context, input) -> {
            if (!this.permissionChecker.check((FEntity)context.sender(), this.permission.getOther())) {
                return Collections.emptyList();
            }
            return Arrays.stream(FPlayer.Setting.values()).map(setting -> Suggestion.suggestion((String)setting.name())).toList();
        };
    }

    @Override
    public void execute(FPlayer fPlayer, CommandContext<FPlayer> commandContext) {
        String promptPlayer;
        Optional optionalPlayer;
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        if (this.permissionChecker.check((FEntity)fPlayer, this.permission.getOther()) && (optionalPlayer = commandContext.optional(promptPlayer = this.getPrompt(0))).isPresent()) {
            this.executeOther(fPlayer, (String)optionalPlayer.get(), commandContext);
            return;
        }
        this.open(fPlayer, fPlayer);
        this.soundPlayer.play(this.getModuleSound(), fPlayer);
    }

    private void executeOther(FPlayer fPlayer, String target, CommandContext<FPlayer> commandContext) {
        FPlayer fTarget = this.fPlayerService.getFPlayer(target);
        if (fTarget.isUnknown()) {
            return;
        }
        this.fPlayerService.loadSettings(fTarget);
        String promptType = this.getPrompt(1);
        Optional optionalType = commandContext.optional(promptType);
        if (optionalType.isEmpty()) {
            this.open(fPlayer, fTarget);
            return;
        }
        FPlayer.Setting setting = FPlayer.Setting.fromString((String)optionalType.get());
        if (setting == null) {
            return;
        }
        String promptValue = this.getPrompt(2);
        Optional optionalValue = commandContext.optional(promptValue);
        if (fTarget.isSetting(setting) && optionalValue.isEmpty()) {
            fTarget.removeSetting(setting);
        } else {
            fTarget.setSetting(setting, optionalValue.orElse(""));
        }
        this.updateSettings(fTarget);
    }

    private void open(FPlayer fPlayer, FPlayer fTarget) {
        MenuBuilder menuBuilder = this.command.getModern().isEnable() && this.isNewerThanOrEqualsV_1_21_6 ? (MenuBuilder)this.dialogMenuBuilderProvider.get() : (MenuBuilder)this.inventoryMenuBuilderProvider.get();
        menuBuilder.open(fPlayer, fTarget);
    }

    public void updateSettings(FPlayer fPlayer) {
        this.fPlayerService.saveSettings(fPlayer);
        if (this.proxyRegistry.hasEnabledProxy()) {
            this.proxySender.send(fPlayer, MessageType.COMMAND_CHATSETTING);
        }
    }

    public String getPlayerChat(FPlayer fTarget) {
        String currentChat = fTarget.getSettingValue(FPlayer.Setting.CHAT);
        if (StringUtils.isEmpty((CharSequence)currentChat)) {
            return "default";
        }
        return currentChat;
    }

    public String getCheckboxMaterial(boolean enabled) {
        Command.Chatsetting.Checkbox checkbox = this.command.getCheckbox();
        return enabled ? checkbox.getEnabledMaterial() : checkbox.getDisabledMaterial();
    }

    public String getCheckboxTitle(FPlayer fPlayer, FPlayer.Setting setting, boolean enabled) {
        Localization.Command.Chatsetting.Checkbox localizationCheckbox = ((Localization.Command.Chatsetting)this.resolveLocalization(fPlayer)).getCheckbox();
        String statusColor = enabled ? localizationCheckbox.getEnabledColor() : localizationCheckbox.getDisabledColor();
        return Strings.CS.replace(localizationCheckbox.getTypes().getOrDefault((Object)setting, ""), "<status_color>", statusColor);
    }

    public String getCheckboxLore(FPlayer fPlayer, boolean enabled) {
        Localization.Command.Chatsetting.Checkbox localizationCheckbox = ((Localization.Command.Chatsetting)this.resolveLocalization(fPlayer)).getCheckbox();
        String statusColor = enabled ? localizationCheckbox.getEnabledColor() : localizationCheckbox.getDisabledColor();
        return Strings.CS.replace(enabled ? localizationCheckbox.getEnabledHover() : localizationCheckbox.getDisabledHover(), "<status_color>", statusColor);
    }
}

