/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.chatsetting.builder;

import com.github.retrooper.packetevents.protocol.dialog.CommonDialogData;
import com.github.retrooper.packetevents.protocol.dialog.DialogAction;
import com.github.retrooper.packetevents.protocol.dialog.action.Action;
import com.github.retrooper.packetevents.protocol.dialog.action.DynamicCustomAction;
import com.github.retrooper.packetevents.protocol.dialog.body.PlainMessage;
import com.github.retrooper.packetevents.protocol.dialog.body.PlainMessageDialogBody;
import com.github.retrooper.packetevents.protocol.dialog.button.ActionButton;
import com.github.retrooper.packetevents.protocol.dialog.button.CommonButtonData;
import com.github.retrooper.packetevents.resources.ResourceLocation;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.FColor;
import net.flectone.pulse.model.dialog.Dialog;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.command.chatsetting.ChatsettingModule;
import net.flectone.pulse.module.command.chatsetting.builder.MenuBuilder;
import net.flectone.pulse.module.command.chatsetting.handler.ChatsettingHandler;
import net.flectone.pulse.module.command.chatsetting.model.SubMenuItem;
import net.flectone.pulse.platform.controller.DialogController;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.kyori.adventure.text.Component;

@Singleton
public class DialogMenuBuilder
implements MenuBuilder {
    private final Command.Chatsetting command;
    private final ChatsettingModule chatsettingModule;
    private final MessagePipeline messagePipeline;
    private final DialogController dialogController;
    private final ChatsettingHandler chatsettingHandler;

    @Inject
    public DialogMenuBuilder(FileResolver fileResolver, ChatsettingModule chatsettingModule, MessagePipeline messagePipeline, DialogController dialogController, ChatsettingHandler chatsettingHandler) {
        this.command = fileResolver.getCommand().getChatsetting();
        this.chatsettingModule = chatsettingModule;
        this.messagePipeline = messagePipeline;
        this.dialogController = dialogController;
        this.chatsettingHandler = chatsettingHandler;
    }

    @Override
    public void open(FPlayer fPlayer, FPlayer fTarget) {
        Localization.Command.Chatsetting localization = (Localization.Command.Chatsetting)this.chatsettingModule.resolveLocalization(fPlayer);
        Component header = this.messagePipeline.builder(fPlayer, fTarget, localization.getInventory().trim()).build();
        PlainMessageDialogBody dialogBody = new PlainMessageDialogBody(new PlainMessage((Component)Component.empty(), 10));
        CommonDialogData commonDialogData = new CommonDialogData(header, null, true, false, DialogAction.CLOSE, List.of(dialogBody), List.of());
        Dialog.Builder dialogBuilder = new Dialog.Builder(commonDialogData, this.command.getModern().getColumns()).addCloseConsumer(dialog -> this.chatsettingModule.updateSettings(fTarget));
        for (FPlayer.Setting setting : FPlayer.Setting.values()) {
            dialogBuilder = setting == FPlayer.Setting.CHAT ? this.createDialogChatMenu(fPlayer, fTarget, dialogBuilder, localization) : this.createDialogCheckbox(fPlayer, fTarget, setting, dialogBuilder);
        }
        dialogBuilder = this.createDialogFColorMenu(fPlayer, fTarget, FColor.Type.SEE, dialogBuilder, this.command.getMenu().getSee(), localization.getMenu().getSee());
        dialogBuilder = this.createDialogFColorMenu(fPlayer, fTarget, FColor.Type.OUT, dialogBuilder, this.command.getMenu().getOut(), localization.getMenu().getOut());
        this.dialogController.open(fPlayer, dialogBuilder.build(), false);
    }

    private Dialog.Builder createDialogCheckbox(FPlayer fPlayer, FPlayer fTarget, FPlayer.Setting setting, Dialog.Builder dialogBuilder) {
        Command.Chatsetting.Checkbox checkbox = this.command.getCheckbox();
        if (!checkbox.getTypes().containsKey((Object)setting)) {
            return dialogBuilder;
        }
        int slot = checkbox.getTypes().get((Object)setting);
        if (slot == -1) {
            return dialogBuilder;
        }
        boolean enabled = fTarget.isSetting(setting);
        String title = this.chatsettingModule.getCheckboxTitle(fPlayer, setting, enabled);
        Component componentTitle = this.messagePipeline.builder(fPlayer, fTarget, title).build();
        String lore = this.chatsettingModule.getCheckboxLore(fPlayer, enabled);
        Component componentLore = this.messagePipeline.builder(fPlayer, fTarget, lore).build();
        String id = "fp_" + setting.ordinal();
        ActionButton button = new ActionButton(new CommonButtonData(componentTitle, componentLore, this.command.getModern().getButtonWidth()), (Action)new DynamicCustomAction(ResourceLocation.minecraft((String)id), null));
        return dialogBuilder.addButton(slot, button).addClickHandler(id, dialog -> {
            ChatsettingHandler.Status status = this.chatsettingHandler.handleCheckbox(fPlayer, fTarget, setting);
            if (status == ChatsettingHandler.Status.DENIED) {
                return;
            }
            boolean currentEnabled = status.toBoolean();
            String invertTitle = this.chatsettingModule.getCheckboxTitle(fPlayer, setting, !currentEnabled);
            Component componentInvertTitle = this.messagePipeline.builder(fPlayer, fTarget, invertTitle).build();
            String invertLore = this.chatsettingModule.getCheckboxLore(fPlayer, !currentEnabled);
            Component componentInvertLore = this.messagePipeline.builder(fPlayer, fTarget, invertLore).build();
            ActionButton invertButton = new ActionButton(new CommonButtonData(componentInvertTitle, componentInvertLore, this.command.getModern().getButtonWidth()), (Action)new DynamicCustomAction(ResourceLocation.minecraft((String)id), null));
            this.dialogController.changeButton(fPlayer, (Dialog)dialog, id, invertButton);
        });
    }

    private Dialog.Builder createDialogChatMenu(FPlayer fPlayer, FPlayer fTarget, Dialog.Builder dialogBuilder, Localization.Command.Chatsetting localization) {
        Command.Chatsetting.Menu.Chat chat = this.command.getMenu().getChat();
        int slot = chat.getSlot();
        if (slot == -1) {
            return dialogBuilder;
        }
        String currentChat = this.chatsettingModule.getPlayerChat(fTarget);
        String[] messages = Strings.CS.replace(localization.getMenu().getChat().getItem(), "<chat>", currentChat).split("<br>");
        String title = messages.length > 0 ? messages[0] : "";
        String lore = messages.length > 1 ? String.join((CharSequence)"<br>", Arrays.copyOfRange(messages, 1, messages.length)) : "";
        Component componentTitle = this.messagePipeline.builder(fTarget, title).build();
        Component componentLore = this.messagePipeline.builder(fTarget, lore).build();
        String id = "fp_chat";
        ActionButton button = new ActionButton(new CommonButtonData(componentTitle, componentLore, this.command.getModern().getButtonWidth()), (Action)new DynamicCustomAction(ResourceLocation.minecraft((String)id), null));
        return dialogBuilder.addButton(slot, button).addClickHandler(id, dialog -> this.chatsettingHandler.handleChatMenu(fPlayer, fTarget, chat, localization, this, id));
    }

    private Dialog.Builder createDialogFColorMenu(FPlayer fPlayer, FPlayer fTarget, FColor.Type type, Dialog.Builder dialogBuilder, Command.Chatsetting.Menu.Color color, Localization.Command.Chatsetting.Menu.SubMenu subMenu) {
        int slot = color.getSlot();
        if (slot == -1) {
            return dialogBuilder;
        }
        String[] messages = subMenu.getItem().split("<br>");
        String title = messages.length > 0 ? messages[0] : "";
        String lore = messages.length > 1 ? String.join((CharSequence)"<br>", Arrays.copyOfRange(messages, 1, messages.length)) : "";
        Component componentTitle = this.messagePipeline.builder(fTarget, title).build();
        Component componentLore = this.messagePipeline.builder(fTarget, lore).build();
        String id = "fp_fcolor_" + type.ordinal();
        ActionButton button = new ActionButton(new CommonButtonData(componentTitle, componentLore, this.command.getModern().getButtonWidth()), (Action)new DynamicCustomAction(ResourceLocation.minecraft((String)id), null));
        return dialogBuilder.addButton(slot, button).addClickHandler(id, dialog -> this.chatsettingHandler.handleFColorMenu(fPlayer, fTarget, type, color, subMenu, this, id));
    }

    @Override
    public void openSubMenu(FPlayer fPlayer, FPlayer fTarget, Component header, Runnable closeConsumer, List<SubMenuItem> items, Function<SubMenuItem, String> getItemMessage, Consumer<SubMenuItem> onSelect, String id) {
        PlainMessageDialogBody dialogBody = new PlainMessageDialogBody(new PlainMessage((Component)Component.empty(), 10));
        CommonDialogData commonDialogData = new CommonDialogData(header, null, true, false, DialogAction.CLOSE, List.of(dialogBody), List.of());
        Dialog.Builder dialogBuilder = new Dialog.Builder(commonDialogData, this.command.getModern().getColumns()).addCloseConsumer(dialog -> closeConsumer.run());
        for (int i = 0; i < items.size(); ++i) {
            SubMenuItem item = items.get(i);
            String message = getItemMessage.apply(item);
            String[] messages = message.split("<br>");
            String title = messages.length > 0 ? messages[0] : "";
            String lore = messages.length > 1 ? String.join((CharSequence)"<br>", Arrays.copyOfRange(messages, 1, messages.length)) : "";
            Component componentTitle = this.messagePipeline.builder(fTarget, title).build();
            Component componentLore = this.messagePipeline.builder(fTarget, lore).build();
            String subId = id + "_" + i;
            ActionButton button = new ActionButton(new CommonButtonData(componentTitle, componentLore, this.command.getModern().getButtonWidth()), (Action)new DynamicCustomAction(ResourceLocation.minecraft((String)subId), null));
            dialogBuilder.addButton(i, button);
            dialogBuilder.addClickHandler(subId, dialog -> this.chatsettingHandler.handleSubMenu(fPlayer, item, () -> {
                onSelect.accept(item);
                this.dialogController.close(fPlayer.getUuid());
                this.open(fPlayer, fTarget);
            }));
        }
        this.dialogController.open(fPlayer, dialogBuilder.build(), false);
    }
}

