/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.chatsetting.builder;

import com.github.retrooper.packetevents.manager.server.ServerVersion;
import com.github.retrooper.packetevents.protocol.item.ItemStack;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.FColor;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.inventory.Inventory;
import net.flectone.pulse.module.command.chatsetting.ChatsettingModule;
import net.flectone.pulse.module.command.chatsetting.builder.MenuBuilder;
import net.flectone.pulse.module.command.chatsetting.handler.ChatsettingHandler;
import net.flectone.pulse.module.command.chatsetting.model.SubMenuItem;
import net.flectone.pulse.platform.adapter.PlatformServerAdapter;
import net.flectone.pulse.platform.controller.InventoryController;
import net.flectone.pulse.platform.provider.PacketProvider;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.Nullable;

@Singleton
public class InventoryMenuBuilder
implements MenuBuilder {
    private final Command.Chatsetting command;
    private final ChatsettingModule chatsettingModule;
    private final PlatformServerAdapter platformServerAdapter;
    private final MessagePipeline messagePipeline;
    private final InventoryController inventoryController;
    private final ChatsettingHandler chatsettingHandler;
    private final boolean isNewerThanOrEqualsV_1_14;

    @Inject
    public InventoryMenuBuilder(FileResolver fileResolver, ChatsettingModule chatsettingModule, PlatformServerAdapter platformServerAdapter, MessagePipeline messagePipeline, InventoryController inventoryController, ChatsettingHandler chatsettingHandler, PacketProvider packetProvider) {
        this.command = fileResolver.getCommand().getChatsetting();
        this.chatsettingModule = chatsettingModule;
        this.platformServerAdapter = platformServerAdapter;
        this.messagePipeline = messagePipeline;
        this.inventoryController = inventoryController;
        this.chatsettingHandler = chatsettingHandler;
        this.isNewerThanOrEqualsV_1_14 = packetProvider.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_14);
    }

    @Override
    public void open(FPlayer fPlayer, FPlayer fTarget) {
        Localization.Command.Chatsetting localization = (Localization.Command.Chatsetting)this.chatsettingModule.resolveLocalization(fPlayer);
        Component header = this.messagePipeline.builder(fPlayer, fTarget, localization.getInventory()).build();
        Inventory.Builder inventoryBuilder = new Inventory.Builder().name(header).size(54).addCloseConsumer(inventory -> this.chatsettingModule.updateSettings(fTarget));
        for (FPlayer.Setting setting : FPlayer.Setting.values()) {
            inventoryBuilder = setting == FPlayer.Setting.CHAT ? this.createInventoryChatMenu(fPlayer, fTarget, inventoryBuilder, localization) : this.createInventoryCheckbox(fPlayer, fTarget, setting, inventoryBuilder);
        }
        inventoryBuilder = this.createInventoryFColorMenu(fPlayer, fTarget, FColor.Type.SEE, inventoryBuilder, this.command.getMenu().getSee(), localization.getMenu().getSee());
        inventoryBuilder = this.createInventoryFColorMenu(fPlayer, fTarget, FColor.Type.OUT, inventoryBuilder, this.command.getMenu().getOut(), localization.getMenu().getOut());
        this.inventoryController.open(fPlayer, inventoryBuilder.build(this.isNewerThanOrEqualsV_1_14));
    }

    private Inventory.Builder createInventoryCheckbox(FPlayer fPlayer, FPlayer fTarget, FPlayer.Setting setting, Inventory.Builder inventoryBuilder) {
        Command.Chatsetting.Checkbox checkbox = this.command.getCheckbox();
        if (!checkbox.getTypes().containsKey((Object)setting)) {
            return inventoryBuilder;
        }
        int slot = checkbox.getTypes().get((Object)setting);
        if (slot == -1) {
            return inventoryBuilder;
        }
        boolean enabled = fTarget.isSetting(setting);
        String material = this.chatsettingModule.getCheckboxMaterial(enabled);
        String title = this.chatsettingModule.getCheckboxTitle(fPlayer, setting, enabled);
        String lore = this.chatsettingModule.getCheckboxLore(fPlayer, enabled);
        return inventoryBuilder.addItem(slot, this.platformServerAdapter.buildItemStack(fTarget, material, title, lore)).addClickHandler(slot, (itemStack, inventory) -> {
            ChatsettingHandler.Status status = this.chatsettingHandler.handleCheckbox(fPlayer, fTarget, setting);
            if (status == ChatsettingHandler.Status.DENIED) {
                return;
            }
            boolean currentEnabled = status.toBoolean();
            String invertMaterial = this.chatsettingModule.getCheckboxMaterial(!currentEnabled);
            String invertTitle = this.chatsettingModule.getCheckboxTitle(fPlayer, setting, !currentEnabled);
            String invertLore = this.chatsettingModule.getCheckboxLore(fPlayer, !currentEnabled);
            ItemStack newItemStack = this.platformServerAdapter.buildItemStack(fTarget, invertMaterial, invertTitle, invertLore);
            this.inventoryController.changeItem(fPlayer, (Inventory)inventory, slot, newItemStack);
        });
    }

    private Inventory.Builder createInventoryChatMenu(FPlayer fPlayer, FPlayer fTarget, Inventory.Builder inventoryBuilder, Localization.Command.Chatsetting localization) {
        Command.Chatsetting.Menu.Chat chat = this.command.getMenu().getChat();
        int slot = chat.getSlot();
        if (slot == -1) {
            return inventoryBuilder;
        }
        String currentChat = this.chatsettingModule.getPlayerChat(fTarget);
        String material = this.command.getMenu().getMaterial();
        String[] messages = Strings.CS.replace(localization.getMenu().getChat().getItem(), "<chat>", currentChat).split("<br>");
        String title = messages.length > 0 ? messages[0] : "";
        String[] lore = messages.length > 1 ? Arrays.copyOfRange(messages, 1, messages.length) : new String[]{};
        return inventoryBuilder.addItem(slot, this.platformServerAdapter.buildItemStack(fTarget, material, title, lore)).addClickHandler(slot, (itemStack, inventory) -> this.chatsettingHandler.handleChatMenu(fPlayer, fTarget, chat, localization, this, null));
    }

    private Inventory.Builder createInventoryFColorMenu(FPlayer fPlayer, FPlayer fTarget, FColor.Type type, Inventory.Builder inventoryBuilder, Command.Chatsetting.Menu.Color color, Localization.Command.Chatsetting.Menu.SubMenu subMenu) {
        int slot = color.getSlot();
        if (slot == -1) {
            return inventoryBuilder;
        }
        String material = this.command.getMenu().getMaterial();
        String[] messages = subMenu.getItem().split("<br>");
        String title = messages.length > 0 ? messages[0] : "";
        String[] lore = messages.length > 1 ? Arrays.copyOfRange(messages, 1, messages.length) : new String[]{};
        return inventoryBuilder.addItem(slot, this.platformServerAdapter.buildItemStack(fTarget, material, title, lore)).addClickHandler(slot, (itemStack, inventory) -> this.chatsettingHandler.handleFColorMenu(fPlayer, fTarget, type, color, subMenu, this, null));
    }

    @Override
    public void openSubMenu(FPlayer fPlayer, FPlayer fTarget, Component header, Runnable closeConsumer, List<SubMenuItem> items, Function<SubMenuItem, String> getItemMessage, Consumer<SubMenuItem> onSelect, @Nullable String id) {
        Inventory.Builder inventoryBuilder = new Inventory.Builder().name(header).size(54).addCloseConsumer(inventory -> closeConsumer.run());
        for (int i = 0; i < items.size(); ++i) {
            SubMenuItem item = items.get(i);
            String message = getItemMessage.apply(item);
            String[] messages = message.split("<br>");
            String title = messages.length > 0 ? messages[0] : "";
            String[] lore = messages.length > 1 ? Arrays.copyOfRange(messages, 1, messages.length) : new String[]{};
            String material = item.material();
            inventoryBuilder.addItem(i, this.platformServerAdapter.buildItemStack(fTarget, material, title, lore));
            inventoryBuilder.addClickHandler(i, (itemStack, inventory) -> this.chatsettingHandler.handleSubMenu(fPlayer, item, () -> {
                onSelect.accept(item);
                this.inventoryController.close(fPlayer.getUuid());
                this.open(fPlayer, fTarget);
            }));
        }
        this.inventoryController.open(fPlayer, inventoryBuilder.build(this.isNewerThanOrEqualsV_1_14));
    }
}

