/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.clearchat;

import java.util.Optional;
import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.module.AbstractModuleCommand;
import net.flectone.pulse.platform.adapter.PlatformPlayerAdapter;
import net.flectone.pulse.platform.provider.CommandParserProvider;
import net.flectone.pulse.platform.sender.ProxySender;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.checker.PermissionChecker;
import net.flectone.pulse.util.constant.MessageType;
import org.incendo.cloud.context.CommandContext;

@Singleton
public class ClearchatModule
extends AbstractModuleCommand<Localization.Command.Clearchat> {
    private final Command.Clearchat command;
    private final Permission.Command.Clearchat permission;
    private final FPlayerService fPlayerService;
    private final PermissionChecker permissionChecker;
    private final CommandParserProvider commandParserProvider;
    private final ProxySender proxySender;
    private final PlatformPlayerAdapter platformPlayerAdapter;

    @Inject
    public ClearchatModule(FPlayerService fPlayerService, FileResolver fileResolver, PermissionChecker permissionChecker, CommandParserProvider commandParserProvider, ProxySender proxySender, PlatformPlayerAdapter platformPlayerAdapter) {
        super(localization -> localization.getCommand().getClearchat(), Command::getClearchat, MessageType.COMMAND_CLEARCHAT);
        this.command = fileResolver.getCommand().getClearchat();
        this.permission = fileResolver.getPermission().getCommand().getClearchat();
        this.fPlayerService = fPlayerService;
        this.permissionChecker = permissionChecker;
        this.commandParserProvider = commandParserProvider;
        this.proxySender = proxySender;
        this.platformPlayerAdapter = platformPlayerAdapter;
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
        this.createCooldown(this.command.getCooldown(), this.permission.getCooldownBypass());
        this.createSound(this.command.getSound(), this.permission.getSound());
        this.registerPermission(this.permission.getOther());
        String promptPlayer = this.addPrompt(0, Localization.Command.Prompt::getPlayer);
        this.registerCommand(commandBuilder -> commandBuilder.permission(this.permission.getName()).optional(promptPlayer, this.commandParserProvider.playerParser(), this.commandParserProvider.playerSuggestionPermission(false, this.permission.getOther())));
        this.addPredicate(this::checkCooldown);
    }

    @Override
    public void execute(FPlayer fPlayer, CommandContext<FPlayer> commandContext) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        String promptPlayer = this.getPrompt(0);
        Optional optionalPlayer = commandContext.optional(promptPlayer);
        FPlayer fTarget = fPlayer;
        if (optionalPlayer.isPresent() && this.permissionChecker.check((FEntity)fPlayer, this.permission.getOther())) {
            String player = (String)optionalPlayer.get();
            if (player.equals("all")) {
                this.fPlayerService.findOnlineFPlayers().forEach(this::clearChat);
                return;
            }
            fTarget = this.fPlayerService.getFPlayer(player);
            if (fTarget.isUnknown()) {
                this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Clearchat::getNullPlayer)).build());
                return;
            }
        }
        this.clearChat(fTarget);
    }

    public void clearChat(FPlayer fPlayer) {
        this.clearChat(fPlayer, true);
    }

    public void clearChat(FPlayer fPlayer, boolean checkProxy) {
        if (checkProxy && !this.platformPlayerAdapter.isOnline(fPlayer) && this.proxySender.send(fPlayer, MessageType.COMMAND_CLEARCHAT)) {
            return;
        }
        this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format("<br> ".repeat(100))).destination(this.command.getDestination())).build());
        this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Clearchat::getFormat)).destination(this.command.getDestination())).sound(this.getModuleSound())).build());
    }
}

