/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.clearmail;

import java.util.Optional;
import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.module.AbstractModuleCommand;
import net.flectone.pulse.module.command.clearmail.model.ClearmailMetadata;
import net.flectone.pulse.module.command.mail.model.Mail;
import net.flectone.pulse.platform.provider.CommandParserProvider;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.constant.MessageType;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.suggestion.SuggestionProvider;

@Singleton
public class ClearmailModule
extends AbstractModuleCommand<Localization.Command.Clearmail> {
    private final Command.Clearmail command;
    private final Permission.Command.Clearmail permission;
    private final FPlayerService fPlayerService;
    private final CommandParserProvider commandParserProvider;

    @Inject
    public ClearmailModule(FileResolver fileResolver, FPlayerService fPlayerService, CommandParserProvider commandParserProvider) {
        super((Localization localization) -> localization.getCommand().getClearmail(), Command::getClearmail, MessageType.COMMAND_CLEARMAIL);
        this.command = fileResolver.getCommand().getClearmail();
        this.permission = fileResolver.getPermission().getCommand().getClearmail();
        this.fPlayerService = fPlayerService;
        this.commandParserProvider = commandParserProvider;
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
        this.createCooldown(this.command.getCooldown(), this.permission.getCooldownBypass());
        this.createSound(this.command.getSound(), this.permission.getSound());
        String promptId = this.addPrompt(0, Localization.Command.Prompt::getId);
        this.registerCommand(commandBuilder -> commandBuilder.permission(this.permission.getName()).required(promptId, this.commandParserProvider.integerParser(), SuggestionProvider.blockingStrings((commandContext, input) -> {
            FPlayer fPlayer = (FPlayer)commandContext.sender();
            return this.fPlayerService.getSenderMails(fPlayer).stream().map(mail -> String.valueOf(mail.id())).toList();
        })));
        this.addPredicate(this::checkCooldown);
    }

    @Override
    public void execute(FPlayer fPlayer, CommandContext<FPlayer> commandContext) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        int mailID = (Integer)this.getArgument(commandContext, 0);
        Optional<Mail> optionalMail = this.fPlayerService.getSenderMails(fPlayer).stream().filter(mail -> mail.id() == mailID).findAny();
        if (optionalMail.isEmpty()) {
            this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Clearmail::getNullMail)).build());
            return;
        }
        FPlayer fReceiver = this.fPlayerService.getFPlayer(optionalMail.get().receiver());
        this.fPlayerService.deleteMail(optionalMail.get());
        this.sendMessage(((ClearmailMetadata.ClearmailMetadataBuilder)((ClearmailMetadata.ClearmailMetadataBuilder)((ClearmailMetadata.ClearmailMetadataBuilder)((EventMetadata.EventMetadataBuilder)((ClearmailMetadata.ClearmailMetadataBuilder)((ClearmailMetadata.ClearmailMetadataBuilder)((ClearmailMetadata.ClearmailMetadataBuilder)ClearmailMetadata.builder().sender(fReceiver)).filterPlayer(fPlayer)).format(string -> Strings.CS.replaceOnce(string.getFormat(), "<id>", String.valueOf(mailID)))).mail(optionalMail.get())).destination(this.command.getDestination())).message(optionalMail.get().message())).sound(this.getModuleSound())).build());
    }
}

