/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.coin;

import java.util.function.Function;
import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.module.AbstractModuleCommand;
import net.flectone.pulse.module.command.coin.model.CoinMetadata;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.RandomUtil;
import net.flectone.pulse.util.constant.DisableSource;
import net.flectone.pulse.util.constant.MessageType;
import org.incendo.cloud.context.CommandContext;

@Singleton
public class CoinModule
extends AbstractModuleCommand<Localization.Command.Coin> {
    private final Command.Coin command;
    private final Permission.Command.Coin permission;
    private final RandomUtil randomUtil;

    @Inject
    public CoinModule(FileResolver fileResolver, RandomUtil randomUtil) {
        super(localization -> localization.getCommand().getCoin(), Command::getCoin, fPlayer -> fPlayer.isSetting(FPlayer.Setting.COIN), MessageType.COMMAND_COIN);
        this.command = fileResolver.getCommand().getCoin();
        this.permission = fileResolver.getPermission().getCommand().getCoin();
        this.randomUtil = randomUtil;
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
        this.createCooldown(this.command.getCooldown(), this.permission.getCooldownBypass());
        this.createSound(this.command.getSound(), this.permission.getSound());
        this.registerCommand(commandBuilder -> commandBuilder.permission(this.permission.getName()));
        this.addPredicate(this::checkCooldown);
        this.addPredicate(fPlayer -> this.checkDisable((FEntity)fPlayer, (FEntity)fPlayer, DisableSource.YOU));
        this.addPredicate(this::checkMute);
    }

    @Override
    public void execute(FPlayer fPlayer, CommandContext<FPlayer> commandContext) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        int percent = this.randomUtil.nextInt(this.command.isDraw() ? 0 : 1, 101);
        this.sendMessage(((CoinMetadata.CoinMetadataBuilder)((CoinMetadata.CoinMetadataBuilder)((CoinMetadata.CoinMetadataBuilder)((CoinMetadata.CoinMetadataBuilder)((CoinMetadata.CoinMetadataBuilder)((EventMetadata.EventMetadataBuilder)((CoinMetadata.CoinMetadataBuilder)((CoinMetadata.CoinMetadataBuilder)CoinMetadata.builder().sender(fPlayer)).format(this.replaceResult(percent))).percent(percent)).range(this.command.getRange())).destination(this.command.getDestination())).sound(this.getModuleSound())).proxy(output -> output.writeInt(percent))).integration(string -> Strings.CS.replace(string, "<result>", this.replaceResult(percent).apply((Localization.Command.Coin)this.resolveLocalization())))).build());
    }

    public Function<Localization.Command.Coin, String> replaceResult(int percent) {
        return message -> percent != 0 ? Strings.CS.replace(message.getFormat(), "<result>", percent > 50 ? message.getHead() : message.getTail()) : message.getFormatDraw();
    }
}

