/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.deletemessage;

import java.util.UUID;
import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.module.AbstractModuleCommand;
import net.flectone.pulse.module.command.deletemessage.model.DeletemessageMetadata;
import net.flectone.pulse.module.message.format.moderation.delete.DeleteModule;
import net.flectone.pulse.platform.sender.ProxySender;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.constant.DisableSource;
import net.flectone.pulse.util.constant.MessageType;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.parser.standard.UUIDParser;

@Singleton
public class DeletemessageModule
extends AbstractModuleCommand<Localization.Command.Deletemessage> {
    private final Command.Deletemessage command;
    private final Permission.Command.Deletemessage permission;
    private final DeleteModule deleteModule;
    private final ProxySender proxySender;

    @Inject
    public DeletemessageModule(FileResolver fileResolver, DeleteModule deleteModule, ProxySender proxySender) {
        super((Localization localization) -> localization.getCommand().getDeletemessage(), Command::getDeletemessage, MessageType.COMMAND_DELETE);
        this.command = fileResolver.getCommand().getDeletemessage();
        this.permission = fileResolver.getPermission().getCommand().getDeletemessage();
        this.deleteModule = deleteModule;
        this.proxySender = proxySender;
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
        this.createCooldown(this.command.getCooldown(), this.permission.getCooldownBypass());
        this.createSound(this.command.getSound(), this.permission.getSound());
        String promptId = this.addPrompt(0, Localization.Command.Prompt::getId);
        this.registerCommand(commandBuilder -> commandBuilder.permission(this.permission.getName()).required(promptId, UUIDParser.uuidParser()));
        this.addPredicate(this::checkCooldown);
        this.addPredicate(fPlayer -> this.checkDisable((FEntity)fPlayer, (FEntity)fPlayer, DisableSource.YOU));
        this.addPredicate(this::checkMute);
    }

    @Override
    public void execute(FPlayer fPlayer, CommandContext<FPlayer> commandContext) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        UUID uuid = (UUID)this.getArgument(commandContext, 0);
        if (!this.deleteModule.remove(fPlayer, uuid)) {
            this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Deletemessage::getNullMessage)).build());
            return;
        }
        this.proxySender.send(fPlayer, MessageType.COMMAND_DELETE, dataOutputStream -> dataOutputStream.writeUTF(uuid.toString()), UUID.randomUUID());
        this.sendMessage(((DeletemessageMetadata.DeletemessageMetadataBuilder)((DeletemessageMetadata.DeletemessageMetadataBuilder)((EventMetadata.EventMetadataBuilder)((DeletemessageMetadata.DeletemessageMetadataBuilder)((DeletemessageMetadata.DeletemessageMetadataBuilder)DeletemessageMetadata.builder().sender(fPlayer)).format(Localization.Command.Deletemessage::getFormat)).deletedUUID(uuid)).destination(this.command.getDestination())).sound(this.getModuleSound())).build());
    }
}

