/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.dice;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.module.AbstractModuleCommand;
import net.flectone.pulse.module.command.dice.model.DiceMetadata;
import net.flectone.pulse.platform.provider.CommandParserProvider;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.RandomUtil;
import net.flectone.pulse.util.constant.DisableSource;
import net.flectone.pulse.util.constant.MessageType;
import org.incendo.cloud.context.CommandContext;

@Singleton
public class DiceModule
extends AbstractModuleCommand<Localization.Command.Dice> {
    private final Command.Dice command;
    private final Permission.Command.Dice permission;
    private final CommandParserProvider commandParserProvider;
    private final RandomUtil randomUtil;

    @Inject
    public DiceModule(FileResolver fileResolver, CommandParserProvider commandParserProvider, RandomUtil randomUtil) {
        super(localization -> localization.getCommand().getDice(), Command::getDice, fPlayer -> fPlayer.isSetting(FPlayer.Setting.DICE), MessageType.COMMAND_DICE);
        this.command = fileResolver.getCommand().getDice();
        this.permission = fileResolver.getPermission().getCommand().getDice();
        this.commandParserProvider = commandParserProvider;
        this.randomUtil = randomUtil;
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
        this.createCooldown(this.command.getCooldown(), this.permission.getCooldownBypass());
        this.createSound(this.command.getSound(), this.permission.getSound());
        String promptMessage = this.addPrompt(0, Localization.Command.Prompt::getMessage);
        this.registerCommand(commandBuilder -> commandBuilder.permission(this.permission.getName()).optional(promptMessage, this.commandParserProvider.integerParser(this.command.getMin(), this.command.getMax())));
        this.addPredicate(this::checkCooldown);
        this.addPredicate(fPlayer -> this.checkDisable((FEntity)fPlayer, (FEntity)fPlayer, DisableSource.YOU));
        this.addPredicate(this::checkMute);
    }

    @Override
    public void execute(FPlayer fPlayer, CommandContext<FPlayer> commandContext) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        int min = this.command.getMin();
        int max = this.command.getMax();
        String promptMessage = this.getPrompt(0);
        Optional optionalNumber = commandContext.optional(promptMessage);
        int number = optionalNumber.orElse(min);
        ArrayList<Integer> cubes = new ArrayList<Integer>();
        for (int i = 0; i < number; ++i) {
            cubes.add(this.randomUtil.nextInt(min, max + 1));
        }
        this.sendMessage(((DiceMetadata.DiceMetadataBuilder)((DiceMetadata.DiceMetadataBuilder)((DiceMetadata.DiceMetadataBuilder)((DiceMetadata.DiceMetadataBuilder)((DiceMetadata.DiceMetadataBuilder)((DiceMetadata.DiceMetadataBuilder)((EventMetadata.EventMetadataBuilder)((DiceMetadata.DiceMetadataBuilder)DiceMetadata.builder().sender(fPlayer)).cubes(cubes)).format(dice -> this.replaceResult(cubes, dice.getSymbols(), dice.getFormat()))).range(this.command.getRange())).destination(this.command.getDestination())).sound(this.getModuleSound())).proxy(dataOutputStream -> dataOutputStream.writeAsJson(cubes))).integration(string -> this.replaceResult((List<Integer>)cubes, ((Localization.Command.Dice)this.resolveLocalization()).getSymbols(), (String)string))).build());
    }

    public String replaceResult(List<Integer> cubes, Map<Integer, String> symbols, String format) {
        StringBuilder stringBuilder = new StringBuilder();
        int sum = 0;
        for (Integer integer : cubes) {
            sum += integer.intValue();
            stringBuilder.append(symbols.get(integer)).append(" ");
        }
        return StringUtils.replaceEach((String)format, (String[])new String[]{"<sum>", "<message>"}, (String[])new String[]{String.valueOf(sum), stringBuilder.toString().trim()});
    }
}

