/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.flectonepulse;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import lombok.NonNull;
import net.flectone.pulse.FlectonePulse;
import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.Config;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Injector;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.library.libby.Library;
import net.flectone.pulse.library.libby.relocation.Relocation;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.module.AbstractModuleCommand;
import net.flectone.pulse.module.command.flectonepulse.web.SparkServer;
import net.flectone.pulse.module.command.flectonepulse.web.service.UrlService;
import net.flectone.pulse.platform.formatter.TimeFormatter;
import net.flectone.pulse.platform.provider.CommandParserProvider;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.processing.resolver.LibraryResolver;
import net.flectone.pulse.processing.resolver.ReflectionResolver;
import net.flectone.pulse.util.constant.MessageType;
import net.flectone.pulse.util.logging.FLogger;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.suggestion.BlockingSuggestionProvider;
import org.incendo.cloud.suggestion.Suggestion;

@Singleton
public class FlectonepulseModule
extends AbstractModuleCommand<Localization.Command.Flectonepulse> {
    private final String sparkClass = "net.flectone.pulse.library.spark.Service";
    private final Config.Editor config;
    private final Command.Flectonepulse command;
    private final Permission.Command.Flectonepulse permission;
    private final FlectonePulse flectonePulse;
    private final CommandParserProvider commandParserProvider;
    private final TimeFormatter timeFormatter;
    private final FLogger fLogger;
    private final ReflectionResolver reflectionResolver;
    private final Injector injector;

    @Inject
    public FlectonepulseModule(FileResolver fileResolver, CommandParserProvider commandParserProvider, TimeFormatter timeFormatter, FlectonePulse flectonePulse, FLogger fLogger, ReflectionResolver reflectionResolver, Injector injector) {
        super(localization -> localization.getCommand().getFlectonepulse(), Command::getFlectonepulse, MessageType.COMMAND_FLECTONEPULSE);
        this.config = fileResolver.getConfig().getEditor();
        this.command = fileResolver.getCommand().getFlectonepulse();
        this.permission = fileResolver.getPermission().getCommand().getFlectonepulse();
        this.flectonePulse = flectonePulse;
        this.commandParserProvider = commandParserProvider;
        this.timeFormatter = timeFormatter;
        this.fLogger = fLogger;
        this.reflectionResolver = reflectionResolver;
        this.injector = injector;
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
        this.createCooldown(this.command.getCooldown(), this.permission.getCooldownBypass());
        this.createSound(this.command.getSound(), this.permission.getSound());
        String promptType = this.addPrompt(0, Localization.Command.Prompt::getType);
        this.registerCommand(commandBuilder -> commandBuilder.permission(this.permission.getName()).required(promptType, this.commandParserProvider.singleMessageParser(), this.typeSuggestion()));
        this.addPredicate(this::checkCooldown);
        if (this.reflectionResolver.hasClass("net.flectone.pulse.library.spark.Service")) {
            this.enableSpark();
        }
    }

    @Override
    public void onDisable() {
        super.onDisable();
        if (this.reflectionResolver.hasClass("net.flectone.pulse.library.spark.Service")) {
            ((SparkServer)this.injector.getInstance(SparkServer.class)).onDisable();
        }
    }

    @Override
    public void execute(FPlayer fPlayer, CommandContext<FPlayer> commandContext) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        String type = (String)this.getArgument(commandContext, 0);
        if (type.equalsIgnoreCase("editor")) {
            if (this.config.getHost().isEmpty()) {
                this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Flectonepulse::getNullHostEditor)).build());
                return;
            }
            this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Flectonepulse::getFormatWebStarting)).destination(this.command.getDestination())).build());
            UrlService urlService = (UrlService)this.injector.getInstance(UrlService.class);
            String url = urlService.generateUrl();
            this.reflectionResolver.hasClassOrElse("net.flectone.pulse.library.spark.Service", this::loadSparkLibrary);
            this.enableSpark();
            this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(flectonepulse -> Strings.CS.replace(flectonepulse.getFormatEditor(), "<url>", url))).destination(this.command.getDestination())).sound(this.getModuleSound())).build());
            return;
        }
        try {
            Instant start = Instant.now();
            this.flectonePulse.reload();
            Instant end = Instant.now();
            String formattedTime = this.timeFormatter.format(fPlayer, Duration.between(start, end).toMillis());
            this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(flectonepulse -> Strings.CS.replace(flectonepulse.getFormatTrue(), "<time>", formattedTime))).destination(this.command.getDestination())).sound(this.getModuleSound())).build());
        }
        catch (Exception e) {
            this.fLogger.warning(e);
            this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Flectonepulse::getFormatFalse)).message(e.getLocalizedMessage())).destination(this.command.getDestination())).build());
        }
    }

    private void enableSpark() {
        SparkServer sparkServer = (SparkServer)this.injector.getInstance(SparkServer.class);
        if (!sparkServer.isEnable()) {
            sparkServer.onEnable();
        }
    }

    @NonNull
    private BlockingSuggestionProvider<FPlayer> typeSuggestion() {
        return (context, input) -> List.of(Suggestion.suggestion((String)"reload"), Suggestion.suggestion((String)"editor"));
    }

    private void loadSparkLibrary(LibraryResolver libraryResolver) {
        libraryResolver.loadLibrary(Library.builder().groupId("com{}sparkjava").artifactId("spark-core").version("2.9.4").resolveTransitiveDependencies(true).relocate(Relocation.builder().pattern("spark").relocatedPattern("net.flectone.pulse.library.spark").build()).build());
    }
}

