/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.flectonepulse.web.service;

import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import net.flectone.pulse.config.Config;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.module.command.flectonepulse.web.exception.EmptyHostException;
import net.flectone.pulse.processing.resolver.FileResolver;

@Singleton
public class UrlService {
    private final Config.Editor config;
    private final AtomicReference<UUID> currentToken = new AtomicReference<UUID>(UUID.randomUUID());

    @Inject
    public UrlService(FileResolver fileResolver) {
        this.config = fileResolver.getConfig().getEditor();
    }

    public String generateUrl() {
        Object url = "http";
        if (this.config.isHttps()) {
            url = (String)url + "s";
        }
        return (String)url + "://" + this.getLocalIp() + ":" + this.config.getPort() + "/editor/" + String.valueOf(this.currentToken.get());
    }

    public boolean validateToken(String token) {
        return token.equalsIgnoreCase(this.currentToken.get().toString());
    }

    public void resetToken() {
        this.currentToken.set(UUID.randomUUID());
    }

    private String getLocalIp() throws EmptyHostException {
        String host = this.config.getHost();
        if (host.isEmpty()) {
            throw new EmptyHostException();
        }
        return host;
    }
}

