/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.helper;

import java.util.List;
import java.util.function.Predicate;
import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.module.AbstractModuleCommand;
import net.flectone.pulse.platform.provider.CommandParserProvider;
import net.flectone.pulse.platform.registry.ProxyRegistry;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.checker.PermissionChecker;
import net.flectone.pulse.util.constant.DisableSource;
import net.flectone.pulse.util.constant.MessageType;
import org.incendo.cloud.context.CommandContext;

@Singleton
public class HelperModule
extends AbstractModuleCommand<Localization.Command.Helper> {
    private final Command.Helper command;
    private final Permission.Command.Helper permission;
    private final FPlayerService fPlayerService;
    private final ProxyRegistry proxyRegistry;
    private final PermissionChecker permissionChecker;
    private final CommandParserProvider commandParserProvider;

    @Inject
    public HelperModule(FileResolver fileResolver, FPlayerService fPlayerService, ProxyRegistry proxyRegistry, PermissionChecker permissionChecker, CommandParserProvider commandParserProvider) {
        super(localization -> localization.getCommand().getHelper(), Command::getHelper, MessageType.COMMAND_HELPER);
        this.command = fileResolver.getCommand().getHelper();
        this.permission = fileResolver.getPermission().getCommand().getHelper();
        this.fPlayerService = fPlayerService;
        this.proxyRegistry = proxyRegistry;
        this.permissionChecker = permissionChecker;
        this.commandParserProvider = commandParserProvider;
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
        this.createCooldown(this.command.getCooldown(), this.permission.getCooldownBypass());
        this.createSound(this.command.getSound(), this.permission.getSound());
        this.registerPermission(this.permission.getSee());
        String promptMessage = this.addPrompt(0, Localization.Command.Prompt::getMessage);
        this.registerCommand(commandBuilder -> commandBuilder.permission(this.permission.getName()).required(promptMessage, this.commandParserProvider.nativeMessageParser()));
        this.addPredicate(this::checkCooldown);
        this.addPredicate(fPlayer -> this.checkDisable((FEntity)fPlayer, (FEntity)fPlayer, DisableSource.YOU));
        this.addPredicate(this::checkMute);
    }

    @Override
    public void execute(FPlayer fPlayer, CommandContext<FPlayer> commandContext) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        Predicate<FPlayer> filter = this.getFilterSee();
        List<FPlayer> recipients = this.fPlayerService.getVisibleFPlayersFor(fPlayer).stream().filter(filter).toList();
        if (recipients.isEmpty() && this.command.isNullHelper()) {
            boolean nullHelper;
            boolean bl = nullHelper = !this.proxyRegistry.hasEnabledProxy() || this.fPlayerService.findOnlineFPlayers().stream().noneMatch(online -> this.permissionChecker.check((FEntity)online, this.permission.getSee()));
            if (nullHelper) {
                this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Helper::getNullHelper)).build());
                return;
            }
        }
        String message = (String)this.getArgument(commandContext, 0);
        this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Helper::getPlayer)).destination(this.command.getDestination())).build());
        this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Helper::getGlobal)).destination(this.command.getDestination())).range(this.command.getRange())).message(message)).filter(filter)).proxy(dataOutputStream -> dataOutputStream.writeString(message))).integration()).build());
    }

    public Predicate<FPlayer> getFilterSee() {
        return fPlayer -> this.permissionChecker.check((FEntity)fPlayer, this.permission.getSee());
    }
}

