/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.ignore;

import java.util.Optional;
import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.module.AbstractModuleCommand;
import net.flectone.pulse.module.command.ignore.model.Ignore;
import net.flectone.pulse.module.command.ignore.model.IgnoreMetadata;
import net.flectone.pulse.platform.provider.CommandParserProvider;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.constant.DisableSource;
import net.flectone.pulse.util.constant.MessageType;
import org.incendo.cloud.context.CommandContext;

@Singleton
public class IgnoreModule
extends AbstractModuleCommand<Localization.Command.Ignore> {
    private final Command.Ignore command;
    private final Permission.Command.Ignore permission;
    private final FPlayerService fPlayerService;
    private final CommandParserProvider commandParserProvider;

    @Inject
    public IgnoreModule(FileResolver fileResolver, FPlayerService fPlayerService, CommandParserProvider commandParserProvider) {
        super((Localization localization) -> localization.getCommand().getIgnore(), Command::getIgnore, MessageType.COMMAND_IGNORE);
        this.command = fileResolver.getCommand().getIgnore();
        this.permission = fileResolver.getPermission().getCommand().getIgnore();
        this.fPlayerService = fPlayerService;
        this.commandParserProvider = commandParserProvider;
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
        this.createCooldown(this.command.getCooldown(), this.permission.getCooldownBypass());
        this.createSound(this.command.getSound(), this.permission.getSound());
        String promptPlayer = this.addPrompt(0, Localization.Command.Prompt::getPlayer);
        this.registerCommand(manager -> manager.permission(this.permission.getName()).required(promptPlayer, this.commandParserProvider.playerParser(this.command.isSuggestOfflinePlayers())));
        this.addPredicate(this::checkCooldown);
        this.addPredicate(fPlayer -> this.checkDisable((FEntity)fPlayer, (FEntity)fPlayer, DisableSource.YOU));
    }

    @Override
    public void execute(FPlayer fPlayer, CommandContext<FPlayer> commandContext) {
        Ignore metadataIgnore;
        if (this.checkCooldown(fPlayer)) {
            return;
        }
        if (this.checkDisable(fPlayer, fPlayer, DisableSource.YOU)) {
            return;
        }
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        String targetName = (String)this.getArgument(commandContext, 0);
        if (fPlayer.getName().equalsIgnoreCase(targetName)) {
            this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Ignore::getMyself)).build());
            return;
        }
        FPlayer fTarget = this.fPlayerService.getFPlayer(targetName);
        if (fTarget.isUnknown()) {
            this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Ignore::getNullPlayer)).build());
            return;
        }
        Optional<Ignore> optionalIgnore = fPlayer.getIgnores().stream().filter(i -> i.target() == fTarget.getId()).findFirst();
        if (optionalIgnore.isPresent()) {
            metadataIgnore = optionalIgnore.get();
            fPlayer.getIgnores().remove(optionalIgnore.get());
            this.fPlayerService.deleteIgnore(optionalIgnore.get());
        } else {
            Ignore newIgnore = this.fPlayerService.saveAndGetIgnore(fPlayer, fTarget);
            if (newIgnore == null) {
                return;
            }
            metadataIgnore = newIgnore;
            fPlayer.getIgnores().add(newIgnore);
        }
        this.sendMessage(((IgnoreMetadata.IgnoreMetadataBuilder)((IgnoreMetadata.IgnoreMetadataBuilder)((EventMetadata.EventMetadataBuilder)((IgnoreMetadata.IgnoreMetadataBuilder)((IgnoreMetadata.IgnoreMetadataBuilder)((IgnoreMetadata.IgnoreMetadataBuilder)((IgnoreMetadata.IgnoreMetadataBuilder)IgnoreMetadata.builder().sender(fTarget)).filterPlayer(fPlayer)).format(ignore -> optionalIgnore.isEmpty() ? ignore.getFormatTrue() : ignore.getFormatFalse())).ignore(metadataIgnore)).ignored(optionalIgnore.isEmpty())).destination(this.command.getDestination())).sound(this.getModuleSound())).build());
    }
}

