/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.ignorelist;

import java.util.List;
import java.util.Optional;
import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.execution.dispatcher.EventDispatcher;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.model.event.message.MessageSendEvent;
import net.flectone.pulse.module.AbstractModuleCommand;
import net.flectone.pulse.module.command.ignore.model.Ignore;
import net.flectone.pulse.platform.formatter.TimeFormatter;
import net.flectone.pulse.platform.provider.CommandParserProvider;
import net.flectone.pulse.platform.sender.SoundPlayer;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.constant.MessageType;
import net.kyori.adventure.text.Component;
import org.incendo.cloud.context.CommandContext;

@Singleton
public class IgnorelistModule
extends AbstractModuleCommand<Localization.Command.Ignorelist> {
    private final Command.Ignorelist command;
    private final Permission.Command.Ignorelist permission;
    private final FPlayerService fPlayerService;
    private final EventDispatcher eventDispatcher;
    private final MessagePipeline messagePipeline;
    private final CommandParserProvider commandParserProvider;
    private final TimeFormatter timeFormatter;
    private final SoundPlayer soundPlayer;

    @Inject
    public IgnorelistModule(FileResolver fileResolver, FPlayerService fPlayerService, EventDispatcher eventDispatcher, MessagePipeline messagePipeline, CommandParserProvider commandParserProvider, TimeFormatter timeFormatter, SoundPlayer soundPlayer) {
        super(localization -> localization.getCommand().getIgnorelist(), Command::getIgnorelist, MessageType.COMMAND_IGNORELIST);
        this.command = fileResolver.getCommand().getIgnorelist();
        this.permission = fileResolver.getPermission().getCommand().getIgnorelist();
        this.fPlayerService = fPlayerService;
        this.eventDispatcher = eventDispatcher;
        this.messagePipeline = messagePipeline;
        this.commandParserProvider = commandParserProvider;
        this.timeFormatter = timeFormatter;
        this.soundPlayer = soundPlayer;
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
        this.createCooldown(this.command.getCooldown(), this.permission.getCooldownBypass());
        this.createSound(this.command.getSound(), this.permission.getSound());
        String promptNumber = this.addPrompt(0, Localization.Command.Prompt::getNumber);
        this.registerCommand(commandBuilder -> commandBuilder.permission(this.permission.getName()).optional(promptNumber, this.commandParserProvider.integerParser()));
        this.addPredicate(this::checkCooldown);
    }

    @Override
    public void execute(FPlayer fPlayer, CommandContext<FPlayer> commandContext) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        List<Ignore> ignoreList = fPlayer.getIgnores();
        if (ignoreList.isEmpty()) {
            this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Ignorelist::getEmpty)).build());
            return;
        }
        Localization.Command.Ignorelist localization = (Localization.Command.Ignorelist)this.resolveLocalization(fPlayer);
        int size = ignoreList.size();
        int perPage = this.command.getPerPage();
        int countPage = (int)Math.ceil((double)size / (double)perPage);
        String prompt = this.getPrompt(0);
        Optional optionalPage = commandContext.optional(prompt);
        Integer page = optionalPage.orElse(1);
        if (page > countPage || page < 1) {
            this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Ignorelist::getNullPage)).build());
            return;
        }
        String commandLine = "/" + this.getCommandName();
        List finalIgnoreList = ignoreList.stream().skip((long)(page - 1) * (long)perPage).limit(perPage).toList();
        String header = Strings.CS.replace(localization.getHeader(), "<count>", String.valueOf(size));
        Component component = this.messagePipeline.builder(fPlayer, header).build().append(Component.newline());
        for (Ignore ignore : finalIgnoreList) {
            FPlayer fTarget = this.fPlayerService.getFPlayer(ignore.target());
            String line = StringUtils.replaceEach((String)localization.getLine(), (String[])new String[]{"<command>", "<date>"}, (String[])new String[]{"/ignore " + fTarget.getName(), this.timeFormatter.formatDate(ignore.date())});
            component = component.append(this.messagePipeline.builder(fTarget, fPlayer, line).build()).append(Component.newline());
        }
        String footer = StringUtils.replaceEach((String)localization.getFooter(), (String[])new String[]{"<command>", "<prev_page>", "<next_page>", "<current_page>", "<last_page>"}, (String[])new String[]{commandLine, String.valueOf(page - 1), String.valueOf(page + 1), String.valueOf(page), String.valueOf(countPage)});
        component = component.append(this.messagePipeline.builder(fPlayer, footer).build());
        this.eventDispatcher.dispatch(new MessageSendEvent(MessageType.COMMAND_IGNORELIST, fPlayer, component));
        this.soundPlayer.play(this.getModuleSound(), fPlayer);
    }
}

