/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.kick;

import java.util.Optional;
import java.util.function.BiFunction;
import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.model.event.ModerationMetadata;
import net.flectone.pulse.model.util.Moderation;
import net.flectone.pulse.module.AbstractModuleCommand;
import net.flectone.pulse.platform.formatter.ModerationMessageFormatter;
import net.flectone.pulse.platform.provider.CommandParserProvider;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.service.ModerationService;
import net.flectone.pulse.util.constant.DisableSource;
import net.flectone.pulse.util.constant.MessageType;
import org.incendo.cloud.context.CommandContext;

@Singleton
public class KickModule
extends AbstractModuleCommand<Localization.Command.Kick> {
    private final Command.Kick command;
    private final Permission.Command.Kick permission;
    private final FPlayerService fPlayerService;
    private final ModerationService moderationService;
    private final ModerationMessageFormatter moderationMessageFormatter;
    private final CommandParserProvider commandParserProvider;
    private final MessagePipeline messagePipeline;

    @Inject
    public KickModule(FileResolver fileResolver, FPlayerService fPlayerService, ModerationService moderationService, ModerationMessageFormatter moderationMessageFormatter, CommandParserProvider commandParserProvider, MessagePipeline messagePipeline) {
        super(localization -> localization.getCommand().getKick(), Command::getKick, fPlayer -> fPlayer.isSetting(FPlayer.Setting.KICK), MessageType.COMMAND_KICK);
        this.command = fileResolver.getCommand().getKick();
        this.permission = fileResolver.getPermission().getCommand().getKick();
        this.fPlayerService = fPlayerService;
        this.moderationService = moderationService;
        this.moderationMessageFormatter = moderationMessageFormatter;
        this.commandParserProvider = commandParserProvider;
        this.messagePipeline = messagePipeline;
    }

    @Override
    public void onEnable() {
        if (this.isModuleDisabledFor(FPlayer.UNKNOWN)) {
            return;
        }
        this.registerModulePermission(this.permission);
        this.createCooldown(this.command.getCooldown(), this.permission.getCooldownBypass());
        this.createSound(this.command.getSound(), this.permission.getSound());
        String promptPlayer = this.addPrompt(0, Localization.Command.Prompt::getPlayer);
        String promptMessage = this.addPrompt(1, Localization.Command.Prompt::getMessage);
        this.registerCommand(commandBuilder -> commandBuilder.permission(this.permission.getName()).required(promptPlayer, this.commandParserProvider.playerParser()).optional(promptMessage, this.commandParserProvider.nativeMessageParser()));
    }

    @Override
    public void execute(FPlayer fPlayer, CommandContext<FPlayer> commandContext) {
        if (this.checkCooldown(fPlayer)) {
            return;
        }
        if (this.checkDisable(fPlayer, fPlayer, DisableSource.YOU)) {
            return;
        }
        if (this.checkMute(fPlayer)) {
            return;
        }
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        String playerName = (String)this.getArgument(commandContext, 0);
        FPlayer fTarget = this.fPlayerService.getFPlayer(playerName);
        if (!fTarget.isOnline()) {
            this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Kick::getNullPlayer)).build());
            return;
        }
        String promptMessage = this.getPrompt(1);
        Optional optionalReason = commandContext.optional(promptMessage);
        String reason = optionalReason.orElse(null);
        Moderation kick = this.moderationService.kick(fTarget, reason, fPlayer.getId());
        if (kick == null) {
            return;
        }
        this.kick(fPlayer, fTarget, kick);
        this.sendMessage(((ModerationMetadata.ModerationMetadataBuilder)((ModerationMetadata.ModerationMetadataBuilder)((ModerationMetadata.ModerationMetadataBuilder)((ModerationMetadata.ModerationMetadataBuilder)((ModerationMetadata.ModerationMetadataBuilder)((EventMetadata.EventMetadataBuilder)((ModerationMetadata.ModerationMetadataBuilder)((ModerationMetadata.ModerationMetadataBuilder)ModerationMetadata.builder().sender(fTarget)).format(this.buildFormat(kick))).moderation(kick)).destination(this.command.getDestination())).range(this.command.getRange())).sound(this.getModuleSound())).proxy(dataOutputStream -> dataOutputStream.writeAsJson(kick))).integration(string -> this.moderationMessageFormatter.replacePlaceholders((String)string, FPlayer.UNKNOWN, kick))).build());
    }

    public BiFunction<FPlayer, Localization.Command.Kick, String> buildFormat(Moderation kick) {
        return (fReceiver, message) -> this.moderationMessageFormatter.replacePlaceholders(message.getServer(), (FPlayer)fReceiver, kick);
    }

    public void kick(FEntity fModerator, FPlayer fReceiver, Moderation kick) {
        if (this.isModuleDisabledFor(fModerator)) {
            return;
        }
        String format = this.moderationMessageFormatter.replacePlaceholders(((Localization.Command.Kick)this.resolveLocalization(fReceiver)).getPerson(), fReceiver, kick);
        this.fPlayerService.kick(fReceiver, this.messagePipeline.builder(fReceiver, format).build());
    }
}

