/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.mail;

import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.listener.PulseListener;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.module.AbstractModuleCommand;
import net.flectone.pulse.module.command.mail.listener.MailPulseListener;
import net.flectone.pulse.module.command.mail.model.Mail;
import net.flectone.pulse.module.command.mail.model.MailMetadata;
import net.flectone.pulse.module.command.tell.TellModule;
import net.flectone.pulse.module.integration.IntegrationModule;
import net.flectone.pulse.platform.provider.CommandParserProvider;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.constant.DisableSource;
import net.flectone.pulse.util.constant.MessageType;
import org.incendo.cloud.context.CommandContext;

@Singleton
public class MailModule
extends AbstractModuleCommand<Localization.Command.Mail>
implements PulseListener {
    private final Command.Mail command;
    private final Permission.Command.Mail permission;
    private final TellModule tellModule;
    private final IntegrationModule integrationModule;
    private final FPlayerService fPlayerService;
    private final CommandParserProvider commandParserProvider;
    private final ListenerRegistry listenerRegistry;

    @Inject
    public MailModule(FileResolver fileResolver, TellModule tellModule, IntegrationModule integrationModule, FPlayerService fPlayerService, CommandParserProvider commandParserProvider, ListenerRegistry listenerRegistry) {
        super(localization -> localization.getCommand().getMail(), Command::getMail, fPlayer -> fPlayer.isSetting(FPlayer.Setting.MAIL), MessageType.COMMAND_MAIL);
        this.command = fileResolver.getCommand().getMail();
        this.permission = fileResolver.getPermission().getCommand().getMail();
        this.tellModule = tellModule;
        this.integrationModule = integrationModule;
        this.fPlayerService = fPlayerService;
        this.commandParserProvider = commandParserProvider;
        this.listenerRegistry = listenerRegistry;
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
        this.createCooldown(this.command.getCooldown(), this.permission.getCooldownBypass());
        this.createSound(this.command.getSound(), this.permission.getSound());
        String promptPlayer = this.addPrompt(0, Localization.Command.Prompt::getPlayer);
        String promptMessage = this.addPrompt(1, Localization.Command.Prompt::getMessage);
        this.registerCommand(manager -> manager.permission(this.permission.getName()).required(promptPlayer, this.commandParserProvider.playerParser(true)).required(promptMessage, this.commandParserProvider.nativeMessageParser()));
        this.listenerRegistry.register(MailPulseListener.class);
    }

    @Override
    public void execute(FPlayer fPlayer, CommandContext<FPlayer> commandContext) {
        if (this.checkCooldown(fPlayer)) {
            return;
        }
        if (this.checkDisable(fPlayer, fPlayer, DisableSource.YOU)) {
            return;
        }
        if (this.checkMute(fPlayer)) {
            return;
        }
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        String playerName = (String)this.getArgument(commandContext, 0);
        FPlayer fReceiver = this.fPlayerService.getFPlayer(playerName);
        if (fReceiver.isUnknown()) {
            this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Mail::getNullPlayer)).build());
            return;
        }
        if (fReceiver.isOnline() && this.integrationModule.canSeeVanished(fReceiver, fPlayer)) {
            if (!this.tellModule.isEnable()) {
                this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Mail::getOnlinePlayer)).build());
                return;
            }
            this.tellModule.execute(fPlayer, commandContext);
            return;
        }
        this.fPlayerService.loadIgnores(fReceiver);
        if (this.checkIgnore(fPlayer, fReceiver)) {
            return;
        }
        if (this.checkDisable(fPlayer, fReceiver, DisableSource.HE)) {
            return;
        }
        String message = (String)this.getArgument(commandContext, 1);
        Mail mail = this.fPlayerService.saveAndGetMail(fPlayer, fReceiver, message);
        if (mail == null) {
            return;
        }
        this.sendMessage(((MailMetadata.MailMetadataBuilder)((MailMetadata.MailMetadataBuilder)((MailMetadata.MailMetadataBuilder)((EventMetadata.EventMetadataBuilder)((MailMetadata.MailMetadataBuilder)((MailMetadata.MailMetadataBuilder)((MailMetadata.MailMetadataBuilder)MailMetadata.builder().sender(fReceiver)).filterPlayer(fPlayer)).format(s -> Strings.CS.replaceOnce(s.getSender(), "<id>", String.valueOf(mail.id())))).mail(mail)).message(message)).destination(this.command.getDestination())).sound(this.getModuleSound())).build());
    }
}

