/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.mail.listener;

import java.util.List;
import net.flectone.pulse.annotation.Pulse;
import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.listener.PulseListener;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.model.event.player.PlayerJoinEvent;
import net.flectone.pulse.module.command.mail.MailModule;
import net.flectone.pulse.module.command.mail.model.Mail;
import net.flectone.pulse.module.command.mail.model.MailMetadata;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;

@Singleton
public class MailPulseListener
implements PulseListener {
    private final Command.Mail command;
    private final MailModule mailModule;
    private final FPlayerService fPlayerService;

    @Inject
    public MailPulseListener(FileResolver fileResolver, MailModule mailModule, FPlayerService fPlayerService) {
        this.command = fileResolver.getCommand().getMail();
        this.mailModule = mailModule;
        this.fPlayerService = fPlayerService;
    }

    @Pulse
    public void onPlayerJoinEvent(PlayerJoinEvent event) {
        FPlayer fReceiver = event.getPlayer();
        if (this.mailModule.isModuleDisabledFor(fReceiver)) {
            return;
        }
        List<Mail> mails = this.fPlayerService.getReceiverMails(fReceiver);
        if (mails.isEmpty()) {
            return;
        }
        for (Mail mail : mails) {
            FPlayer fPlayer = this.fPlayerService.getFPlayer(mail.sender());
            this.mailModule.sendMessage(((MailMetadata.MailMetadataBuilder)((EventMetadata.EventMetadataBuilder)((MailMetadata.MailMetadataBuilder)((MailMetadata.MailMetadataBuilder)((MailMetadata.MailMetadataBuilder)((MailMetadata.MailMetadataBuilder)MailMetadata.builder().sender(fPlayer)).filterPlayer(fReceiver, true)).format(Localization.Command.Mail::getReceiver)).destination(this.command.getDestination())).mail(mail)).message(mail.message())).build());
            this.fPlayerService.deleteMail(mail);
        }
    }
}

